<%@include file="/WEB-INF/includeTemplate.inc"%>

<div class="container ng-scope">
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li id="migasBuscarRecurso"><a href="<c:url value="/oficina/buscarRecurso?filtro=S" />"><spring:message code="migas.busquedaRecursos" /></a></li>
	  <li class="active"><spring:message code="migas.ofertas" /></li>
	</ol>
	<header>
		<div class="row cabeceraDatosComunes">
			<div class="col-sm-6 col-xs-12">
				<h2>${recurso.nombre}</h2>
			</div>
			<div class="col-sm-6 col-xs-12 text-right">
				<a href="${recurso.urlPortal}" target="_blank" class="linkFicha"><i class="icon material-icons">visibility</i><spring:message code="recursos.verFichaPortal" /></a>
			</div>
              </div>
	</header>
	<section>

		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading"><label><spring:message code="migas.ofertas" /></label></div>

			<form class="form-horizontal" id="frmListadoOfertas">
				<input type="hidden" id="codigoRecurso" name="codigo" value="${recurso.codigo}" />
				<input type="hidden" id="tipoRecurso" name="tipo" value="${recurso.tipo}" />
			</form>

			<div class="panel-body">
				<div id="divToolbarTabla">
					<button type="button" class="btn btn-light" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="comun.anadirOferta" /></span></button>
				</div>

				<div class="row">
					<div class="col-xs-12">
						<table id="tblListadoOfertas"></table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>

<!-- Modal nueva oferta-->
<div class="modal fade" id="modalModificar">
	<form class="form-horizontal" id="frmOferta">
		<input type="hidden" id="codigoRecursoPadre" name="codigoPadre" />
		<input type="hidden" id="tipoRecursoPadre" name="tipoPadre" />
		<input type="hidden" name="codigo" value="" id="codigoRecursoOferta" />
		<input type="hidden" id="rutaRecurso" name="rutaRecurso" /> <!-- Ruta del recurso en el gestor de contenidos -->

		<input type="hidden" name="imagen.cropX" id="multimediaCropX" /> <!-- Almacena la coordenada X del �rea de recorte -->
		<input type="hidden" name="imagen.cropY" id="multimediaCropY" /> <!-- Almacena la coordenada Y del �rea de recorte -->
		<input type="hidden" name="imagen.cropWidth" id="multimediaCropWidth" /> <!-- Almacena el ancho de la zona de recorte -->
		<input type="hidden" name="imagen.cropHeight" id="multimediaCropHeight" /> <!-- Almacena el alto de la zona de recorte -->
		<input type="hidden" name="imagen.imageWidth" id="multimediaImageWidth" /> <!-- Almacena el ancho de la imagen sobre la que se est� realizando el recorte -->
		<input type="hidden" name="imagen.imageHeight" id="multimediaImageHeight" /> <!-- Almacena el alto de la imagen sobre la que se est� realizando el recorte -->

		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close btnCancelarOferta" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="tituloModal"></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertOfertaModal"></div>

					<ul class="nav nav-tabs" role="tablist">
					    <li role="presentation" class="active"><a href="#tabDatosOferta" aria-controls="tabDatosOferta" role="tab" data-toggle="tab" id="aTabDatosOferta"><spring:message code="recursos.datosOferta" /></a></li>
					    <li role="presentation"><a href="#tabDireccion" aria-controls="tabDireccion" role="tab" data-toggle="tab"><spring:message code="recursos.datosContactoTab" /></a></li>
					    <li role="presentation"><a href="#tabCondiciones" aria-controls="tabCondiciones" role="tab" data-toggle="tab"><spring:message code="recursos.condicionesTab" /></a></li>
					</ul>

					<div class="tab-content margin-top-10">
						<div role="tabpanel" class="tab-pane fade in active" id="tabDatosOferta">
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.tituloOfertaCastellano" /></label>
									<input name="nombreCastellano" type="text" class="form-control" maxlength="250" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.tituloOfertaEuskera" /></label>
									<input name="nombreEuskera" type="text" class="form-control" maxlength="250" />
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.tituloOfertaIngles" /></label>
									<input name="nombreIngles" type="text" class="form-control" maxlength="250" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.tituloOfertaFrances" /></label>
									<input name="nombreFrances" type="text" class="form-control" maxlength="250" />
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.tituloOfertaAleman" /></label>
									<input name="nombreAleman" type="text" class="form-control" maxlength="250" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.precioOferta" /></label>
									<input name="precio" id="precio" type="text" class="form-control campoNumerico" data-a-sign="€" data-v-max="99999999.99" data-m-dec="2" maxlength="11" />
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.fechaInicioOferta" /></label>
									<div class="input-group date">
										<input name="fechaDesde" type="text" class="form-control campoFecha" id="fechaDesde" maxlength="10" />
										<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
									</div>
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="recursos.fechaFinOferta" /></label>
									<div class="input-group date">
										<input name="fechaHasta" type="text" class="form-control campoFecha" id="fechaHasta" maxlength="10" />
										<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
									</div>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.descripcionOfertaCastellano" /></label>
									<div><em><span><spring:message code="recursos.avisoDescripcionOferta" /></span></em></div>
									<textarea name="descripcionCastellano" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.descripcionOfertaEuskera" /></label>
									<textarea name="descripcionEuskera" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.descripcionOfertaIngles" /></label>
									<textarea name="descripcionIngles" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.descripcionOfertaFrances" /></label>
									<textarea name="descripcionFrances" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.descripcionOfertaAleman" /></label>
									<textarea name="descripcionAleman" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.imagenOferta" /></label>
									<div class="input-group">
										<input name="imagen.nombre" id="txtImagen" type="text" readonly="readonly" class="form-control" />

										<span class="input-group-btn" id="divImagenAccionSeleccionar">
											<button class="btn btn-light seleccionarImagen" type="button"><spring:message code="comun.seleccionarImagen" /></button>
										</span>

										<div class="input-group-btn" id="divImagenAccionesVerSeleccionar">
									    	<button type="button" class="btn btn-light dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><spring:message code="tabla.acciones" /> <span class="caret"></span></button>
									        <ul class="dropdown-menu dropdown-menu-right">
									          <li><a href="javascript:void(0)" id="verImagen"><i class="icon material-icons">visibility</i><span><spring:message code="accion.verImagen" /></span></a></li>
									          <li><a href="javascript:void(0)" class="seleccionarImagen"><i class="icon material-icons">file_upload</i><span><spring:message code="comun.seleccionarImagen" /></span></a></li>
									        </ul>
									   	</div><!-- /btn-group -->

									</div>

								</div>
							</div><!-- Fin Fila-->

						</div>

						<div role="tabpanel" class="tab-pane fade" id="tabCondiciones">

							<div id="divToolbarTablaCondiciones">
								<button type="button" class="btn btn-light" id="btnNuevaCondicion"><span class="btn-add material-icons">add</span><span><spring:message code="comun.anadirCondicion" /></span></button>
							</div>

							<div class="row">
								<div class="col-xs-12">
									<table id="tblListadoCondiciones"></table>
								</div>
							</div>

						</div>

						<div role="tabpanel" class="tab-pane fade" id="tabDireccion">

							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="recursos.direccion" /></label>
									<textarea name="direccion" class="form-control" maxlength="3900"></textarea>
								</div>
							</div><!-- fin fila -->

							<div class="row">
								<div class="col-sm-4 col-xs-12 form-group">
									<label><spring:message code="recursos.territorioHistorico" /></label>
									<select class="form-control" name="codigoProvincia" id="cboProvincia">
										<option></option>
										<option value="1" data-es="Álava" data-eu="Araba"><spring:message code="combo.provincia.alava" /></option>
										<option value="48" data-es="Bizkaia" data-eu="Bizkaia"><spring:message code="combo.provincia.bizkaia" /></option>
										<option value="20" data-es="Gipuzkoa" data-eu="Gipuzkoa"><spring:message code="combo.provincia.gipuzkoa" /></option>
									</select>
									<input type="hidden" name="nombreProvinciaEs" id="nombreProvinciaEs" />
									<input type="hidden" name="nombreProvinciaEu" id="nombreProvinciaEu"/>
								</div>
								<div class="col-sm-4 col-xs-12 form-group">
									<label><spring:message code="recursos.municipio" /></label>
									<select class="form-control" name="codigoMunicipio" id="cboMunicipio"></select>
									<input type="hidden" name="nombreMunicipioEs" id="nombreMunicipioEs" />
									<input type="hidden" name="nombreMunicipioEu" id="nombreMunicipioEu"/>
								</div>

								<div class="col-sm-4 col-xs-12 form-group">
									<label><spring:message code="recursos.localidad" /></label>
									<select class="form-control" name="codigoLocalidad" id="cboLocalidad"></select>
									<input type="hidden" name="nombreLocalidadEs" id="nombreLocalidadEs" />
									<input type="hidden" name="nombreLocalidadEu" id="nombreLocalidadEu"/>
								</div>

							</div><!-- fin fila -->

							<div class="row">

								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="recursos.emailOferta" /></label>
									<input name="email" type="email" class="form-control" maxlength="255" />
								</div>

								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.telefono" /></label>
									<input type="text" class="form-control" name="telefono" maxlength="3900" />
								</div>

							</div><!-- fin fila -->

							<div class="row">
								<div class="col-xs-12 form-group ">
									<label><spring:message code="recursos.webOferta" /></label>
									 <div class="input-group">
										<input name="web" type="url" class="form-control" maxlength="255" id="txtUrlWeb" />
										<span class="input-group-btn">
											<button type="button" class="btn btn-light" id="btnProbarLink" ><spring:message code="comun.probarEnlace" /></button>
										</span>
									</div>
								</div>
							</div><!-- Fin Fila-->

						</div>

					</div>

				</div>
				<div class="modal-footer">
					<button class="btn btn-light btnCancelarOferta" type="button"><spring:message code="comun.cancelar" /></button>
					<button class="btn btn-primary" type="submit"><spring:message code="comun.guardar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->
<!-- Fin modal nueva oferta-->

<div class="modal fade" id="modalEliminar">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"><spring:message code="recursos.eliminarOferta" /></h4>
			</div>
			<div class="modal-body">
				<label><spring:message code="recursos.confirmarEliminarOferta" /></label>
			</div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="comun.cancelar" /></button>
				<button class="btn btn-primary" type="button" id="btnAceptarEliminar"><spring:message code="comun.aceptar" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" id="modalCondicion">
	<form class="form-horizontal" id="frmCondicion">
		<input type="hidden" name="codigo" />
		<input type="hidden" name="codRecurso" />
		<input type="hidden" name="orden" id="hidOrdenCondicion" />
		<input type="hidden" name="idCondicion" />
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close cerrarModalCondicion" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="recursos.datosCondicion" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertCondicionModal"></div>

					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="recursos.condicionCastellano" /></label>
							<textarea name="textoEs" class="form-control" maxlength="600"></textarea>
						</div>
						<div class="col-xs-12 form-group">
							<label><spring:message code="recursos.condicionEuskera" /></label>
							<textarea name="textoEu" class="form-control" maxlength="600"></textarea>
						</div>
						<div class="col-xs-12 form-group">
							<label><spring:message code="recursos.condicionIngles" /></label>
							<textarea name="textoEn" class="form-control" maxlength="600"></textarea>
						</div>
						<div class="col-xs-12 form-group">
							<label><spring:message code="recursos.condicionFrances" /></label>
							<textarea name="textoFr" class="form-control" maxlength="600"></textarea>
						</div>
						<div class="col-xs-12 form-group">
							<label><spring:message code="recursos.condicionAleman" /></label>
							<textarea name="textoDe" class="form-control" maxlength="600"></textarea>
						</div>
					</div><!-- fin fila -->
				</div>
				<div class="modal-footer">
					<button class="btn btn-light cerrarModalCondicion" type="button"><spring:message code="comun.cancelar" /></button>
					<button class="btn btn-primary" type="button" id="btnGuardarCondicion"><spring:message code="comun.aceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->

<div class="modal fade" id="modalFoto">
	<form class="form-horizontal" id="frmImagen">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<%@include file="subir_imagen_body.inc"%> <!-- Cabecera y cuerpo de la ventana modal para el recorte de la imagen -->

				<div class="modal-footer">
					<%@include file="subir_imagen_botonera.inc"%> <!-- botonera de acciones para el recorte de la imagen -->

					<div class="row">
						<div class="col-xs-12 form-group">
							<button class="btn btn-light btnCancelarMultimedia" type="button"><spring:message code="comun.cancelar"/></button>
							<button class="btn btn-primary" type="button" id="btnAceptarImagen"><spring:message code="comun.aceptar"/></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
</div>

<%@include file="subir_imagen_preview.inc"%> <!-- modal para el preview del recorte de la imagen -->
