<%@include file="/WEB-INF/includeTemplate.inc"%>

<div class="container ng-scope">
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li id="migasBuscarRecurso"><a href="<c:url value="/oficina/buscarRecurso?filtro=S" />"><spring:message code="migas.busquedaRecursos" /></a></li>
	  <li class="active"><spring:message code="menu.multimedia" /></li>
	</ol>
	<header>
		<div class="row cabeceraDatosComunes">
			<div class="col-sm-6 col-xs-12">
				<h2>${recurso.nombre}</h2>
			</div>
			<div class="col-sm-6 col-xs-12 text-right">
				<a href="${recurso.urlPortal}" target="_blank" class="linkFicha"><i class="icon material-icons">visibility</i><spring:message code="recursos.verFichaPortal" /></a>
			</div>
        </div>
	</header>
	<section>
		<div class="alertPanel" id="divAlert"></div>
		<input type="hidden" id="codRecurso" value="${recurso.codigo}" />
		<input type="hidden" id="tipoRecurso" value="${recurso.tipo}" />
		<input type="hidden" id="rutaRecurso" value="${recurso.rutaRecurso}" />
		<input type="hidden" id="descripcionRecurso" value="${recurso.nombre}" />
		<div class="panel panel-default">
			<div class="panel-heading"><label><spring:message code="recursos.fotos" /></label></div>
			<div class="panel-body">					
				<div id="divToolbarTabla">
					<button type="button" class="btn btn-light" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="comun.anadir"/></span></button>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<table id="tblMultimedia"></table>
					</div>
				</div>
				
			</div>
		</div>
	</section>
	
	<div class="modal fade" id="modalFoto">
		<form class="form-horizontal" id="frmMultimedia">
			<input type="hidden" name="codRecurso" id="multimediaCodRecurso" />
			<input type="hidden" name="tipoRecurso" id="multimediaTipoRecurso" />
			<input type="hidden" name="imagen.descripcion" id="multimediaDescripcion" />
			<input type="hidden" name="imagen.cropX" id="multimediaCropX" /> <!-- Almacena la coordenada X del área de recorte -->
			<input type="hidden" name="imagen.cropY" id="multimediaCropY" /> <!-- Almacena la coordenada Y del área de recorte -->
			<input type="hidden" name="imagen.cropWidth" id="multimediaCropWidth" /> <!-- Almacena el ancho de la zona de recorte -->
			<input type="hidden" name="imagen.cropHeight" id="multimediaCropHeight" /> <!-- Almacena el alto de la zona de recorte -->
			<input type="hidden" name="imagen.imageWidth" id="multimediaImageWidth" /> <!-- Almacena el ancho de la imagen sobre la que se está realizando el recorte -->
			<input type="hidden" name="imagen.imageHeight" id="multimediaImageHeight" /> <!-- Almacena el alto de la imagen sobre la que se está realizando el recorte -->
			
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<%@include file="subir_imagen_body.inc"%> <!-- Cabecera y cuerpo de la ventana modal para el recorte de la imagen -->
					 
					<div class="modal-footer">
						<%@include file="subir_imagen_botonera.inc"%> <!-- botonera de acciones para el recorte de la imagen -->
						
						<div class="row">
							<div class="col-xs-12 form-group">
								<button class="btn btn-light btnCancelarMultimedia" type="button"><spring:message code="comun.cancelar"/></button>
								<button class="btn btn-primary" type="submit"><spring:message code="comun.guardar"/></button>								
							</div>
						</div>
					</div>
				</div>
			</div>
		</form>
	</div>
	
	<%@include file="subir_imagen_preview.inc"%> <!-- modal para el preview del recorte de la imagen -->
	
	
</div>