<%@include file="/WEB-INF/includeTemplate.inc"%>

<hr/>

<div class="container ng-scope margin-top-10">
	<section>
		<div class="alertPanel" id="divAlertDatosUsuario"></div>
		<div class="panel panel-default">
			<div class="panel-heading"><label><spring:message code="app.title" /></label></div>
			<div class="panel-body">
				
				<div class="row">
					<div class="col-xs-12">
						<h2><spring:message code="login.hazteVisible" /></h2>
					</div>
				</div>
				
				<div class="row">
					
					<div class="col-md-6 col-xs-12">
                   		<div class="bloqueLogin1">
                        	<img src="${staticsUrl}/images/tablet.png" alt="Eusko Jaurlaritza"  class="scale-with-grid"/>
                        </div>
                        <div class="bloqueLogin2">
                    		<h3><spring:message code="login.entraExtranetPara" /></h3>
	                        <ul class="lista">
	                        	<li><spring:message code="login.entraExtranetPara.actualizarDatos" /></li>
	                            <li><spring:message code="login.entraExtranetPara.publicarOfertas" /></li>
	                            <li><spring:message code="login.entraExtranetPara.subirImagenes" /></li>
	                        </ul>
                        	<h3><spring:message code="login.preguntasFrecuentes" /></h3>
	                        <ul class="lista">
	                        	<li><a href="#"><spring:message code="login.preguntasFrecuentes.dondeComo" /></a>
	                        		<div class="well">
	                        			<spring:message code="login.preguntasFrecuentes.dondeComo.respuesta" />
	                        		</div>	                        		
	                        	</li>
	                            <li><a href="javascript:void(0);"><spring:message code="login.preguntasFrecuentes.esGratuito" /></a>
	                            	<div class="well">
	                            		<spring:message code="login.preguntasFrecuentes.esGratuito.respuesta" />
	                            	</div>
	                            </li>
	                            <li><a href="javascript:void(0);"><spring:message code="login.preguntasFrecuentes.clave" /></a>
	                            	<div class="well">
	                            		<spring:message code="login.preguntasFrecuentes.clave.respuesta" />
	                            	</div>
	                            </li>
	                        </ul>
                        </div>
                    </div>

					<div class="col-md-6 col-xs-12">
				
                        <div class="panel panel-default">
                            <div class="panel-heading"><label><spring:message code="login.inicio" /></label></div>
                            <div class="panel-body">	
                            	<c:url var="loginUrl" value="/login" />
                            	<form action="${loginUrl}" method="post" class="form-horizontal">
									<c:if test="${param.error != null}">
										<div class="alert alert-danger">
											<p><spring:message code="login.invalido" /></p>
										</div>
									</c:if>
									<c:if test="${param.logout != null}">
										<div class="alert alert-success">
											<p><spring:message code="login.logoutCorrecto" /></p>
										</div>
									</c:if>
									<c:if test="${param.timeout != null}">
										<div class="alert alert-danger">
											<p><spring:message code="login.timeout" /></p>
										</div>
									</c:if>
									<div class="alertPanel" id="divAlertLogin"></div>
									<div class="input-group input-sm">
										<label class="input-group-addon" for="username"><i class="fa fa-user"></i></label>
										<input type="text" class="form-control" id="username" name="login" placeholder="<spring:message code="login.usuario" />" required>
									</div>
									<div class="input-group input-sm">
										<label class="input-group-addon" for="password"><i class="fa fa-lock"></i></label> 
										<input type="password" class="form-control" id="password" name="password" placeholder="<spring:message code="login.clave" />" required>
									</div>
											
	                                <input type="hidden" name="${_csrf.parameterName}"  value="${_csrf.token}" />
	
	                                <button type="submit" id="btnAcceder" class="btn btn-primary btn-block margin-top-10"><spring:message code="login.acceder" /></button>
	                                <div class="text-center margin-top-10">
	                                    <a href="javascript:void(0)" id="aRecordarPassword"><spring:message code="login.recordar" /></a>
	                                </div>
	                            </form>
                            </div>
                        </div>
                    </div>
			    </div>
		    </div>
		</div>
		
	</section>
</div>
		
<div class="modal fade" id="modalRecordar">
	<form class="form-horizontal" id="frmRecordar" method="post">	
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" id="btnCerrarRecordar" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="login.recordar" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertRecordarModal"></div>												
					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="login.email" /></label>
							<input type="email" name="email" class="form-control" />
							<em><spring:message code="login.nota" /></em>
						</div>
					</div><!-- fin fila -->
				</div>
				<div class="modal-footer">
					<button class="btn btn-light" id="btnCancelarRecordar" type="button"><spring:message code="comun.cancelar" /></button>
					<button class="btn btn-primary" type="submit"><spring:message code="comun.enviar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->