<%@include file="/WEB-INF/includeTemplate.inc"%>

<%-- <%@include file="/WEB-INF/layouts/menu_lateral.jsp" %> --%>

<div class="container ng-scope">

	<%@include file="/WEB-INF/layouts/menu_horizontal.jsp" %>
	
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li id="migasBuscarRecurso"><a href="<c:url value="/oficina/buscarRecurso?filtro=S" />"><spring:message code="migas.busquedaRecursos" /></a></li>
	  <li><a href="<c:url value="/usuario/recursos/getDatosRecurso" />?codigo=${recurso.codigo}"><spring:message code="menu.misDatos" /></a></li>
	  <li class="active"><spring:message code="menu.localizacion" /></li>
	</ol>
	<header>
		<div class="row cabeceraDatosComunes">
			<div class="col-sm-6 col-xs-12">
				<h2>${recurso.nombre}</h2>
			</div>
			<div class="col-sm-6 col-xs-12 text-right">
				<a href="${recurso.urlPortal}" target="_blank" class="linkFicha"><i class="icon material-icons">visibility</i><spring:message code="recursos.verFichaPortal" /></a>
			</div>
        </div>
	</header>
	<section>
		<div class="alertPanel" id="divAlert"></div>
		<form class="form-horizontal" id="frmGeocoder">
			<div class="panel panel-default">
				<div class="panel-heading"><label><spring:message code="recursos.georeferenciador" /></label></div>
				<div class="panel-body">
					<div class="col-md-4 col-xs-12">
						
						<ul class="nav nav-tabs" role="tablist">
						    <li role="presentation" class="active"><a href="#tabDireccion" aria-controls="tabDireccion" role="tab" data-toggle="tab"><spring:message code="recursos.direccionTab" /></a></li>
						    <li role="presentation"><a href="#tabCoordenadas" aria-controls="tabCoordenadas" role="tab" data-toggle="tab"><spring:message code="recursos.coordenadasTab" /></a></li>
						</ul>
						
						<div class="tab-content">
							<div role="tabpanel" class="tab-pane fade in active" id="tabDireccion">
								<div class="row">
									<div class="col-xs-12 form-group ">
										<label><spring:message code="recursos.direccion" /></label>
										<input type="text" class="form-control" id="direccion" value="<c:out value="${recurso.direccion }"/>" />
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 form-group ">
										<label><spring:message code="recursos.municipio" /></label>
										<input type="text" class="form-control" id="municipio" value="${recurso.municipio}" />
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12 col-xs-12 form-group ">
										<label><spring:message code="recursos.territorioHistorico" /></label>
										<input type="text" class="form-control" id="provincia" value="${recurso.provincia}" />
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12">
										<button type="button" class="btn btn-primary" id="btnLocalizar"><spring:message code="comun.localizar" /></button>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12 col-xs-12 form-group geoMenu">
										<span id="gm_info">0 <spring:message code="recursos.localizaciones"/></span><hr />
										<div id="geoList"></div>
									</div>
								</div>
								
							</div>
							<div role="tabpanel" class="tab-pane fade" id="tabCoordenadas">
								<div class="row">
									<div class="col-xs-12 form-group ">
										<label><spring:message code="recursos.latitud" /></label>
										<input type="text" class="form-control campoNumerico" name="lat" id="lat" value="${recurso.localizacion.gmLat}" data-m-dec="30" data-a-pad="false" data-a-dec="." data-a-sep="false" />
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 form-group ">
										<label><spring:message code="recursos.longitud" /></label>
										<input type="text" class="form-control campoNumerico" name="lng" id="lng" value="${recurso.localizacion.gmLng}" data-m-dec="30" data-a-pad="false" data-v-min="-999.999999999999999999999999999999" data-a-dec="." data-a-sep="false" />
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12">
										<button type="button" class="btn btn-primary" id="btnLocalizarCoordenadas"><spring:message code="comun.localizar" /></button>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-8 col-xs-12">
						<div id="map" class="mapa"></div>
					</div>
				</div>
			</div>
		</form>
			
		<form class="form-horizontal" id="frmLocalizacionRecurso">
			<input type="hidden" name="codigo" value="${recurso.codigo}" />
			<input type="hidden" name="tipo" value="${recurso.tipo}" />
			
			<div class="row">
				<div class="col-xs-12">
					<button type="submit" class="btn btn-primary"><spring:message code="comun.guardar" /></button>
				</div>
			</div>
			
			<div class="panel panel-default" id="panelGeocoder">
				<div class="panel-heading"><label><spring:message code="recursos.informacionRecurso" /></label></div>
				<div class="panel-body">
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.nombre" /></label>
							<input type="text" class="form-control" readonly="readonly" id="nombre" value="<c:out value="${recurso.nombre }"/>" />
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.direccion" /></label>
							<textarea name="localizacion.gmAddress" id="gmAddress" class="form-control" readonly="readonly" rows="2"><c:out value="${recurso.localizacion.gmAddress }"/></textarea>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4 col-xs-12 form-group ">
							<label><spring:message code="recursos.latitud" /></label>
							<input type="text" class="form-control" readonly="readonly" name="localizacion.gmLat" id="gmLat" value="${recurso.localizacion.gmLat}" />
						</div>
						<div class="col-sm-4 col-xs-12 form-group ">
							<label><spring:message code="recursos.longitud" /></label>
							<input type="text" class="form-control" readonly="readonly" name="localizacion.gmLng" id="gmLng" value="${recurso.localizacion.gmLng}" />
						</div>						
						<div class="col-sm-4 col-xs-12 form-group ">
							<label><spring:message code="recursos.zoom" /></label>
							<input type="text" class="form-control" readonly="readonly" name="localizacion.gmZoom" id="gmZoom" value="${recurso.localizacion.gmZoom}" />
						</div>
					</div>
				</div>
			</div>
						
		</form>
	</section>
</div>