<%@include file="/WEB-INF/includeTemplate.inc"%>

<div class="container ng-scope">
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li class="active"><spring:message code="migas.gestionUsuarios" /></li>
	</ol>
	<header>
		<h2><spring:message code="usuarios.buscarUsuario" /></h2>
	</header>
	<section>
		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusqueda" aria-expanded="true" aria-controls="divCriteriosBusqueda">
				<label>
					<spring:message code="comun.criteriosBusqueda" />
				</label>
				<a href="#" class="pull-right">
					<i class="icon material-icons">keyboard_arrow_up</i>
				</a>
		  	</div>
			<div class="panel-body panel-collapse collapse in" id="divCriteriosBusqueda" aria-expanded="true">
				<form class="form-horizontal" id="frmBusquedaUsuarios">
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="usuarios.dni" /></label>
							<input type="text" value="" class="form-control" name="dni" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="usuarios.nombre" /></label>
							<input type="text" value="" class="form-control" name="nombre" />
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="usuarios.apellidos" /></label>
							<input type="text" value="" class="form-control" name="apellidos" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="usuarios.usuario" /></label>
							<input type="text" value="" class="form-control" name="login"/>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="usuarios.codigoRecurso" /></label>
							<input type="text" class="form-control" name="codigoRecurso" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="usuarios.nombreRecurso" /></label>
							<input type="text" value="" class="form-control" name="nombreRecurso" />
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="usuarios.signatura" /></label>
							<input type="text" class="form-control" name="signatura" />
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 form-group">
							<button class="btn btn-light" type="button" id="btnLimpiar"><spring:message code="comun.limpiar" /></button>
							<button class="btn btn-primary" type="button" id="btnBuscar"><spring:message code="comun.buscar" /></button>
						</div>
					</div>
				</form>
			</div>
		</div>

		<div id="divToolbarTabla">
			<button type="button" class="btn btn-light" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="usuarios.anadirUsuario" /></span></button>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<table id="tblBusqueda"></table>
			</div>
		</div>
	</section>
</div>

<!-- Modal nuevo usuario-->
<div class="modal fade" id="modalModificar">
	<form class="form-horizontal" id="frmActualizarUsuario">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close btnCerrarModificarUsuario" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="tituloModal"></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertUsuarioModal"></div>
					<div class="panel panel-default">
						<div class="panel-heading"><label><spring:message code="usuarios.titulo" /></label></div>
						<div class="panel-body">
							<input type="hidden" name="idUsuario" />
							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="usuarios.recurso" /></label>
									<div class="input-group">
										<input type="hidden" name="recurso.codigo" id="codigoRecurso">
										<input type="hidden" name="recurso.signatura" id="signatura">
										<input type="hidden" name="recurso.tipo" id="tipoRecurso">
										<input type="text" name="recurso.nombre" id="nombreRecurso" readonly="readonly" class="form-control">
										<span class="input-group-btn">
											<button id="btnBuscarRecurso" type="button" class="btn btn-light"><spring:message code="usuarios.buscarRecurso" /></button>
										</span>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="usuarios.dni" /></label>
									<input type="text" name="dni" class="form-control" maxlength="9" required="required" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.nombre" /></label>
									<input type="text" name="nombre" class="form-control" maxlength="50" required="required" />
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="usuarios.apellidos" /></label>
									<input type="text" name="apellidos" class="form-control" maxlength="50" required="required" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.usuario" /></label>
									<input type="text" name="login" class="form-control" maxlength="20" required="required" />
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="usuarios.cargo" /></label>
									<input type="text" name="cargo" class="form-control" maxlength="50" required="required" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.email" /></label>
									<input type="email" name="email" class="form-control" maxlength="255" required="required" />
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="usuarios.telefono" /></label>
									<input type="tel"name="telefono" class="form-control" maxlength="20" required="required" />
								</div>
							</div>
						</div><!-- Fin panel-body-->
					</div><!-- Fin panel-default-->
				</div>
				<div class="modal-footer">
					<button class="btn btn-light btnCerrarModificarUsuario" type="button"><spring:message code="comun.cancelar" /></button>
					<button class="btn btn-primary" type="submit" id="btnAceptar"><spring:message code="comun.aceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->
<!-- Fin modal nuevo usuario-->

<!-- Modal cambiar password-->
<div class="modal fade" id="modalCambiarPassword">
	<form class="form-horizontal" id="frmCambiarPassword">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="usuarios.modificarPassword" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertCambiarPasswordModal"></div>
					<div class="panel panel-default">
						<div class="panel-body">
							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="usuarios.mensajePassword" /></label>
								</div>
							</div>
							<div class="row">
								<div class="col-xs-12 form-group">
									<label><spring:message code="usuarios.recurso" /></label>
									<input type="text" name="recurso.nombre" readonly="readonly" class="form-control">
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.usuario" /></label>
									<input type="text" name="login" readonly="readonly" class="form-control">
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.email" /></label>
									<input type="text" name="email" readonly="readonly" class="form-control">
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
				    <button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="comun.cancelar" /></button>
					<button class="btn btn-primary" type="submit"><spring:message code="usuarios.solicitarPassword" /></button>
				</div>
			</div>
		</div>
	</form>
</div>
<!-- Fin modal cambiar password-->

<!-- Modal Buscar Recurso -->
<div class="modal fade" id="modalBuscarRecurso">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" id="btnCloseRecurso" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"><spring:message code="usuarios.buscarRecurso" /></h4>
			</div>
			<div class="modal-body">
				<div class="alertPanel" id="divAlertBuscarRecursoModal"></div>
				<div class="panel panel-default">
					<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusquedaRecurso" aria-expanded="true" aria-controls="divCriteriosBusquedaRecurso">
						<label><spring:message code="comun.criteriosBusqueda" /></label>
						<a href="#" class="pull-right">
							<i class="icon material-icons">keyboard_arrow_up</i>
						</a>
					</div>
					<div class="panel-body panel-collapse collapse in" id="divCriteriosBusquedaRecurso" aria-expanded="true">
						<form class="form-horizontal" id="frmBuscarRecurso">
							<div class="row">
								<div class="col-sm-6 col-xs-12 form-group ">
									<label><spring:message code="usuarios.nombreRecurso" /></label>
									<input type="text" name="nombre" class="form-control" />
								</div>
								<div class="col-sm-6 col-xs-12 form-group">
									<label><spring:message code="usuarios.tipoRecurso" /></label>
									<select name="tipo" class="form-control">
										<option value=""></option>
										<option value="A1"><spring:message code="tipoRecurso.A1" /></option>
										<option value="E1"><spring:message code="tipoRecurso.E1" /></option>
									</select>
								</div>
							</div>
							<div class="row">
								<div class="col-xs-12 form-group">
									<button class="btn btn-light" type="button"><spring:message code="comun.limpiar" /></button>
									<button class="btn btn-primary" type="button" id="btnBuscarRecursos"><spring:message code="comun.buscar" /></button>
								</div>
							</div>
						</form>
					</div>
				</div>
					
				<!-- Resultados de búsqueda-->
				<section>
					
					<div class="row">
						<div class="col-xs-12">
							<table id="tblBusquedaRecursos"></table>
						</div>
					</div>
	
				</section>
			</div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" id="btnCancelarRecurso"><spring:message code="comun.cancelar" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->	
</div>
<!-- Fin modal buscar recurso-->
