<%@include file="/WEB-INF/includeTemplate.inc"%>

<%-- <%@include file="/WEB-INF/layouts/menu_lateral.jsp" %> --%>

<div class="container ng-scope">
	
	<%@include file="/WEB-INF/layouts/menu_horizontal.jsp" %>
	
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li id="migasBuscarRecurso"><a href="<c:url value="/oficina/buscarRecurso?filtro=S" />"><spring:message code="migas.busquedaRecursos" /></a></li>
	  <li><a href="<c:url value="/usuario/recursos/getDatosRecurso" />?codigo=${recurso.codigo}"><spring:message code="menu.misDatos" /></a></li>
	  <li class="active"><spring:message code="menu.datosGenerales" /></li>
	</ol>
	
	<div class="alert alert-info alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		<span>${mensajeAviso}</span>
	</div>
	
	<header>
		<div class="row cabeceraDatosComunes">
			<div class="col-sm-6 col-xs-12">
				<h2>${recurso.nombre}</h2>
			</div>
			<div class="col-sm-6 col-xs-12 text-right">
				<a href="${recurso.urlPortal}" target="_blank" class="linkFicha"><i class="icon material-icons">visibility</i><spring:message code="recursos.verFichaPortal" /></a>
			</div>
        </div>
	</header>
	<section>
		<div class="alertPanel" id="divAlert"></div>
		<form class="form-horizontal" id="frmDatosRecurso">
			<input type="hidden" name="codigo" value="${recurso.codigo}" />
			<input type="hidden" name="tipo" value="${recurso.tipo}" />
			<input type="hidden" name="subtipo" value="${recurso.subtipo}" />
			<input type="hidden" id="rutaRecurso" name="rutaRecurso" value="${recurso.rutaRecurso}" /> <!-- Ruta del recurso en el gestor de contenidos -->			
			
			<input type="hidden" name="imagen.cropX" id="multimediaCropX" /> <!-- Almacena la coordenada X del área de recorte -->
			<input type="hidden" name="imagen.cropY" id="multimediaCropY" /> <!-- Almacena la coordenada Y del área de recorte -->
			<input type="hidden" name="imagen.cropWidth" id="multimediaCropWidth" /> <!-- Almacena el ancho de la zona de recorte -->
			<input type="hidden" name="imagen.cropHeight" id="multimediaCropHeight" /> <!-- Almacena el alto de la zona de recorte -->
			<input type="hidden" name="imagen.imageWidth" id="multimediaImageWidth" /> <!-- Almacena el ancho de la imagen sobre la que se esté realizando el recorte -->
			<input type="hidden" name="imagen.imageHeight" id="multimediaImageHeight" /> <!-- Almacena el alto de la imagen sobre la que se esté realizando el recorte -->
		
			<div class="panel panel-default">
				<div class="panel-heading"><label><spring:message code="menu.datosGenerales" /></label></div>
				<div class="panel-body">
					
					<div class="row">
						<c:if test="${recurso.signatura != null && recurso.signatura != ''}">						
							<div class="col-sm-6 col-xs-12 form-group ">
								<label><spring:message code="recursos.signatura" /></label>
								<input type="text" class="form-control" readonly="readonly" value="${recurso.signatura}" />
							</div>
						</c:if>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="recursos.tipoRecurso" /></label>
							<input type="text" class="form-control" readonly="readonly" value="${recurso.nombreTipo}" />
						</div>
						<c:if test="${recurso.nombreSubtipo != null && recurso.nombreSubtipo != '' && (recurso.tipo == 'A1' || recurso.tipo == 'B1' || recurso.tipo == 'E1' || recurso.tipo == 'N3')}">
							<div class="col-sm-6 col-xs-12 form-group ">
								<label><spring:message code="recursos.tipo" /></label>
								<input type="text" class="form-control" readonly="readonly" value="${recurso.nombreSubtipo}" />
							</div>
						</c:if>
						<c:if test="${recurso.nombreCategoria != null && recurso.nombreCategoria != ''}">
							<div class="col-sm-6 col-xs-12 form-group ">
								<label><spring:message code="recursos.categoria" /></label>
								<input type="text" class="form-control" readonly="readonly" value="${recurso.nombreCategoria}" />
							</div>
						</c:if>
					</div>
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.nombre" /></label>
							<input type="text" class="form-control" readonly="readonly" value="<c:out value="${recurso.nombre }"/>" />
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.direccion" /></label>
							<input type="text" class="form-control" readonly="readonly" value="<c:out value="${recurso.direccion }"/>" />
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="recursos.codigoPostal" /></label>
							<input type="text" class="form-control" readonly="readonly" value="${recurso.codigoPostal}" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="recursos.municipio" /></label>
							<input type="text" class="form-control" readonly="readonly" value="${recurso.municipio}" />									
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="recursos.localidad" /></label>
							<input type="text" class="form-control" readonly="readonly" value="${recurso.localidad}" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="recursos.territorioHistorico" /></label>
							<input type="text" class="form-control" readonly="readonly" value="${recurso.provincia}" />									
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="recursos.telefono1" /></label>
							<input type="tel" name="telefono1" class="form-control" ${editable.telefono1 ? '' : 'readonly="readonly"'} value="${recurso.telefono1}" maxlength="15" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="recursos.telefono2" /></label>
							<input type="tel" name="telefono2" class="form-control" ${editable.telefono2 ? '' : 'readonly="readonly"'} value="${recurso.telefono2}" maxlength="15" />									
						</div>
					</div>
					
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.email" /></label>
							<input type="email" name="email" class="form-control" ${editable.email ? '' : 'readonly="readonly"'} value="${recurso.email}" maxlength="250" />									
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 form-group ">
							<label><spring:message code="recursos.web" /></label>
							 <div class="input-group">
								<input type="url" id="web" name="web" class="form-control" ${editable.web ? '' : 'readonly="readonly"'} value="${recurso.web}" maxlength="250" />									
								<span class="input-group-btn">
									<button class="btn btn-light" id="btnProbarEnlace"><spring:message code="comun.probarEnlace" /></button>
								</span>
							</div>
						</div>
					</div>
					
					<div id="bloqueFechas" class="row ${recurso.tipo == 'M1' || recurso.tipo == 'M2' ? '' : 'hidden'}">
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="recursos.fechaInicio" /></label>
							<div class="input-group date">
								<input type="text" class="form-control campoFecha" name="fechaInicio" id="fechaInicio" value="<fmt:formatDate pattern="${pageContext.response.locale.language == 'es' ? 'dd/MM/yyyy' : 'yyyy/MM/dd'}" value="${recurso.fechaInicio}" />" maxlength="10"/>
								<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
							</div>
						</div>
						<div class="col-sm-6 col-xs-12 form-group ">
							<label><spring:message code="recursos.fechaFin" /></label>
							<div class="input-group date">
								<input type="text" class="form-control campoFecha" name="fechaFin" id="fechaFin" value="<fmt:formatDate pattern="${pageContext.response.locale.language == 'es' ? 'dd/MM/yyyy' : 'yyyy/MM/dd'}" value="${recurso.fechaFin}" />" maxlength="10"/>
								<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
							</div>
						</div>
					</div>
					
					<!-- Si es un recurso de ficha reducida, muestro la foto principal -->
					<c:if test="${fotoPrincipal}">
						<div class="row">
							<div class="col-xs-12 form-group">
								<label><spring:message code="recursos.imagenOferta" /></label>
								<div class="input-group">
									<input name="imagen.nombre" id="txtImagen" type="text" readonly="readonly" class="form-control" value="${recurso.imagen.nombre}" />
									
									<span class="input-group-btn" id="divImagenAccionSeleccionar">											
										<button class="btn btn-light seleccionarImagen" type="button"><spring:message code="comun.seleccionarImagen" /></button>							
									</span>
									
									<div class="input-group-btn" id="divImagenAccionesVerSeleccionar">
								    	<button type="button" class="btn btn-light dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><spring:message code="tabla.acciones" /> <span class="caret"></span></button>
								        <ul class="dropdown-menu dropdown-menu-right">
								          <li><a href="javascript:void(0)" id="verImagen"><i class="icon material-icons">visibility</i><span><spring:message code="accion.verImagen" /></span></a></li>
								          <li><a href="javascript:void(0)" class="seleccionarImagen"><i class="icon material-icons">file_upload</i><span><spring:message code="comun.seleccionarImagen" /></span></a></li>
								        </ul>
								   	</div><!-- /btn-group -->
									
								</div>
								
							</div>
						</div><!-- Fin Fila-->
					</c:if>
								
				</div>
			</div>
			
			<c:if test="${editable.datosBasicos}">
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary"><spring:message code="comun.guardar" /></button>
					</div>
				</div>
			</c:if>
		</form>
	</section>
</div>

<!-- Si es un recurso de ficha reducida, muestro la foto principal -->
<c:if test="${fotoPrincipal}">
	<div class="modal fade" id="modalFoto">
		<form class="form-horizontal" id="frmImagen">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<%@include file="subir_imagen_body.inc"%> <!-- Cabecera y cuerpo de la ventana modal para el recorte de la imagen -->
					 
					<div class="modal-footer">
						<%@include file="subir_imagen_botonera.inc"%> <!-- botonera de acciones para el recorte de la imagen -->
						
						<div class="row">
							<div class="col-xs-12 form-group">
								<button class="btn btn-light btnCancelarMultimedia" type="button"><spring:message code="comun.cancelar"/></button>
								<button class="btn btn-primary" type="button" id="btnAceptarImagen"><spring:message code="comun.aceptar"/></button>								
							</div>
						</div>
					</div>
				</div>
			</div>
		</form>
	</div>
	
	<%@include file="subir_imagen_preview.inc"%> <!-- modal para el preview del recorte de la imagen -->
</c:if>
