<!DOCTYPE html>
<%@include file="/WEB-INF/includeTemplate.inc" %>
<%@taglib prefix="tiles" uri="/WEB-INF/tld/tiles-jsp.tld" %>

<html>
<head>
	<%@include file="/WEB-INF/includeTemplate.inc" %>
	<title><spring:message code="app.title" /></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	
	<!-- Metas para evitar problemas de caché -->
	<meta http-equiv="Expires" content="0" />
	<meta http-equiv="Last-Modified" content="0" />
	<meta http-equiv="Cache-Control" content="no-cache, mustrevalidate" />
	<meta http-equiv="Pragma" content="no-cache" />

	<!--
		Used for including CSRF token in JSON requests
	-->
	<meta name="_csrf" content="${_csrf.token}" />
	<meta name="_csrf_header" content="${_csrf.headerName}" />

	<%-- Estilos Aplicacion --%>
	<%@include file="/WEB-INF/layouts/includes/aa80a.styles.inc" %>

</head>
<body>
	<div class="contenedor">
		<!-- Cabecera -->
		<tiles:insertAttribute name="cabecera" />

		<!-- Menu -->
		<tiles:insertAttribute name="menu" />

		<!-- Contenidos -->
		<tiles:insertAttribute name="content"/>

		<!-- Includes JS -->
		<tiles:insertAttribute name="base-includes" />
		<tiles:insertAttribute name="includes" />
	</div>

	<!-- Capa para mostrar efecto de "cargando..." -->
	<div class="modal fade" id="loading" role="dialog" data-show="false">
		<div class="modal-dialog">
			<div class="progress">
				<div class="progress-bar progress-bar-info progress-bar-striped active ancho100" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">
				<span class="sr-only">Cargando...</span>
				</div>
			</div>
		</div>
	</div>

</body>
</html>