package com.ejie.aa80a.util.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * Excepción de validación
 * 
 *  
 */
@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR, reason = "Se ha producido una excepción de validación")
public class ValidacionException extends RuntimeException {

	private static final long serialVersionUID = 458478012139875801L;

	final private String titulo;

	/**
	 * Construye una nueva excepción de negocio con el mensaje de detalle especificado.
	 * 
	 * @param titulo the titulo
	 * @param message Detalle de la excepción.
	 */
	public ValidacionException(String titulo, String message) {
		super(message);
		this.titulo = titulo;
	}

	/**
	 * Obtiene el campo titulo
	 * 
	 * @return titulo
	 */
	public String getTitulo() {
		return this.titulo;
	}
}
