package com.ejie.aa80a.util.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * ParameterValidationException
 * 
 *  
 */
@ResponseStatus(value = HttpStatus.BAD_REQUEST, reason = "Los datos proporcionados no son adecuados.")
public class ParameterValidationException extends RuntimeException {

	private static final long serialVersionUID = 2438027595589207030L;

	/**
	 * Construye una nueva ParameterValidationException con un mensaje nulo. La causa no está inicializada y,
	 * posteriormente, puede ser inicializado por una llamada a { @ link #initCause }.
	 */
	public ParameterValidationException() {
		super();
	}

	/**
	 * Construye una nueva excepción ParameterValidationException con el mensaje de detalle especificado. La causa no
	 * está inicializada, y puede posteriormente ser inicializado por una llamada a { @ link #initCause } .
	 * 
	 * @param message Detalle de la excepción.
	 */
	public ParameterValidationException(String message) {
		super(message);
	}
}
