/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.aa80a.util;

import java.io.InputStream;
import java.util.Properties;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

/**
 * 
 *  
 * 
 */
public class WebContextParameterManager implements ApplicationContextAware {

	private static final Logger logger = LoggerFactory.getLogger(WebContextParameterManager.class);

	private WebApplicationContext webApplicationContext;

	/**
	 * Inicializaciones
	 */
	@PostConstruct()
	public void init() {
		Properties props = new Properties();
		logger.info("Loads the application context parameters");

		StaticsContainer.webAppName = this.webApplicationContext.getServletContext().getInitParameter("webAppName");
		logger.info("The applications name is: {}", StaticsContainer.webAppName);

		StaticsContainer.webId = this.webApplicationContext.getId();
		logger.info("The applications Id is: {}", StaticsContainer.webId);

		try {
			logger.debug("Loading properties from: {}/{}.properties", StaticsContainer.webAppName,
					StaticsContainer.webAppName);
			InputStream in = this
					.getClass()
					.getClassLoader()
					.getResourceAsStream(
							StaticsContainer.webAppName + "/" + StaticsContainer.webAppName + ".properties");
			props.load(in);
			in.close();
		} catch (Exception e) {
			logger.error(StackTraceManager.getStackTrace(e));
		}

		StaticsContainer.staticsUrl = props.getProperty("statics.path");
		logger.info("WARs specific Static Content URL is: {}", StaticsContainer.staticsUrl);

		StaticsContainer.modelPackageName = "com.ejie." + StaticsContainer.webAppName + ".model.";
		logger.info("Applications Model Package is: {}", StaticsContainer.modelPackageName);

		String weblogicInstance = System.getProperty("weblogic.Name");
		StaticsContainer.weblogicInstance = weblogicInstance;
		logger.info("The WebLogic Instance Name is: {}", weblogicInstance);
	}

	/**
	 * Obtiene el campo WebApplicationContext.
	 * 
	 * @return WebApplicationContext
	 */
	public WebApplicationContext getWebApplicationContext() {
		return this.webApplicationContext;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.context.ApplicationContextAware#setApplicationContext
	 * (org.springframework.context.ApplicationContext)
	 */
	@Override()
	public void setApplicationContext(ApplicationContext context) throws BeansException {
		this.webApplicationContext = (WebApplicationContext) context;
	}
}