/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.aa80a.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import com.ejie.aa80a.model.Editables;

/**
 * 
 *  
 * 
 */
public class Constants {

	/**
	 * Constructor privado. Clase de constantes.
	 */
	private Constants() {
	}

	public static final String EUSKERA = "eu";
	public static final String FRANCES = "fr";
	public static final String CASTELLANO = "es";
	public static final String INGLES = "en";
	public static final String ALEMAN = "de";

	public static final SimpleDateFormat DDMMYYYY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
	public static final SimpleDateFormat YYYYMMDD_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

	public static final SimpleDateFormat DDMMYYYY_HHMMSS_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	public static final SimpleDateFormat YYYYMMDD_HHMMSS_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	public static final SimpleDateFormat HHMMSS_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

	// valor del campo ACTIVO de la tabla TOP_EUSKADI cuando se trata de un recurso TOP
	// public static final String RECURSO_TOP_ACTIVO = "S";
	public static final Integer RECURSO_TOP_ACTIVO = 1;

	// Tipos de recurso
	public static final String ALOJAMIENTO = "A1";
	public static final String RESTAURACION = "B1";
	public static final String AEROPUERTO = "C1";
	public static final String COMPANIAS_TRANSPORTE = "C2";
	public static final String ESTACIONES = "C3";
	public static final String PARKINGS = "C6";
	public static final String TERRITORIOS_HISTORICOS = "D1";
	public static final String LOCALIDAD = "D2";
	public static final String DESTINOS = "D3";
	public static final String RUTAS = "D4";
	public static final String ETAPAS = "D5";
	public static final String EXPERIENCIAS = "D6";
	public static final String OFICINA_TURISMO = "E1";
	public static final String PLAYAS = "G1";
	public static final String ESPACIOS_NATURALES = "G2";
	public static final String TEATROS_CINES = "H1";
	public static final String ARTESANOS_ASOCIACIONES = "H10";
	public static final String CULTURA = "H4";
	public static final String PATRIMONIO_CULTURAL = "H5";
	public static final String PUERTOS_PESQUEROS = "H6";
	public static final String INSTALACIONES_DEPORTIVAS = "I2";
	public static final String EMPRESAS_ALQUILER_DEPORTIVO = "I31";
	public static final String EMPRESAS_TURISMO_ACTIVO = "I32";
	public static final String PLATOS_TIPICOS = "J1";
	public static final String PRODUCTOS_TIERRA = "J2";
	// public static final String FERIAS_MERCADOS = "J3";
	public static final String ESCUELAS_HOSTELERIA = "J4";
	public static final String PLAZAS_TOROS = "K1";
	// public static final String LOCALES_NOCHE = "K10";
	public static final String PARQUES_TEMATICOS = "K3";
	public static final String AQUARIUMS = "K5";
	public static final String CASINOS = "K7";
	public static final String ZONAS_BARES = "K8";
	public static final String ZONAS_TIENDAS = "L1";
	public static final String TIENDAS = "L2";
	public static final String CENTROS_COMERCIALES = "L3";
	public static final String AGENDA = "M1";
	public static final String OFERTAS = "M2";
	public static final String PALACIOS_CONGRESO = "N1";
	public static final String RECINTOS_FERIALES = "N2";
	public static final String EMPRESAS_RELACIONADAS = "N3";
	public static final String N3_AGENCIAS_VIAJES = "N3_AGENCIAS"; // para subtipos de N3 0004,0005,0007 de agencias de
																	// viajes
	public static final String N3_CONVENTION_BUREAU = "N3_CONVENTION_BUREAU"; // para subtipos de N3 0004,0005,0007 de
																				// agencias de viajes

	public static final String EMPRESAS_SALUD = "N5";
	// public static final String NOVEDADES = "O1";
	public static final String RECURSO_TOP = "TOP";

	// Subtipos de N3 para agencias de viajes
	public static final String N3_AGENCIA_VIAJES_MINORISTA = "0004";
	public static final String N3_AGENCIA_VIAJES_MAYORISTA = "0005";
	public static final String N3_AGENCIA_VIAJES_MINORISTA_MAYORISTA = "0007";
	public static final String N3_SUBTIPO_CONVENTION_BUREAU = "0009";

	// Tablas por tipo de recursos
	public static final String TABLA_A1 = "ALOJAMIENTO";
	public static final String TABLA_B1 = "RESTAURACION";
	public static final String TABLA_C1 = "AEROPUERTO";
	public static final String TABLA_C2 = "COMPANIASTRANSPORTE";
	public static final String TABLA_C3 = "ESTACIONES";
	public static final String TABLA_C6 = "PARKINGS";
	public static final String TABLA_D1 = "TERRITORIOSHISTORICOS";
	public static final String TABLA_D2 = "LOCALIDAD";
	public static final String TABLA_D3 = "DESTINOS";
	public static final String TABLA_D4 = "RUTAS";
	public static final String TABLA_D5 = "ETAPAS";
	public static final String TABLA_D6 = "EXPERIENCIASTOP";
	public static final String TABLA_E1 = "OFICINASTURISMO";
	public static final String TABLA_G1 = "PLAYAS";
	public static final String TABLA_G2 = "ESPACIOSNATURALES";
	public static final String TABLA_H1 = "TEATROSYCINES";
	public static final String TABLA_H10 = "ARTESANOSYASOCIACIONES";
	public static final String TABLA_H4 = "CULTURA";
	public static final String TABLA_H5 = "PATRIMONIOCULTURAL";
	public static final String TABLA_H6 = "PUERTOSPESQUEROS";
	public static final String TABLA_I2 = "INSTALACIONESDEPORTIVAS";
	public static final String TABLA_I31 = "EMPRESASALQUILERDEPORTIVO";
	public static final String TABLA_I32 = "EMPRESASTURISMOACTIVO";
	public static final String TABLA_J1 = "PLATOSTIPICOS";
	public static final String TABLA_J2 = "PRODUCTOSTIERRA";
	// public static final String TABLA_J3 = "FERIASMERCADOS";
	public static final String TABLA_J4 = "ESCUELASHOSTELERIA";
	public static final String TABLA_K1 = "PLAZASTOROS";
	// public static final String TABLA_K10 = "LOCALESNOCHE";
	public static final String TABLA_K3 = "PARQUESTEMATICOS";
	public static final String TABLA_K5 = "AQUARIUMS";
	public static final String TABLA_K7 = "CASINOS";
	public static final String TABLA_K8 = "ZONASBARES";
	public static final String TABLA_L1 = "ZONATIENDAS";
	public static final String TABLA_L2 = "TIENDAS";
	public static final String TABLA_L3 = "CENTROSCOMERCIALES";
	public static final String TABLA_M1 = "AGENDA";
	public static final String TABLA_M2 = "OFERTAS";
	public static final String TABLA_N1 = "PALACIOSCONGRESO";
	public static final String TABLA_N2 = "RECINTOSFERIALES";
	public static final String TABLA_N3 = "EMPRESASRELACIONADAS";
	public static final String TABLA_N5 = "EMPRESASSALUD";
	// public static final String TABLA_O1 = "NOVEDADES";

	// contentType por tipo de recurso
	public static final HashMap<String, String> CONTENT_TYPE_MAP = new HashMap<String, String>();
	static {
		CONTENT_TYPE_MAP.put("A", "a_alojamiento");
		CONTENT_TYPE_MAP.put("B", "b_restauracion");
		CONTENT_TYPE_MAP.put("C", "c_transporte_y_movilidad");
		CONTENT_TYPE_MAP.put("D", "d_destinos_turisticos");
		CONTENT_TYPE_MAP.put("E", "e_oficinas_turisticas");
		CONTENT_TYPE_MAP.put("G", "g_naturaleza");
		CONTENT_TYPE_MAP.put("H", "h_cultura_y_patrimonio");
		CONTENT_TYPE_MAP.put("I", "i_deportes");
		CONTENT_TYPE_MAP.put("J", "j_gastronomia");
		CONTENT_TYPE_MAP.put("K", "k_ocio");
		CONTENT_TYPE_MAP.put("L", "l_compras");
		CONTENT_TYPE_MAP.put("M", "evento");
		CONTENT_TYPE_MAP.put("N", "n_negocios");
		CONTENT_TYPE_MAP.put("O", "noticia");
	}

	// Páginas del Portal
	public static final String PAGINA_FICHA = "aa30-12375";
	public static final String PAGINA_FICHA_EXPERIENCIAS = "aa30-12378";

	// Sufijo url ficha
	public static final String HTML_FICHA = "-ficha2.html";

	// Mapa que indica por tipo de recurso si se pueden o no editar los datos básicos
	public static final HashMap<String, Editables> EDITABLES_MAP = new HashMap<String, Editables>();
	static {
		// Editables(datosBasicos, servicios, localizacion, multimedia, precios, ofertas, email, telefono1,
		// telefono2, web)
		EDITABLES_MAP.put("A1", new Editables(false, true, true, true, true, true, false, false, false, false));
		EDITABLES_MAP.put("B1", new Editables(true, true, true, true, false, true, true, true, true, true));
		EDITABLES_MAP.put("C1", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("C2", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("C3", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("C6", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("D1", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("D2", new Editables(true, false, false, true, false, false, false, false, false, true));
		EDITABLES_MAP.put("D3", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("D4", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("D5", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("D6", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("E1", new Editables(true, true, true, true, false, true, true, true, true, true));
		EDITABLES_MAP.put("G1", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("G2", new Editables(true, false, false, true, false, false, false, false, false, true));
		EDITABLES_MAP.put("H1", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("H10", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("H4", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("H5", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("H6", new Editables(true, false, true, true, false, false, false, true, true, false));
		EDITABLES_MAP.put("I2", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("I31", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("I32", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("J1", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("J2", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("J4", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("K1", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("K3", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("K5", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("K7", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("K8", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("L1", new Editables(false, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("L2", new Editables(true, false, true, false, false, false, false, true, true, true));
		EDITABLES_MAP.put("L3", new Editables(true, false, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put("M1", new Editables(true, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("M2", new Editables(true, false, false, true, false, false, false, false, false, false));
		EDITABLES_MAP.put("N1", new Editables(true, false, true, true, false, false, true, true, true, true));
		EDITABLES_MAP.put("N2", new Editables(true, false, true, true, false, false, true, true, true, true));

		EDITABLES_MAP.put("N3", new Editables(true, true, true, false, false, false, true, true, true, true));
		EDITABLES_MAP.put(N3_AGENCIAS_VIAJES, new Editables(true, false, true, false, false, true, false, false, false,
				false)); // para subtipos de N3 0004,0005,0007 de agencias de viajes
		EDITABLES_MAP.put(N3_CONVENTION_BUREAU, new Editables(true, true, true, true, false, false, true, true, true,
				true)); // para subitpo N3 0009 (convention bureau) activamos la opción multimedia porque tiene
						// ficha base

		EDITABLES_MAP.put("N5", new Editables(true, false, true, true, false, false, true, true, true, true));
	}

	/** campos pendientes traducir */
	public static final int PT_NO_PENDIENTE_TRADUCIR = 0;
	public static final int PT_PENDIENTE_TRADUCIR = 1;
	public static final int PT_PENDIENTE_TRADUCIR_CASTELLANO = 2;

	// Estados de una sugerencia
	public static final String SUGERENCIA_ENVIADA = "E";
	public static final String SUGERENCIA_VISTA = "V";

	// Estados de una notificación
	public static final String NOTIFICACION_ENVIADA = "E";
	public static final String NOTIFICACION_VISTA = "V";

	// Tipos de actuaciones sobre un recurso, se almacena en los registros del histórico
	// D - Datos, S - Servicios, L - Localización, G - Sugerencias, P - Precios, M - Multimedia, O - Ofertas
	public static final String ACTUALIZACION_DATOS = "D";
	public static final String ACTUALIZACION_SERVICIOS = "S";
	public static final String ACTUALIZACION_LOCALIZACION = "L";
	public static final String ACTUALIZACION_SUGERENCIAS = "G";
	public static final String ACTUALIZACION_PRECIOS = "P";
	public static final String ACTUALIZACION_MULTIMEDIA = "M";
	public static final String ACTUALIZACION_OFERTAS = "O";

	// Estados de un registro de histórico
	// E - Enviada, R - Realizada, X - Error, V - Vista
	public static final String ACTUALIZACION_ENVIADA = "E";
	public static final String ACTUALIZACION_REALIZADA = "R";
	public static final String ACTUALIZACION_ERROR = "X";
	public static final String ACTUALIZACION_VISTA = "V";

	// Tipo de multimedia
	public static final Integer MULTIMEDIA_IMAGEN = 1;
	public static final Integer MULTIMEDIA_VIDEO = 2;
	public static final Integer MULTIMEDIA_DOCUMENTO = 3;
	public static final Integer MULTIMEDIA_OTRO = 4;

	// Tipos de imagen
	public static final Integer TIPO_IMAGEN_PRINCIPAL = 0;
	public static final Integer TIPO_IMAGEN_MINIATURA_1 = 1;
	public static final Integer TIPO_IMAGEN_MINIATURA_2 = 2;
	public static final Integer TIPO_IMAGEN_MINIATURA_3 = 3;
	public static final Integer TIPO_IMAGEN_MINIATURA_4 = 4;
	public static final Integer TIPO_IMAGEN_MINIATURA_5 = 5;
	public static final Integer TIPO_IMAGEN_MINIATURA_6 = 6;
	public static final Integer TIPO_IMAGEN_MINIATURA_7 = 7;
	public static final Integer TIPO_IMAGEN_MINIATURA_8 = 8;
	public static final Integer TIPO_IMAGEN_MINIATURA_LISTADO_1 = 9;
	public static final Integer TIPO_IMAGEN_MINIATURA_LISTADO_2 = 10;
	public static final Integer TIPO_IMAGEN_MINIATURA_FICHA_REDUCIDA = 11;
	public static final Integer TIPO_IMAGEN_GALERIA = 20;

	// Proporciones imagen
	public static final String PROPORCION_IMAGEN_1 = "2/1";
	public static final String PROPORCION_IMAGEN_2 = "3/2";
	public static final String PROPORCION_IMAGEN_3 = "3/5";
	public static final String PROPORCION_IMAGEN_4 = "4/3";
	public static final String PROPORCION_IMAGEN_5 = "4/5";
	public static final String PROPORCION_IMAGEN_6 = "5/3";
	public static final String PROPORCION_IMAGEN_7 = "6/5";
	public static final String PROPORCION_IMAGEN_8 = "7/4";
	public static final String PROPORCION_IMAGEN_9 = "8/5";
	public static final String PROPORCION_IMAGEN_10 = "9/16";
	public static final String PROPORCION_IMAGEN_11 = "9/5";

	/**
	 * Acción a de integración con AA80T. Valores posibles: 1 (regenerar y publicar recurso), 2 (crear oferta en el
	 * Gestor de Contenidos), 3 (subir contenido multimedia al Gestor de Contenidos), 4 (eliminar oferta)
	 */
	public static final String ACCION_REGENERAR_PUBLICAR = "1";
	public static final String ACCION_CREAR_OFERTA = "2";
	public static final String ACCION_SUBIR_MULTIMEDIA = "3";
	public static final String ACCION_ELIMINAR_OFERTA = "4";

	/** Acciones */
	public static final int ACCION_CREACION_RECURSO = 1;
	public static final int ACCION_PENDIENTE_PUBLICACION = 2;
	public static final int ACCION_PUBLICAR = 3;
	public static final int ACCION_EDICION = 4;
	public static final int ACCION_REVISION = 5;
	public static final int ACCION_SEGUIMIENTO = 6;
	public static final int ACCION_DESPUBLICAR = 7;

	/**
	 * Tamaño imágenes de la sección Multimedia por cada tipo de recurso
	 */
	public static final HashMap<String, Object> MAPA_DATOS_IMAGEN_RECURSO = new HashMap<String, Object>();
	static {
		// TABLA_TIPO_LIMITE
		MAPA_DATOS_IMAGEN_RECURSO.put(ALOJAMIENTO, "385x220");// "A1";
		MAPA_DATOS_IMAGEN_RECURSO.put(RESTAURACION, "385x220");// "B1";
		MAPA_DATOS_IMAGEN_RECURSO.put(AEROPUERTO, "385x220");// "C1";
		MAPA_DATOS_IMAGEN_RECURSO.put(COMPANIAS_TRANSPORTE, "385x220");// "C2";
		MAPA_DATOS_IMAGEN_RECURSO.put(ESTACIONES, "385x220");// "C3";
		MAPA_DATOS_IMAGEN_RECURSO.put(PARKINGS, "385x220");// "C6";
		MAPA_DATOS_IMAGEN_RECURSO.put(TERRITORIOS_HISTORICOS, "385x220");// "D1";
		MAPA_DATOS_IMAGEN_RECURSO.put(LOCALIDAD, "385x220");// "D2";
		MAPA_DATOS_IMAGEN_RECURSO.put(DESTINOS, "385x220");// "D3";
		MAPA_DATOS_IMAGEN_RECURSO.put(RUTAS, "385x220");// "D4";
		MAPA_DATOS_IMAGEN_RECURSO.put(ETAPAS, "385x220");// "D5";
		MAPA_DATOS_IMAGEN_RECURSO.put(EXPERIENCIAS, "385x220");// "D6";
		MAPA_DATOS_IMAGEN_RECURSO.put(OFICINA_TURISMO, "385x220");// "E1";
		MAPA_DATOS_IMAGEN_RECURSO.put(PLAYAS, "385x220");// "G1";
		MAPA_DATOS_IMAGEN_RECURSO.put(ESPACIOS_NATURALES, "385x220");// "G2";
		MAPA_DATOS_IMAGEN_RECURSO.put(TEATROS_CINES, "385x220");// "H1";
		MAPA_DATOS_IMAGEN_RECURSO.put(ARTESANOS_ASOCIACIONES, "385x220");// "H10";
		MAPA_DATOS_IMAGEN_RECURSO.put(CULTURA, "385x220");// "H4";
		MAPA_DATOS_IMAGEN_RECURSO.put(PATRIMONIO_CULTURAL, "385x220");// "H5";
		MAPA_DATOS_IMAGEN_RECURSO.put(PUERTOS_PESQUEROS, "385x220");// "H6";
		MAPA_DATOS_IMAGEN_RECURSO.put(INSTALACIONES_DEPORTIVAS, "385x220");// "I2";
		MAPA_DATOS_IMAGEN_RECURSO.put(EMPRESAS_ALQUILER_DEPORTIVO, "385x220");// "I31";
		MAPA_DATOS_IMAGEN_RECURSO.put(EMPRESAS_TURISMO_ACTIVO, "385x220");// "I32";
		MAPA_DATOS_IMAGEN_RECURSO.put(PLATOS_TIPICOS, "385x220");// "J1";
		MAPA_DATOS_IMAGEN_RECURSO.put(PRODUCTOS_TIERRA, "385x220");// "J2";
		MAPA_DATOS_IMAGEN_RECURSO.put(ESCUELAS_HOSTELERIA, "385x220");// "J4";
		MAPA_DATOS_IMAGEN_RECURSO.put(PLAZAS_TOROS, "385x220");// "K1";
		MAPA_DATOS_IMAGEN_RECURSO.put(PARQUES_TEMATICOS, "385x220");// "K3";
		MAPA_DATOS_IMAGEN_RECURSO.put(AQUARIUMS, "385x220");// "K5";
		MAPA_DATOS_IMAGEN_RECURSO.put(CASINOS, "385x220");// "K7";
		MAPA_DATOS_IMAGEN_RECURSO.put(ZONAS_BARES, "385x220");// "K8";
		MAPA_DATOS_IMAGEN_RECURSO.put(ZONAS_TIENDAS, "385x220");// "L1";
		MAPA_DATOS_IMAGEN_RECURSO.put(TIENDAS, "385x220");// "L2";
		MAPA_DATOS_IMAGEN_RECURSO.put(CENTROS_COMERCIALES, "385x220");// "L3";
		MAPA_DATOS_IMAGEN_RECURSO.put(AGENDA, "385x220");// "M1";
		MAPA_DATOS_IMAGEN_RECURSO.put(OFERTAS, "310x180");// "M2";
		MAPA_DATOS_IMAGEN_RECURSO.put(PALACIOS_CONGRESO, "385x220");// "N1";
		MAPA_DATOS_IMAGEN_RECURSO.put(RECINTOS_FERIALES, "385x220");// "N2";
		MAPA_DATOS_IMAGEN_RECURSO.put(EMPRESAS_RELACIONADAS, "385x220");// "N3";
		MAPA_DATOS_IMAGEN_RECURSO.put(EMPRESAS_SALUD, "385x220");// "N5";
		MAPA_DATOS_IMAGEN_RECURSO.put(RECURSO_TOP, "640x320");// "Recursos TOP";
	}

	public static final String FORMATO_APAISADO = "A";
	public static final String FORMATO_VERTICAL = "V";

	public static final Integer MULTIMEDIA_PUBLICABLE = 1;
	public static final Integer MULTIMEDIA_NO_PUBLICABLE = 0;

	// Usuario genérico de actualización de Gaurkotu en tablas de AA80T
	public static final String USUARIO_GAURKOTU = "GAURKOTU";

	// subtipos de alojamiento
	public static final String TIPO_ALOJAMIENTO_HOTEL = "H";
	public static final String TIPO_ALOJAMIENTO_CASA_RURAL = "X";
	public static final String TIPO_ALOJAMIENTO_AGROTURISMO = "K";

	public static final int PROVINCIA_ALAVA = 1;
	public static final int PROVINCIA_BIZKAIA = 48;
	public static final int PROVINCIA_GIPUZKOA = 20;

	/**
	 * Array con los tipos de recursos que tiene ficha reducida
	 */
	public static final List<String> TIPO_RECURSOS_FICHA_REDUCIDAD = Arrays.asList(COMPANIAS_TRANSPORTE, ESTACIONES,
			PARKINGS, ARTESANOS_ASOCIACIONES, EMPRESAS_ALQUILER_DEPORTIVO, TIENDAS, CENTROS_COMERCIALES,
			EMPRESAS_RELACIONADAS);

	/**
	 * Tamaño de la foto principal de la ficha reducida
	 */
	public static final int FICHA_REDUCIDA_FOTO_WIDTH = 80;
	public static final int FICHA_REDUCIDA_FOTO_HEIGHT = 50;

	public static final String ESTADO_RECURSO_PUBLICADO = "PU";
	public static final String ESTADO_RECURSO_EN_EDICION = "EE";

	/** subtipos del alojamiento */
	public static final String ALOJAMIENTO_SUBTIPO_HOTELAPARTAMENTO = "6";
	public static final String ALOJAMIENTO_SUBTIPO_PENSION = "7";
	public static final String ALOJAMIENTO_SUBTIPO_ALBERGUE = "B";
	public static final String ALOJAMIENTO_SUBTIPO_CASARURAL = "X";
	public static final String ALOJAMIENTO_SUBTIPO_AGROTURISMO = "K";
	public static final String ALOJAMIENTO_SUBTIPO_CAMPING = "P";
	public static final String ALOJAMIENTO_SUBTIPO_APARTAMENTO = "T";
	public static final String ALOJAMIENTO_SUBTIPO_HOTEL = "H";

	// modalidades para el subtipo Camping (P)
	public static final String MODALIDAD_CAMPING_CAMPING = "C";
	public static final String MODALIDAD_CAMPING_AUTOCARAVANA = "V";
	public static final String MODALIDAD_CAMPING_AREA_NATURAL_ACAMPADA = "A";

}