package com.ejie.aa80a.service;

import java.util.List;

import com.ejie.aa80a.model.FiltroUsuario;
import com.ejie.aa80a.model.Usuario;

/**
 * Interfaz de los servicios de acceso a los datos del usuario
 * 
 *  
 */
public interface UsuarioService {

	/**
	 * Obtiene los datos del usuario a partir del login
	 * 
	 * @param login Login del usuario
	 * 
	 * @return Objeto con los datos del usuario
	 */
	Usuario findByUsuario(String login);

	/**
	 * Obtiene los usuarios dependiendo del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return lista con los usuarios.
	 */
	List<Usuario> findByCriteria(FiltroUsuario filtro);

	/**
	 * Obtiene el número de los usuarios que cumplen el filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return int número de usuarios que cumplen el filtro aplicado.
	 */
	int findByCountCriteria(FiltroUsuario filtro);

	/**
	 * Envía un correo con una nueva password generada al usuario.
	 * 
	 * @param email Email del usuario
	 * 
	 * @return Resultado de la operación
	 */
	String recordarPassword(String email);

	/**
	 * Guardar los datos del usuario.
	 * 
	 * @param usuario Objeto con los datos del usuario
	 * 
	 * @return Resultado de la operación
	 */
	String guardarUsuario(Usuario usuario);

	/**
	 * Crea un nuevo usuario.
	 * 
	 * @param usuario Objeto con los datos del usuario
	 * 
	 * @return Resultado de la operación
	 */
	String crearUsuario(Usuario usuario);

	/**
	 * Envía un correo con una nueva password generada al usuario.
	 * 
	 * @param password Password actual
	 * @param nuevaPassword Nueva password
	 * 
	 * @return Resultado de la operación
	 */
	String cambiarPassword(String password, String nuevaPassword);

	/**
	 * Elimina un usuario.
	 * 
	 * @param idUsuario Id del usuario a eliminar
	 * 
	 * @return Resultado de la operación
	 */
	String eliminarUsuario(Integer idUsuario);

}