package com.ejie.aa80a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa80a.dao.SugerenciaDao;
import com.ejie.aa80a.model.FiltroSugerencia;
import com.ejie.aa80a.model.Sugerencia;
import com.ejie.aa80a.util.Constants;

/**
 * Clase que implementa los servicios de acceso a datos de Sugerencias
 * 
 *  
 * 
 */
@Service(value = "SugerenciaService")
@Transactional()
public class SugerenciaServiceImpl implements SugerenciaService {

	@Autowired()
	private SugerenciaDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.UsuarioService#findByCriteria(com.ejie.aa80a.model.FiltroUsuario)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Sugerencia> findSugerenciaByCriteria(FiltroSugerencia filtro) {
		return this.dao.findSugerenciaByCriteria(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.UsuarioService#findByCountCriteria(com.ejie.aa80a.model.FiltroUsuario)
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findSugerenciaByCountCriteria(FiltroSugerencia filtro) {
		return this.dao.findSugerenciaByCountCriteria(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.SugerenciaService#actualizarEstadoSugerenciaVista(java.util.List)
	 */
	@Override()
	public String actualizarEstadoSugerenciaVista(List<Long> codigos) {

		for (Long codigo : codigos) {

			// Hacemos un update
			this.dao.actualizarEstadoSugerencia(codigo, Constants.SUGERENCIA_VISTA);
		}

		return "OK";
	}

}
