package com.ejie.aa80a.service;

import java.util.List;

import com.ejie.aa80a.model.FiltroSugerencia;
import com.ejie.aa80a.model.Sugerencia;

/**
 * Interfaz de los servicios de acceso a los datos de Sugerencias
 * 
 *  
 * 
 */
public interface SugerenciaService {

	/**
	 * Devuelve el listado de Sugerencias
	 * 
	 * @param filtro datos del filtro de Sugerenciaes
	 * @return listado de Sugerencias
	 */
	List<Sugerencia> findSugerenciaByCriteria(FiltroSugerencia filtro);

	/**
	 * Devuelve el número de filas totales de la consulta
	 * 
	 * @param filtro datos del filtro de Sugerencias
	 * @return número de filas
	 */
	int findSugerenciaByCountCriteria(FiltroSugerencia filtro);

	/**
	 * Actualiza una lista de sugerencias a estado "Vista"
	 * 
	 * @param codigos lista de códigos de sugerencia a actualizar
	 * @return resultado de la operación
	 */
	String actualizarEstadoSugerenciaVista(List<Long> codigos);

}