package com.ejie.aa80a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa80a.dao.NotificacionDao;
import com.ejie.aa80a.model.FiltroNotificacion;
import com.ejie.aa80a.model.Notificacion;
import com.ejie.aa80a.util.Constants;

/**
 * Clase que implementa los servicios de acceso a datos de Notificaciones
 * 
 *  
 * 
 */
@Service(value = "notificacionService")
@Transactional()
public class NotificacionServiceImpl implements NotificacionService {

	@Autowired()
	private NotificacionDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.UsuarioService#findByCriteria(com.ejie.aa80a.model.FiltroUsuario)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Notificacion> findNotificacionByCriteria(FiltroNotificacion filtro) {
		return this.dao.findNotificacionByCriteria(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.UsuarioService#findByCountCriteria(com.ejie.aa80a.model.FiltroUsuario)
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findNotificacionByCountCriteria(FiltroNotificacion filtro) {
		return this.dao.findNotificacionByCountCriteria(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.NotificacionService#actualizarEstadoNotificacion(com.ejie.aa80a.model.Notificacion)
	 */
	@Override()
	public String actualizarEstadoNotificacionVista(List<Long> codigos) {

		for (Long codigo : codigos) {

			// Hacemos un update
			this.dao.actualizarEstadoNotificacion(codigo, Constants.NOTIFICACION_VISTA);
		}

		return "OK";
	}

}
