package com.ejie.aa80a.service;

import java.util.List;

import com.ejie.aa80a.model.FiltroNotificacion;
import com.ejie.aa80a.model.Notificacion;

/**
 * Interfaz de los servicios de acceso a los datos de Notificaciones
 * 
 *  
 * 
 */
public interface NotificacionService {

	/**
	 * Devuelve el listado de notificaciones
	 * 
	 * @param filtro datos del filtro de notificaciones
	 * @return listado de notificaciones
	 */
	List<Notificacion> findNotificacionByCriteria(FiltroNotificacion filtro);

	/**
	 * Devuelve el número de filas totales de la consulta
	 * 
	 * @param filtro datos del filtro de notificaciones
	 * @return número de filas
	 */
	int findNotificacionByCountCriteria(FiltroNotificacion filtro);

	/**
	 * Actualiza el estado de una lista de notificaciones
	 * 
	 * @param codigos Lista de códigos de las notificaciones a actualizar
	 * @return resultado de la operación
	 */
	String actualizarEstadoNotificacionVista(List<Long> codigos);

}