package com.ejie.aa80a.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

/**
 * Clase que implementa los servicios de envío de correo.
 * 
 *  
 */
@Service(value = "mailService")
public class MailServiceImpl implements MailService {

	/** The simple mail message. */
	@Autowired()
	private SimpleMailMessage simpleMailMessage;

	/** The mail sender. */
	@Autowired()
	private JavaMailSender mailSender;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.MailService#sendMail(java.lang.String, java.lang.String)
	 */
	@Override()
	public void sendMail(String to, String body) {
		this.simpleMailMessage.setTo(to);
		this.simpleMailMessage.setText(body);
		this.mailSender.send(this.simpleMailMessage);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.MailService#sendMail(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override()
	public void sendMail(String to, String subject, String body) {
		this.simpleMailMessage.setTo(to);
		this.simpleMailMessage.setSubject(subject);
		this.simpleMailMessage.setText(body);
		this.mailSender.send(this.simpleMailMessage);

	}

}
