package com.ejie.aa80a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa80a.dao.FcaDao;
import com.ejie.aa80a.model.Localidad;
import com.ejie.aa80a.model.Municipio;

/**
 * Clase que implementa los servicios de acceso a datos de las tablas FCA
 * 
 *  
 * 
 */
@Service(value = "fcaService")
@Transactional()
public class FcaServiceImpl implements FcaService {

	@Autowired()
	private FcaDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.FcaService#findMunicipios(com.ejie.aa80a.model.Municipio)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Municipio> findMunicipios(Municipio filtroMunicipio) {
		return this.dao.findMunicipios(filtroMunicipio);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.FcaService#findLocalidades(com.ejie.aa80a.model.Localidad)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Localidad> findLocalidades(Localidad filtroLocalidad) {
		return this.dao.findLocalidades(filtroLocalidad);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.FcaService#findMunicipiosByProvincia(com.ejie.aa80a.model.Municipio)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Municipio> findMunicipiosByProvincia(Municipio filtroMunicipio) {
		return this.dao.findMunicipiosByProvincia(filtroMunicipio);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.service.FcaService#findLocalidadesByMunicipio(com.ejie.aa80a.model.Localidad)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Localidad> findLocalidadesByMunicipio(Localidad filtroLocalidad) {
		return this.dao.findLocalidadesByMunicipio(filtroLocalidad);
	}
}
