package com.ejie.aa80a.service;

import java.util.List;

import com.ejie.aa80a.model.Localidad;
import com.ejie.aa80a.model.Municipio;

/**
 * Interfaz de los servicios de acceso a las tablas FCA
 * 
 *  
 * 
 */
public interface FcaService {

	/**
	 * Busca y devuelve la lista de municipios
	 * 
	 * @param filtroMunicipio filtro aplicado
	 * @return lista de municipios
	 */
	List<Municipio> findMunicipios(Municipio filtroMunicipio);

	/**
	 * Busca y devuelve la lista de localidades
	 * 
	 * @param filtroLocalidad filtro aplicado
	 * @return lista de localidades
	 */
	List<Localidad> findLocalidades(Localidad filtroLocalidad);

	/**
	 * Devuelve la lista de municipios de una provincia
	 * 
	 * @param filtroMunicipio filtro aplicado
	 * @return lista de municipios
	 */
	List<Municipio> findMunicipiosByProvincia(Municipio filtroMunicipio);

	/**
	 * Devuelve la lista de localidades de un municipio y provincia
	 * 
	 * @param filtroLocalidad filtro aplicado
	 * @return lista de localidades
	 */
	List<Localidad> findLocalidadesByMunicipio(Localidad filtroLocalidad);

}