package com.ejie.aa80a.model;

import java.util.Collection;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

/**
 * Clase que contiene los datos un usuario que se mantendrán en el contexto de seguridad
 * 
 *  
 */
public class UsuarioDetalles extends User {

	private static final long serialVersionUID = 6008232749717393542L;

	/** Código de recurso. */
	private Long codigoRecurso;

	/** Nombre. */
	private String nombre;

	/** Apellidos. */
	private String apellidos;

	/** Nombre del recurso asociado al usuario en Castellano. */
	private String nombreRecursoCastellano;

	/** Nombre del recurso asociado al usuario en Euskera. */
	private String nombreRecursoEuskera;

	/**
	 * Constructor.
	 * 
	 * @param userName Código usado para la autenticación del usuario
	 * @param password Password
	 * @param authorities Autorizaciones del usuario
	 * @param codigoRecurso Código de recurso
	 * @param nombre Nombre
	 * @param apellidos Apellidos
	 */
	public UsuarioDetalles(String userName, String password, Collection<? extends GrantedAuthority> authorities,
			Long codigoRecurso, String nombre, String apellidos) {
		super(userName, password, authorities);

		this.codigoRecurso = codigoRecurso;
		this.nombre = nombre;
		this.apellidos = apellidos;
	}

	/**
	 * Obtiene el campo codigoRecurso
	 * 
	 * @return codigoRecurso
	 */
	public Long getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el campo codigoRecurso
	 * 
	 * @param codigoRecurso codigoRecurso
	 */
	public void setCodigoRecurso(Long codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * Obtiene el campo nombre.
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre.
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo apellidos
	 * 
	 * @return apellidos
	 */
	public String getApellidos() {
		return this.apellidos;
	}

	/**
	 * Establece el campo apellidos
	 * 
	 * @param apellidos apellidos
	 */
	public void setApellidos(String apellidos) {
		this.apellidos = apellidos;
	}

	/**
	 * Obtiene el campo nombreRecursoCastellano
	 * 
	 * @return nombreRecursoCastellano
	 */
	public String getNombreRecursoCastellano() {
		return this.nombreRecursoCastellano;
	}

	/**
	 * Establece el campo nombreRecursoCastellano
	 * 
	 * @param nombreRecursoCastellano nombreRecursoCastellano
	 */
	public void setNombreRecursoCastellano(String nombreRecursoCastellano) {
		this.nombreRecursoCastellano = nombreRecursoCastellano;
	}

	/**
	 * Obtiene el campo nombreRecursoEuskera
	 * 
	 * @return nombreRecursoEuskera
	 */
	public String getNombreRecursoEuskera() {
		return this.nombreRecursoEuskera;
	}

	/**
	 * Establece el campo nombreRecursoEuskera
	 * 
	 * @param nombreRecursoEuskera nombreRecursoEuskera
	 */
	public void setNombreRecursoEuskera(String nombreRecursoEuskera) {
		this.nombreRecursoEuskera = nombreRecursoEuskera;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		return "UsuarioDetalles [login=" + this.getUsername() + ", nombre=" + this.nombre + ", apellidos="
				+ this.apellidos + ", codigoRecurso=" + this.codigoRecurso + "]";
	}

}
