package com.ejie.aa80a.model;

import javax.validation.constraints.Size;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Clase que representa un usuario de la aplicación.
 * 
 *  
 */
public class Usuario {

	private static final int SIZE_MAX_STRING_CORTO = 20;
	private static final int SIZE_MAX_STRING_MEDIO = 50;
	private static final int SIZE_MAX_STRING_LARGO = 255;

	/** Código de usuario. */
	private Integer idUsuario;

	/** Login de usuario. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_CORTO)
	private String login;

	/** para verificar si se ha modificado el usuario en la pantalla de modificación de datos del usuario */
	private String loginAnterior;

	/** DNI. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_CORTO)
	private String dni;

	/** Nombre. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_MEDIO)
	private String nombre;

	/** Apellidos. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_MEDIO)
	private String apellidos;

	/** Cargo. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_MEDIO)
	private String cargo;

	/** email. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_LARGO)
	@Email()
	private String email;

	/** Número de teléfono. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_CORTO)
	private String telefono;

	/** password. */
	@JsonIgnore()
	private String password;

	/** Perfiles del usuario. */
	private TipoPerfilUsuario perfil;

	/** Recurso asociado */
	private Recurso recurso;

	/** Tipo de recurso asociado al usuario. Puede ser A1: Alojamiento, E1: Oficina de turismo, NULL: Coordinador */
	private String nombreTipoRecurso;

	/**
	 * Obtiene el campo idUsuario
	 * 
	 * @return idUsuario
	 */
	public Integer getIdUsuario() {
		return this.idUsuario;
	}

	/**
	 * Establece el campo idUsuario
	 * 
	 * @param idUsuario idUsuario
	 */
	public void setIdUsuario(Integer idUsuario) {
		this.idUsuario = idUsuario;
	}

	/**
	 * Obtiene el campo login
	 * 
	 * @return login
	 */
	public String getLogin() {
		return this.login;
	}

	/**
	 * Establece el campo login
	 * 
	 * @param login login
	 */
	public void setLogin(String login) {
		this.login = login;
	}

	/**
	 * Obtiene el campo dni
	 * 
	 * @return dni
	 */
	public String getDni() {
		return this.dni;
	}

	/**
	 * Establece el campo dni
	 * 
	 * @param dni dni
	 */
	public void setDni(String dni) {
		this.dni = dni;
	}

	/**
	 * Obtiene el campo nombre
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo apellidos
	 * 
	 * @return apellidos
	 */
	public String getApellidos() {
		return this.apellidos;
	}

	/**
	 * Establece el campo apellidos
	 * 
	 * @param apellidos apellidos
	 */
	public void setApellidos(String apellidos) {
		this.apellidos = apellidos;
	}

	/**
	 * Obtiene el campo cargo
	 * 
	 * @return cargo
	 */
	public String getCargo() {
		return this.cargo;
	}

	/**
	 * Establece el campo cargo
	 * 
	 * @param cargo cargo
	 */
	public void setCargo(String cargo) {
		this.cargo = cargo;
	}

	/**
	 * Obtiene el campo email
	 * 
	 * @return email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo telefono
	 * 
	 * @return telefono
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Establece el campo telefono
	 * 
	 * @param telefono telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Obtiene el campo password
	 * 
	 * @return password
	 */
	public String getPassword() {
		return this.password;
	}

	/**
	 * Establece el campo password
	 * 
	 * @param password password
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * Obtiene el campo perfil
	 * 
	 * @return perfil
	 */
	public TipoPerfilUsuario getPerfil() {
		return this.perfil;
	}

	/**
	 * Establece el campo perfil
	 * 
	 * @param perfil perfil
	 */
	public void setPerfil(TipoPerfilUsuario perfil) {
		this.perfil = perfil;
	}

	/**
	 * Obtiene el campo recurso
	 * 
	 * @return recurso
	 */
	public Recurso getRecurso() {
		return this.recurso;
	}

	/**
	 * Establece el campo recurso
	 * 
	 * @param recurso recurso
	 */
	public void setRecurso(Recurso recurso) {
		this.recurso = recurso;
	}

	/**
	 * Obtiene el campo nombreTipoRecurso
	 * 
	 * @return nombreTipoRecurso
	 */
	public String getNombreTipoRecurso() {
		return this.nombreTipoRecurso;
	}

	/**
	 * Establece el campo nombreTipoRecurso
	 * 
	 * @param nombreTipoRecurso nombreTipoRecurso
	 */
	public void setNombreTipoRecurso(String nombreTipoRecurso) {
		this.nombreTipoRecurso = nombreTipoRecurso;
	}

	/**
	 * Obtiene el campo loginAnterior
	 * 
	 * @return loginAnterior
	 */
	public String getLoginAnterior() {
		return this.loginAnterior;
	}

	/**
	 * Establece el campo loginAnterior
	 * 
	 * @param loginAnterior loginAnterior
	 */
	public void setLoginAnterior(String loginAnterior) {
		this.loginAnterior = loginAnterior;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override()
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.idUsuario == null) ? 0 : this.idUsuario);
		result = prime * result + ((this.login == null) ? 0 : this.login.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override()
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof Usuario)) {
			return false;
		}
		Usuario other = (Usuario) obj;
		if (this.idUsuario != other.idUsuario) {
			return false;
		}
		if (this.login == null) {
			if (other.login != null) {
				return false;
			}
		} else if (!this.login.equals(other.login)) {
			return false;
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		return "Usuario [idUsuario=" + this.idUsuario + ", login=" + this.login + ", nombre=" + this.nombre
				+ ", apellidos=" + this.apellidos + ", cargo=" + this.cargo + ", email=" + this.email + ", perfil="
				+ (this.perfil != null ? this.perfil.getTipoPerfilUsuario() : "") + "]";
	}

}
