package com.ejie.aa80a.model;


/**
 * Enumerado con los tipos de perfil definidos por la aplicación
 * 
 *  
 */
public enum TipoPerfilUsuario {

	/**
	 * Administrador. Tiene permisos para modificar todos los recursos y para realizar una gestión de los usuarios.
	 * 
	 */
	ADMINISTRADOR("ADMINISTRADOR"),

	/**
	 * Oficina de turismo. Tiene permisos para modificar todos los recursos.
	 * 
	 */
	OFICINA("OFICINA"),

	/**
	 * Usuario. Solo tiene permiso para modificar los datos de su recurso asociado.
	 * 
	 */
	USUARIO("USUARIO");

	/** Tipo de perfil */
	private String tipoPerfilUsuario;

	/**
	 * Instancia un nuevo tipo de perfil.
	 * 
	 * @param tipoPerfilUsuario Tipo de perfil
	 */
	private TipoPerfilUsuario(String tipoPerfilUsuario) {
		this.tipoPerfilUsuario = tipoPerfilUsuario;
	}

	/**
	 * Obtiene el tipo de perfil
	 * 
	 * @return tipo de perfil
	 */
	public String getTipoPerfilUsuario() {
		return this.tipoPerfilUsuario;
	}
}
