package com.ejie.aa80a.model;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.Size;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.URL;

/**
 * Clase que representa un recurso de la aplicación.
 * 
 *  
 */
public class Recurso {

	private static final int SIZE_MAX_STRING_CORTO = 15;
	private static final int SIZE_MAX_STRING_LARGO = 250;
	private static final int SIZE_MAX_STRING_SUGERENCIA = 4000;

	// DATOS COMUNES

	/** Código del recurso. */
	private Long codigo;

	/** Tipo del recurso. */
	private String tipo;

	/** Nombre del tipo del recurso. */
	private String nombreTipo;

	/** Nombre del recurso. */
	private String nombre;

	/** Dirección del recurso. */
	private String direccion;

	/** Código postal del recurso. */
	private String codigoPostal;

	/** Provincia del recurso. */
	private String provincia;

	/** Municipio del recurso. */
	private String municipio;

	/** Localidad del recurso. */
	private String localidad;

	/** Telefono 1 del recurso. */
	@Size(max = SIZE_MAX_STRING_CORTO)
	private String telefono1;

	/** Telefono 2 del recurso. */
	@Size(max = SIZE_MAX_STRING_CORTO)
	private String telefono2;

	/** E-mail del recurso. */
	@Size(max = SIZE_MAX_STRING_LARGO)
	@Email()
	private String email;

	/** Web del recurso. */
	@Size(max = SIZE_MAX_STRING_LARGO)
	@URL()
	private String web;

	/** URL del recurso en el Portal de Turismo. */
	private String urlPortal;

	// DATOS PARTICULARES

	/** Signatura del recurso. */
	private String signatura;

	/** Subtipo del recurso. */
	private String subtipo;

	/** Nombre del subtipo del recurso. */
	private String nombreSubtipo;

	/** Categoría del recurso. */
	private String categoria;

	/** Nombre de la categoría del recurso. */
	private String nombreCategoria;

	// Para agenda
	private Date fechaInicio;

	private Date fechaFin;

	// CARACTERISTICAS Y SERVICIOS

	/** Servicios no editables del recurso */
	private List<Servicio> caracteristicas;

	/** Servicios editables del recurso */
	private List<Servicio> servicios;

	// SUGERENCIAS
	@Size(max = SIZE_MAX_STRING_SUGERENCIA)
	private String sugerencia;

	// DATOS DE GEOREFERENCIACION
	private Localizacion localizacion;

	/** Url completa de lote 3 del contenido */
	private String rutaRecurso;

	/** Lista de precios del recurso */
	private List<Precio> precios;

	/** Indica si se trata de un recurso TOP */
	private boolean esTop;

	/** Imagen principal del recurso. */
	private Imagen imagen;

	// Para alojamientos
	/** Modalidad del alojamiento */
	private String modalidad;

	/**
	 * Obtiene el campo codigo
	 * 
	 * @return codigo
	 */
	public Long getCodigo() {
		return this.codigo;
	}

	/**
	 * Establece el campo codigo
	 * 
	 * @param codigo codigo
	 */
	public void setCodigo(Long codigo) {
		this.codigo = codigo;
	}

	/**
	 * Obtiene el campo tipo
	 * 
	 * @return tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * Establece el campo tipo
	 * 
	 * @param tipo tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Obtiene el campo nombreTipo
	 * 
	 * @return nombreTipo
	 */
	public String getNombreTipo() {
		return this.nombreTipo;
	}

	/**
	 * Establece el campo nombreTipo
	 * 
	 * @param nombreTipo nombreTipo
	 */
	public void setNombreTipo(String nombreTipo) {
		this.nombreTipo = nombreTipo;
	}

	/**
	 * Obtiene el campo nombre
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo signatura
	 * 
	 * @return signatura
	 */
	public String getSignatura() {
		return this.signatura;
	}

	/**
	 * Establece el campo signatura
	 * 
	 * @param signatura signatura
	 */
	public void setSignatura(String signatura) {
		this.signatura = signatura;
	}

	/**
	 * Obtiene el campo direccion
	 * 
	 * @return direccion
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * Establece el campo direccion
	 * 
	 * @param direccion direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * Obtiene el campo codigoPostal
	 * 
	 * @return codigoPostal
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * Establece el campo codigoPostal
	 * 
	 * @param codigoPostal codigoPostal
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * Obtiene el campo provincia
	 * 
	 * @return provincia
	 */
	public String getProvincia() {
		return this.provincia;
	}

	/**
	 * Establece el campo provincia
	 * 
	 * @param provincia provincia
	 */
	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * Obtiene el campo municipio
	 * 
	 * @return municipio
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * Establece el campo municipio
	 * 
	 * @param municipio municipio
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * Obtiene el campo localidad
	 * 
	 * @return localidad
	 */
	public String getLocalidad() {
		return this.localidad;
	}

	/**
	 * Establece el campo localidad
	 * 
	 * @param localidad localidad
	 */
	public void setLocalidad(String localidad) {
		this.localidad = localidad;
	}

	/**
	 * Obtiene el campo telefono1
	 * 
	 * @return telefono1
	 */
	public String getTelefono1() {
		return this.telefono1;
	}

	/**
	 * Establece el campo telefono1
	 * 
	 * @param telefono1 telefono1
	 */
	public void setTelefono1(String telefono1) {
		this.telefono1 = telefono1;
	}

	/**
	 * Obtiene el campo telefono2
	 * 
	 * @return telefono2
	 */
	public String getTelefono2() {
		return this.telefono2;
	}

	/**
	 * Establece el campo telefono2
	 * 
	 * @param telefono2 telefono2
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}

	/**
	 * Obtiene el campo email
	 * 
	 * @return email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo web
	 * 
	 * @return web
	 */
	public String getWeb() {
		return this.web;
	}

	/**
	 * Establece el campo web
	 * 
	 * @param web web
	 */
	public void setWeb(String web) {
		// Se añade el protocolo (http://) si no lo tiene
		if (web == null || "".equals(web) || web.indexOf("http") != -1) {
			this.web = web;
		} else {
			this.web = "http://" + web;
		}
	}

	/**
	 * Obtiene el campo subtipo
	 * 
	 * @return subtipo
	 */
	public String getSubtipo() {
		return this.subtipo;
	}

	/**
	 * Establece el campo subtipo
	 * 
	 * @param subtipo subtipo
	 */
	public void setSubtipo(String subtipo) {
		this.subtipo = subtipo;
	}

	/**
	 * Obtiene el campo categoria
	 * 
	 * @return categoria
	 */
	public String getCategoria() {
		return this.categoria;
	}

	/**
	 * Establece el campo categoria
	 * 
	 * @param categoria categoria
	 */
	public void setCategoria(String categoria) {
		this.categoria = categoria;
	}

	/**
	 * Obtiene el campo urlPortal
	 * 
	 * @return urlPortal
	 */
	public String getUrlPortal() {
		return this.urlPortal;
	}

	/**
	 * Establece el campo urlPortal
	 * 
	 * @param urlPortal urlPortal
	 */
	public void setUrlPortal(String urlPortal) {
		this.urlPortal = urlPortal;
	}

	/**
	 * Obtiene el campo nombreSubtipo
	 * 
	 * @return nombreSubtipo
	 */
	public String getNombreSubtipo() {
		return this.nombreSubtipo;
	}

	/**
	 * Establece el campo nombreSubtipo
	 * 
	 * @param nombreSubtipo nombreSubtipo
	 */
	public void setNombreSubtipo(String nombreSubtipo) {
		this.nombreSubtipo = nombreSubtipo;
	}

	/**
	 * Obtiene el campo nombreCategoria
	 * 
	 * @return nombreCategoria
	 */
	public String getNombreCategoria() {
		return this.nombreCategoria;
	}

	/**
	 * Establece el campo nombreCategoria
	 * 
	 * @param nombreCategoria nombreCategoria
	 */
	public void setNombreCategoria(String nombreCategoria) {
		this.nombreCategoria = nombreCategoria;
	}

	/**
	 * Obtiene el campo caracteristicas
	 * 
	 * @return caracteristicas
	 */
	public List<Servicio> getCaracteristicas() {
		return this.caracteristicas;
	}

	/**
	 * Establece el campo caracteristicas
	 * 
	 * @param caracteristicas caracteristicas
	 */
	public void setCaracteristicas(List<Servicio> caracteristicas) {
		this.caracteristicas = caracteristicas;
	}

	/**
	 * Obtiene el campo servicios
	 * 
	 * @return servicios
	 */
	public List<Servicio> getServicios() {
		return this.servicios;
	}

	/**
	 * Establece el campo servicios
	 * 
	 * @param servicios servicios
	 */
	public void setServicios(List<Servicio> servicios) {
		this.servicios = servicios;
	}

	/**
	 * Obtiene el campo sugerencia
	 * 
	 * @return sugerencia
	 */
	public String getSugerencia() {
		return this.sugerencia;
	}

	/**
	 * Establece el campo sugerencia
	 * 
	 * @param sugerencia sugerencia
	 */
	public void setSugerencia(String sugerencia) {
		this.sugerencia = sugerencia;
	}

	/**
	 * Obtiene el campo fechaInicio
	 * 
	 * @return fechaInicio
	 */
	public Date getFechaInicio() {
		return this.fechaInicio;
	}

	/**
	 * Establece el campo fechaInicio
	 * 
	 * @param fechaInicio fechaInicio
	 */
	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	/**
	 * Obtiene el campo fechaFin
	 * 
	 * @return fechaFin
	 */
	public Date getFechaFin() {
		return this.fechaFin;
	}

	/**
	 * Establece el campo fechaFin
	 * 
	 * @param fechaFin fechaFin
	 */
	public void setFechaFin(Date fechaFin) {
		this.fechaFin = fechaFin;
	}

	/**
	 * Obtiene el campo localizacion
	 * 
	 * @return localizacion
	 */
	public Localizacion getLocalizacion() {
		return this.localizacion;
	}

	/**
	 * Establece el campo localizacion
	 * 
	 * @param localizacion localizacion
	 */
	public void setLocalizacion(Localizacion localizacion) {
		this.localizacion = localizacion;
	}

	/**
	 * Obtiene el campo rutaRecurso
	 * 
	 * @return rutaRecurso
	 */
	public String getRutaRecurso() {
		return this.rutaRecurso;
	}

	/**
	 * Establece el campo rutaRecurso
	 * 
	 * @param rutaRecurso rutaRecurso
	 */
	public void setRutaRecurso(String rutaRecurso) {
		this.rutaRecurso = rutaRecurso;
	}

	/**
	 * Obtiene el campo precios
	 * 
	 * @return precios
	 */
	public List<Precio> getPrecios() {
		return this.precios;
	}

	/**
	 * Establece el campo precios
	 * 
	 * @param precios precios
	 */
	public void setPrecios(List<Precio> precios) {
		this.precios = precios;
	}

	/**
	 * Obtiene el campo esTop
	 * 
	 * @return esTop
	 */
	public boolean isEsTop() {
		return this.esTop;
	}

	/**
	 * Establece el campo esTop
	 * 
	 * @param esTop esTop
	 */
	public void setEsTop(boolean esTop) {
		this.esTop = esTop;
	}

	/**
	 * Obtiene el campo imagen
	 * 
	 * @return imagen
	 */
	public Imagen getImagen() {
		return this.imagen;
	}

	/**
	 * Establece el campo imagen
	 * 
	 * @param imagen imagen
	 */
	public void setImagen(Imagen imagen) {
		this.imagen = imagen;
	}

	/**
	 * Obtiene el campo modalidad
	 * 
	 * @return modalidad
	 */
	public String getModalidad() {
		return this.modalidad;
	}

	/**
	 * Establece el campo modalidad
	 * 
	 * @param modalidad modalidad
	 */
	public void setModalidad(String modalidad) {
		this.modalidad = modalidad;
	}

}
