package com.ejie.aa80a.model;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * Clase que representa un precio de un alojamiento
 * 
 *  
 */
public class Precio {

	private static final int SIZE_MAX_PRECIO_ENTERO = 8;
	private static final int SIZE_MAX_PRECIO_DECIMAL = 2;

	/** id de la fila */
	private String id;

	/** Código del tipo de precio */
	private Long codigoPrecio;

	/** Capacidad en personas */
	private Integer capacidad;

	/** Precio mínimo */
	@NotNull()
	@Min(value = 0)
	@Digits(integer = SIZE_MAX_PRECIO_ENTERO, fraction = SIZE_MAX_PRECIO_DECIMAL)
	private Double precioMinimo;

	/** Precio máximo */
	@NotNull()
	@Min(value = 0)
	@Digits(integer = SIZE_MAX_PRECIO_ENTERO, fraction = SIZE_MAX_PRECIO_DECIMAL)
	private Double precioMaximo;

	/** Numero de adultos que incluye la parcela */
	private Integer parcelaAdulto;

	/** Número de niños que incluye la parcela */
	private Integer parcelaInfantil;

	/** Número de tiendas que incluye la parcela */
	private Integer parcelaTienda;

	/** Número de automoviles que incluye la parcela */
	private Integer parcelaAutomovil;

	/** Número de conexiones eléctricas que incluye la parcela */
	private Integer parcelaConexionElectrica;

	// Para la tabla de precios
	/** Nombre del tipo de precio */
	private String tipoPrecio;

	/**
	 * Obtiene el campo codigoPrecio
	 * 
	 * @return codigoPrecio
	 */
	public Long getCodigoPrecio() {
		return this.codigoPrecio;
	}

	/**
	 * Establece el campo codigoPrecio
	 * 
	 * @param codigoPrecio codigoPrecio
	 */
	public void setCodigoPrecio(Long codigoPrecio) {
		this.codigoPrecio = codigoPrecio;
	}

	/**
	 * Obtiene el campo capacidad
	 * 
	 * @return capacidad
	 */
	public Integer getCapacidad() {
		return this.capacidad;
	}

	/**
	 * Establece el campo capacidad
	 * 
	 * @param capacidad capacidad
	 */
	public void setCapacidad(Integer capacidad) {
		this.capacidad = capacidad;
	}

	/**
	 * Obtiene el campo precioMinimo
	 * 
	 * @return precioMinimo
	 */
	public Double getPrecioMinimo() {
		return this.precioMinimo;
	}

	/**
	 * Establece el campo precioMinimo
	 * 
	 * @param precioMinimo precioMinimo
	 */
	public void setPrecioMinimo(Double precioMinimo) {
		this.precioMinimo = precioMinimo;
	}

	/**
	 * Obtiene el campo precioMaximo
	 * 
	 * @return precioMaximo
	 */
	public Double getPrecioMaximo() {
		return this.precioMaximo;
	}

	/**
	 * Establece el campo precioMaximo
	 * 
	 * @param precioMaximo precioMaximo
	 */
	public void setPrecioMaximo(Double precioMaximo) {
		this.precioMaximo = precioMaximo;
	}

	/**
	 * Obtiene el campo parcelaAdulto
	 * 
	 * @return parcelaAdulto
	 */
	public Integer getParcelaAdulto() {
		return this.parcelaAdulto;
	}

	/**
	 * Establece el campo parcelaAdulto
	 * 
	 * @param parcelaAdulto parcelaAdulto
	 */
	public void setParcelaAdulto(Integer parcelaAdulto) {
		this.parcelaAdulto = parcelaAdulto;
	}

	/**
	 * Obtiene el campo parcelaInfantil
	 * 
	 * @return parcelaInfantil
	 */
	public Integer getParcelaInfantil() {
		return this.parcelaInfantil;
	}

	/**
	 * Establece el campo parcelaInfantil
	 * 
	 * @param parcelaInfantil parcelaInfantil
	 */
	public void setParcelaInfantil(Integer parcelaInfantil) {
		this.parcelaInfantil = parcelaInfantil;
	}

	/**
	 * Obtiene el campo parcelaTienda
	 * 
	 * @return parcelaTienda
	 */
	public Integer getParcelaTienda() {
		return this.parcelaTienda;
	}

	/**
	 * Establece el campo parcelaTienda
	 * 
	 * @param parcelaTienda parcelaTienda
	 */
	public void setParcelaTienda(Integer parcelaTienda) {
		this.parcelaTienda = parcelaTienda;
	}

	/**
	 * Obtiene el campo parcelaAutomovil
	 * 
	 * @return parcelaAutomovil
	 */
	public Integer getParcelaAutomovil() {
		return this.parcelaAutomovil;
	}

	/**
	 * Establece el campo parcelaAutomovil
	 * 
	 * @param parcelaAutomovil parcelaAutomovil
	 */
	public void setParcelaAutomovil(Integer parcelaAutomovil) {
		this.parcelaAutomovil = parcelaAutomovil;
	}

	/**
	 * Obtiene el campo parcelaConexionElectrica
	 * 
	 * @return parcelaConexionElectrica
	 */
	public Integer getParcelaConexionElectrica() {
		return this.parcelaConexionElectrica;
	}

	/**
	 * Establece el campo parcelaConexionElectrica
	 * 
	 * @param parcelaConexionElectrica parcelaConexionElectrica
	 */
	public void setParcelaConexionElectrica(Integer parcelaConexionElectrica) {
		this.parcelaConexionElectrica = parcelaConexionElectrica;
	}

	/**
	 * Obtiene el campo tipoPrecio
	 * 
	 * @return tipoPrecio
	 */
	public String getTipoPrecio() {
		return this.tipoPrecio;
	}

	/**
	 * Establece el campo tipoPrecio
	 * 
	 * @param tipoPrecio tipoPrecio
	 */
	public void setTipoPrecio(String tipoPrecio) {
		this.tipoPrecio = tipoPrecio;
	}

	/**
	 * Obtiene el campo id
	 * 
	 * @return id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * Establece el campo id
	 * 
	 * @param id id
	 */
	public void setId(String id) {
		this.id = id;
	}

}
