package com.ejie.aa80a.model;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.URL;

/**
 * Clase que representa una oferta asociado a un recurso de la aplicación.
 * 
 *  
 */
public class Oferta {

	private static final int SIZE_MAX_STRING_URL = 255;
	private static final int SIZE_MAX_STRING_NOMBRE = 250;
	private static final int SIZE_MAX_STRING_DESCRIPCION = 3900;

	private static final int SIZE_MAX_PRECIO_ENTERO = 8;
	private static final int SIZE_MAX_PRECIO_DECIMAL = 2;

	/** Código de la oferta. */
	private Long codigo;

	/** Nombre de la oferta en castellano. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_NOMBRE)
	private String nombreCastellano;

	/** Nombre de la oferta en euskera. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_NOMBRE)
	private String nombreEuskera;

	/** Nombre de la oferta en inglés. */
	@Size(max = SIZE_MAX_STRING_NOMBRE)
	private String nombreIngles;

	/** Nombre de la oferta en francés. */
	@Size(max = SIZE_MAX_STRING_NOMBRE)
	private String nombreFrances;

	/** Nombre de la oferta en alemán. */
	@Size(max = SIZE_MAX_STRING_NOMBRE)
	private String nombreAleman;

	/** Descripción de la oferta en castellano. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String descripcionCastellano;

	/** Descripción de la oferta en euskera. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String descripcionEuskera;

	/** Descripción de la oferta en inglés. */
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String descripcionIngles;

	/** Descripción de la oferta en francés. */
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String descripcionFrances;

	/** Descripción de la oferta en alemán. */
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String descripcionAleman;

	/** Precio de la oferta. */
	@NotNull()
	@Min(value = 0)
	@Digits(integer = SIZE_MAX_PRECIO_ENTERO, fraction = SIZE_MAX_PRECIO_DECIMAL)
	private Double precio;

	/** Fecha a partir de la cual la oferta está vigente */
	@NotNull()
	private Date fechaDesde;

	/** Fecha a partir de la cual la oferta ya no está vigente */
	@NotNull()
	private Date fechaHasta;

	/** Imagen asociada a la oferta. */
	private Imagen imagen;

	/** Web asociada a la oferta. */
	@Size(max = SIZE_MAX_STRING_URL)
	@URL()
	private String web;

	/** E-mail asociado a la oferta. */
	@NotEmpty()
	@Size(max = SIZE_MAX_STRING_URL)
	@Email()
	private String email;

	/** Código del recurso al que está asociada la oferta. */
	private Long codigoPadre;

	/** Tipo del recurso al que está asociada la oferta. */
	private String tipoPadre;

	/** ruta del recurso de la oferta en el gestor de contenidos */
	private String rutaRecurso;

	/** Lista de condiciones de la oferta */
	private List<Condicion> condiciones;

	/** Dirección de la oferta. */
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String direccion;

	/** Teléfono de la oferta. */
	@Size(max = SIZE_MAX_STRING_DESCRIPCION)
	private String telefono;

	/** Código de la provincia de la oferta. */
	private Integer codigoProvincia;

	/** nombre de la provncia en castellano */
	private String nombreProvinciaEs;

	/** nombre de la provincia en euskera */
	private String nombreProvinciaEu;

	/** Código del municipio de la oferta. */
	// private Integer codigoMunicipio;
	private String codigoMunicipio;

	/** nombre del municipio en castellano */
	private String nombreMunicipioEs;

	/** nombre del municipio en euskera */
	private String nombreMunicipioEu;

	/** Código de la localidad de la oferta. */
	private Long codigoLocalidad;

	/** nombre de la localidad en castellano */
	private String nombreLocalidadEs;

	/** nombre de la localidad en euskera */
	private String nombreLocalidadEu;

	/**
	 * Obtiene el campo codigo
	 * 
	 * @return codigo
	 */
	public Long getCodigo() {
		return this.codigo;
	}

	/**
	 * Establece el campo codigo
	 * 
	 * @param codigo codigo
	 */
	public void setCodigo(Long codigo) {
		this.codigo = codigo;
	}

	/**
	 * Obtiene el campo nombreCastellano
	 * 
	 * @return nombreCastellano
	 */
	public String getNombreCastellano() {
		return this.nombreCastellano;
	}

	/**
	 * Establece el campo nombreCastellano
	 * 
	 * @param nombreCastellano nombreCastellano
	 */
	public void setNombreCastellano(String nombreCastellano) {
		this.nombreCastellano = nombreCastellano;
	}

	/**
	 * Obtiene el campo nombreEuskera
	 * 
	 * @return nombreEuskera
	 */
	public String getNombreEuskera() {
		return this.nombreEuskera;
	}

	/**
	 * Establece el campo nombreEuskera
	 * 
	 * @param nombreEuskera nombreEuskera
	 */
	public void setNombreEuskera(String nombreEuskera) {
		this.nombreEuskera = nombreEuskera;
	}

	/**
	 * Obtiene el campo descripcionCastellano
	 * 
	 * @return descripcionCastellano
	 */
	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Establece el campo descripcionCastellano
	 * 
	 * @param descripcionCastellano descripcionCastellano
	 */
	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Obtiene el campo descripcionEuskera
	 * 
	 * @return descripcionEuskera
	 */
	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Establece el campo descripcionEuskera
	 * 
	 * @param descripcionEuskera descripcionEuskera
	 */
	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Obtiene el campo fechaDesde
	 * 
	 * @return fechaDesde
	 */
	public Date getFechaDesde() {
		return this.fechaDesde;
	}

	/**
	 * Establece el campo fechaDesde
	 * 
	 * @param fechaDesde fechaDesde
	 */
	public void setFechaDesde(Date fechaDesde) {
		this.fechaDesde = fechaDesde;
	}

	/**
	 * Obtiene el campo fechaHasta
	 * 
	 * @return fechaHasta
	 */
	public Date getFechaHasta() {
		return this.fechaHasta;
	}

	/**
	 * Establece el campo fechaHasta
	 * 
	 * @param fechaHasta fechaHasta
	 */
	public void setFechaHasta(Date fechaHasta) {
		this.fechaHasta = fechaHasta;
	}

	/**
	 * Obtiene el campo imagen
	 * 
	 * @return imagen
	 */
	public Imagen getImagen() {
		return this.imagen;
	}

	/**
	 * Establece el campo imagen
	 * 
	 * @param imagen imagen
	 */
	public void setImagen(Imagen imagen) {
		this.imagen = imagen;
	}

	/**
	 * Obtiene el campo web
	 * 
	 * @return web
	 */
	public String getWeb() {
		return this.web;
	}

	/**
	 * Establece el campo web
	 * 
	 * @param web web
	 */
	public void setWeb(String web) {
		this.web = web;
	}

	/**
	 * Obtiene el campo email
	 * 
	 * @return email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo precio
	 * 
	 * @return precio
	 */
	public Double getPrecio() {
		return this.precio;
	}

	/**
	 * Establece el campo precio
	 * 
	 * @param precio precio
	 */
	public void setPrecio(Double precio) {
		this.precio = precio;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override()
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (this.codigo != null ? this.codigo.hashCode() : 0);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override()
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof Oferta)) {
			return false;
		}
		Oferta other = (Oferta) obj;
		if (!this.codigo.equals(other.codigo)) {
			return false;
		}
		return true;
	}

	/**
	 * Obtiene el campo codigoPadre
	 * 
	 * @return codigoPadre
	 */
	public Long getCodigoPadre() {
		return this.codigoPadre;
	}

	/**
	 * Establece el campo codigoPadre
	 * 
	 * @param codigoPadre codigoPadre
	 */
	public void setCodigoPadre(Long codigoPadre) {
		this.codigoPadre = codigoPadre;
	}

	/**
	 * Obtiene el campo tipoPadre
	 * 
	 * @return tipoPadre
	 */
	public String getTipoPadre() {
		return this.tipoPadre;
	}

	/**
	 * Establece el campo tipoPadre
	 * 
	 * @param tipoPadre tipoPadre
	 */
	public void setTipoPadre(String tipoPadre) {
		this.tipoPadre = tipoPadre;
	}

	/**
	 * Obtiene el campo nombreIngles
	 * 
	 * @return nombreIngles
	 */
	public String getNombreIngles() {
		return this.nombreIngles;
	}

	/**
	 * Establece el campo nombreIngles
	 * 
	 * @param nombreIngles nombreIngles
	 */
	public void setNombreIngles(String nombreIngles) {
		this.nombreIngles = nombreIngles;
	}

	/**
	 * Obtiene el campo nombreFrances
	 * 
	 * @return nombreFrances
	 */
	public String getNombreFrances() {
		return this.nombreFrances;
	}

	/**
	 * Establece el campo nombreFrances
	 * 
	 * @param nombreFrances nombreFrances
	 */
	public void setNombreFrances(String nombreFrances) {
		this.nombreFrances = nombreFrances;
	}

	/**
	 * Obtiene el campo nombreAleman
	 * 
	 * @return nombreAleman
	 */
	public String getNombreAleman() {
		return this.nombreAleman;
	}

	/**
	 * Establece el campo nombreAleman
	 * 
	 * @param nombreAleman nombreAleman
	 */
	public void setNombreAleman(String nombreAleman) {
		this.nombreAleman = nombreAleman;
	}

	/**
	 * Obtiene el campo descripcionIngles
	 * 
	 * @return descripcionIngles
	 */
	public String getDescripcionIngles() {
		return this.descripcionIngles;
	}

	/**
	 * Establece el campo descripcionIngles
	 * 
	 * @param descripcionIngles descripcionIngles
	 */
	public void setDescripcionIngles(String descripcionIngles) {
		this.descripcionIngles = descripcionIngles;
	}

	/**
	 * Obtiene el campo descripcionFrances
	 * 
	 * @return descripcionFrances
	 */
	public String getDescripcionFrances() {
		return this.descripcionFrances;
	}

	/**
	 * Establece el campo descripcionFrances
	 * 
	 * @param descripcionFrances descripcionFrances
	 */
	public void setDescripcionFrances(String descripcionFrances) {
		this.descripcionFrances = descripcionFrances;
	}

	/**
	 * Obtiene el campo descripcionAleman
	 * 
	 * @return descripcionAleman
	 */
	public String getDescripcionAleman() {
		return this.descripcionAleman;
	}

	/**
	 * Establece el campo descripcionAleman
	 * 
	 * @param descripcionAleman descripcionAleman
	 */
	public void setDescripcionAleman(String descripcionAleman) {
		this.descripcionAleman = descripcionAleman;
	}

	/**
	 * Obtiene el campo rutaRecurso
	 * 
	 * @return rutaRecurso
	 */
	public String getRutaRecurso() {
		return this.rutaRecurso;
	}

	/**
	 * Establece el campo rutaRecurso
	 * 
	 * @param rutaRecurso rutaRecurso
	 */
	public void setRutaRecurso(String rutaRecurso) {
		this.rutaRecurso = rutaRecurso;
	}

	/**
	 * Obtiene el campo condiciones
	 * 
	 * @return condiciones
	 */
	public List<Condicion> getCondiciones() {
		return this.condiciones;
	}

	/**
	 * Establece el campo condiciones
	 * 
	 * @param condiciones condiciones
	 */
	public void setCondiciones(List<Condicion> condiciones) {
		this.condiciones = condiciones;
	}

	/**
	 * Obtiene el campo direccion
	 * 
	 * @return direccion
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * Establece el campo direccion
	 * 
	 * @param direccion direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * Obtiene el campo telefono
	 * 
	 * @return telefono
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Establece el campo telefono
	 * 
	 * @param telefono telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Obtiene el campo codigoProvincia
	 * 
	 * @return codigoProvincia
	 */
	public Integer getCodigoProvincia() {
		return this.codigoProvincia;
	}

	/**
	 * Establece el campo codigoProvincia
	 * 
	 * @param codigoProvincia codigoProvincia
	 */
	public void setCodigoProvincia(Integer codigoProvincia) {
		this.codigoProvincia = codigoProvincia;
	}

	/**
	 * Obtiene el campo codigoMunicipio
	 * 
	 * @return codigoMunicipio
	 */
	public String getCodigoMunicipio() {
		return this.codigoMunicipio;
	}

	/**
	 * Establece el campo codigoMunicipio
	 * 
	 * @param codigoMunicipio codigoMunicipio
	 */
	public void setCodigoMunicipio(String codigoMunicipio) {
		this.codigoMunicipio = codigoMunicipio;
	}

	/**
	 * Obtiene el campo codigoLocalidad
	 * 
	 * @return codigoLocalidad
	 */
	public Long getCodigoLocalidad() {
		return this.codigoLocalidad;
	}

	/**
	 * Establece el campo codigoLocalidad
	 * 
	 * @param codigoLocalidad codigoLocalidad
	 */
	public void setCodigoLocalidad(Long codigoLocalidad) {
		this.codigoLocalidad = codigoLocalidad;
	}

	/**
	 * Obtiene el campo nombreProvinciaEs
	 * 
	 * @return nombreProvinciaEs
	 */
	public String getNombreProvinciaEs() {
		return this.nombreProvinciaEs;
	}

	/**
	 * Establece el campo nombreProvinciaEs
	 * 
	 * @param nombreProvinciaEs nombreProvinciaEs
	 */
	public void setNombreProvinciaEs(String nombreProvinciaEs) {
		this.nombreProvinciaEs = nombreProvinciaEs;
	}

	/**
	 * Obtiene el campo nombreProvinciaEu
	 * 
	 * @return nombreProvinciaEu
	 */
	public String getNombreProvinciaEu() {
		return this.nombreProvinciaEu;
	}

	/**
	 * Establece el campo nombreProvinciaEu
	 * 
	 * @param nombreProvinciaEu nombreProvinciaEu
	 */
	public void setNombreProvinciaEu(String nombreProvinciaEu) {
		this.nombreProvinciaEu = nombreProvinciaEu;
	}

	/**
	 * Obtiene el campo nombreMunicipioEs
	 * 
	 * @return nombreMunicipioEs
	 */
	public String getNombreMunicipioEs() {
		return this.nombreMunicipioEs;
	}

	/**
	 * Establece el campo nombreMunicipioEs
	 * 
	 * @param nombreMunicipioEs nombreMunicipioEs
	 */
	public void setNombreMunicipioEs(String nombreMunicipioEs) {
		this.nombreMunicipioEs = nombreMunicipioEs;
	}

	/**
	 * Obtiene el campo nombreMunicipioEu
	 * 
	 * @return nombreMunicipioEu
	 */
	public String getNombreMunicipioEu() {
		return this.nombreMunicipioEu;
	}

	/**
	 * Establece el campo nombreMunicipioEu
	 * 
	 * @param nombreMunicipioEu nombreMunicipioEu
	 */
	public void setNombreMunicipioEu(String nombreMunicipioEu) {
		this.nombreMunicipioEu = nombreMunicipioEu;
	}

	/**
	 * Obtiene el campo nombreLocalidadEs
	 * 
	 * @return nombreLocalidadEs
	 */
	public String getNombreLocalidadEs() {
		return this.nombreLocalidadEs;
	}

	/**
	 * Establece el campo nombreLocalidadEs
	 * 
	 * @param nombreLocalidadEs nombreLocalidadEs
	 */
	public void setNombreLocalidadEs(String nombreLocalidadEs) {
		this.nombreLocalidadEs = nombreLocalidadEs;
	}

	/**
	 * Obtiene el campo nombreLocalidadEu
	 * 
	 * @return nombreLocalidadEu
	 */
	public String getNombreLocalidadEu() {
		return this.nombreLocalidadEu;
	}

	/**
	 * Establece el campo nombreLocalidadEu
	 * 
	 * @param nombreLocalidadEu nombreLocalidadEu
	 */
	public void setNombreLocalidadEu(String nombreLocalidadEu) {
		this.nombreLocalidadEu = nombreLocalidadEu;
	}

}
