package com.ejie.aa80a.model;

/**
 * Clase que representa un filtro de búsqueda en la búsqueda de recursos.
 * 
 *  
 */
public class FiltroRecurso {

	/** Tipo del recurso. */
	private String tipo;

	/** Nombre del recurso. */
	private String nombre;

	/** Código de la provincia */
	private Long codProvincia;

	/** Código del municipio */
	private Long codMunicipio;

	/** Nombre del municipio */
	private String nomMunicipio;

	/** Código de la localidad */
	private Long codLocalidad;

	/** Nombre de la localidad */
	private String nomLocalidad;

	// Parámetros para paginación ajax
	private Integer limit; // número de registros a devolver
	private Integer offset; // indice del primer registro a devolver
	private String order; // tipo de ordenación: "asc", "desc"
	private String sort; // campo por el que se debe ordenar

	/**
	 * Obtiene el campo tipo.
	 * 
	 * @return tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * Establece el campo tipo.
	 * 
	 * @param tipo tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Obtiene el campo nombre.
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre.
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo limit
	 * 
	 * @return limit
	 */
	public Integer getLimit() {
		return this.limit;
	}

	/**
	 * Establece el campo limit
	 * 
	 * @param limit limit
	 */
	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	/**
	 * Obtiene el campo offset
	 * 
	 * @return offset
	 */
	public Integer getOffset() {
		return this.offset;
	}

	/**
	 * Establece el campo offset
	 * 
	 * @param offset offset
	 */
	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	/**
	 * Obtiene el campo order
	 * 
	 * @return order
	 */
	public String getOrder() {
		return this.order;
	}

	/**
	 * Establece el campo order
	 * 
	 * @param order order
	 */
	public void setOrder(String order) {
		this.order = order;
	}

	/**
	 * Obtiene el campo sort
	 * 
	 * @return sort
	 */
	public String getSort() {
		return this.sort;
	}

	/**
	 * Establece el campo sort
	 * 
	 * @param sort sort
	 */
	public void setSort(String sort) {
		this.sort = sort;
	}

	/**
	 * Obtiene el campo codProvincia
	 * 
	 * @return codProvincia
	 */
	public Long getCodProvincia() {
		return this.codProvincia;
	}

	/**
	 * Establece el campo codProvincia
	 * 
	 * @param codProvincia codProvincia
	 */
	public void setCodProvincia(Long codProvincia) {
		this.codProvincia = codProvincia;
	}

	/**
	 * Obtiene el campo codMunicipio
	 * 
	 * @return codMunicipio
	 */
	public Long getCodMunicipio() {
		return this.codMunicipio;
	}

	/**
	 * Establece el campo codMunicipio
	 * 
	 * @param codMunicipio codMunicipio
	 */
	public void setCodMunicipio(Long codMunicipio) {
		this.codMunicipio = codMunicipio;
	}

	/**
	 * Obtiene el campo nomMunicipio
	 * 
	 * @return nomMunicipio
	 */
	public String getNomMunicipio() {
		return this.nomMunicipio;
	}

	/**
	 * Establece el campo nomMunicipio
	 * 
	 * @param nomMunicipio nomMunicipio
	 */
	public void setNomMunicipio(String nomMunicipio) {
		this.nomMunicipio = nomMunicipio;
	}

	/**
	 * Obtiene el campo codLocalidad
	 * 
	 * @return codLocalidad
	 */
	public Long getCodLocalidad() {
		return this.codLocalidad;
	}

	/**
	 * Establece el campo codLocalidad
	 * 
	 * @param codLocalidad codLocalidad
	 */
	public void setCodLocalidad(Long codLocalidad) {
		this.codLocalidad = codLocalidad;
	}

	/**
	 * Obtiene el campo nomLocalidad
	 * 
	 * @return nomLocalidad
	 */
	public String getNomLocalidad() {
		return this.nomLocalidad;
	}

	/**
	 * Establece el campo nomLocalidad
	 * 
	 * @param nomLocalidad nomLocalidad
	 */
	public void setNomLocalidad(String nomLocalidad) {
		this.nomLocalidad = nomLocalidad;
	}

}
