package com.ejie.aa80a.model;

import java.util.Date;

/**
 * Clase que refresenta el filtro de búsqueda de la pantalla de gestión de notificaciones
 * 
 *  
 * 
 */
public class FiltroNotificacion {
	// DATOS COMUNES

	/** Nombre del recurso */
	private String nombreRecurso;

	/** Tipo de recurso */
	private String tipoRecurso;

	/** Código del tipo de actualización */
	private String tipoActualizacion;

	/** Estado de la notificación */
	private String estado;

	/** Fecha desde utilizada desde el filtro de búsqueda */
	private Date fechaDesde;

	/** Fecha hasta utilizada desde el filtro de búsqueda */
	private Date fechaHasta;

	// Parámetros para paginación ajax
	private Integer limit; // número de registros a devolver
	private Integer offset; // indice del primer registro a devolver
	private String order; // tipo de ordenación: "asc", "desc"
	private String sort; // campo por el que se debe ordenar

	/**
	 * Obtiene el campo nombreRecurso
	 * 
	 * @return nombreRecurso
	 */
	public String getNombreRecurso() {
		return this.nombreRecurso;
	}

	/**
	 * Establece el campo nombreRecurso
	 * 
	 * @param nombreRecurso nombreRecurso
	 */
	public void setNombreRecurso(String nombreRecurso) {
		this.nombreRecurso = nombreRecurso;
	}

	/**
	 * Obtiene el campo tipoRecurso
	 * 
	 * @return tipoRecurso
	 */
	public String getTipoRecurso() {
		return this.tipoRecurso;
	}

	/**
	 * Establece el campo tipoRecurso
	 * 
	 * @param tipoRecurso tipoRecurso
	 */
	public void setTipoRecurso(String tipoRecurso) {
		this.tipoRecurso = tipoRecurso;
	}

	/**
	 * Obtiene el campo tipoActualizacion
	 * 
	 * @return tipoActualizacion
	 */
	public String getTipoActualizacion() {
		return this.tipoActualizacion;
	}

	/**
	 * Establece el campo tipoActualizacion
	 * 
	 * @param tipoActualizacion tipoActualizacion
	 */
	public void setTipoActualizacion(String tipoActualizacion) {
		this.tipoActualizacion = tipoActualizacion;
	}

	/**
	 * Obtiene el campo estado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * Establece el campo estado
	 * 
	 * @param estado estado
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * Obtiene el campo fechaDesde
	 * 
	 * @return fechaDesde
	 */
	public Date getFechaDesde() {
		return this.fechaDesde;
	}

	/**
	 * Establece el campo fechaDesde
	 * 
	 * @param fechaDesde fechaDesde
	 */
	public void setFechaDesde(Date fechaDesde) {
		this.fechaDesde = fechaDesde;
	}

	/**
	 * Obtiene el campo fechaHasta
	 * 
	 * @return fechaHasta
	 */
	public Date getFechaHasta() {
		return this.fechaHasta;
	}

	/**
	 * Establece el campo fechaHasta
	 * 
	 * @param fechaHasta fechaHasta
	 */
	public void setFechaHasta(Date fechaHasta) {
		this.fechaHasta = fechaHasta;
	}

	/**
	 * Obtiene el campo limit
	 * 
	 * @return limit
	 */
	public Integer getLimit() {
		return this.limit;
	}

	/**
	 * Establece el campo limit
	 * 
	 * @param limit limit
	 */
	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	/**
	 * Obtiene el campo offset
	 * 
	 * @return offset
	 */
	public Integer getOffset() {
		return this.offset;
	}

	/**
	 * Establece el campo offset
	 * 
	 * @param offset offset
	 */
	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	/**
	 * Obtiene el campo order
	 * 
	 * @return order
	 */
	public String getOrder() {
		return this.order;
	}

	/**
	 * Establece el campo order
	 * 
	 * @param order order
	 */
	public void setOrder(String order) {
		this.order = order;
	}

	/**
	 * Obtiene el campo sort
	 * 
	 * @return sort
	 */
	public String getSort() {
		return this.sort;
	}

	/**
	 * Establece el campo sort
	 * 
	 * @param sort sort
	 */
	public void setSort(String sort) {
		this.sort = sort;
	}

}
