package com.ejie.aa80a.model;

/**
 * Clase que indica qué campos o tipos de datos son editables.
 * 
 *  
 */
public class Editables {

	private boolean datosBasicos;
	private boolean servicios;
	private boolean localizacion;
	private boolean multimedia;
	private boolean precios;
	private boolean ofertas;

	private boolean email;
	private boolean telefono1;
	private boolean telefono2;
	private boolean web;

	/**
	 * Constructor
	 * 
	 * @param datosBasicos Indica si los datos básicos son editables
	 * @param servicios Indica si los servicios son editables
	 * @param localizacion Indica si la localización es editable
	 * @param multimedia Indica si los multimedia son editables
	 * @param precios Indica si los precios son editables
	 * @param ofertas Indica si las ofertas son editables
	 * @param email Indica si el E-mail es editable
	 * @param telefono1 Indica si el telefono1 es editable
	 * @param telefono2 Indica si el telefono2 es editable
	 * @param web Indica si la web es editable
	 */
	public Editables(boolean datosBasicos, boolean servicios, boolean localizacion, boolean multimedia,
			boolean precios, boolean ofertas, boolean email, boolean telefono1, boolean telefono2, boolean web) {
		this.datosBasicos = datosBasicos;
		this.servicios = servicios;
		this.localizacion = localizacion;
		this.multimedia = multimedia;
		this.precios = precios;
		this.ofertas = ofertas;
		this.email = email;
		this.telefono1 = telefono1;
		this.telefono2 = telefono2;
		this.web = web;
	}

	/**
	 * Obtiene el campo datosBasicos
	 * 
	 * @return datosBasicos
	 */
	public boolean isDatosBasicos() {
		return this.datosBasicos;
	}

	/**
	 * Establece el campo datosBasicos
	 * 
	 * @param datosBasicos datosBasicos
	 */
	public void setDatosBasicos(boolean datosBasicos) {
		this.datosBasicos = datosBasicos;
	}

	/**
	 * Obtiene el campo servicios
	 * 
	 * @return servicios
	 */
	public boolean isServicios() {
		return this.servicios;
	}

	/**
	 * Establece el campo servicios
	 * 
	 * @param servicios servicios
	 */
	public void setServicios(boolean servicios) {
		this.servicios = servicios;
	}

	/**
	 * Obtiene el campo localizacion
	 * 
	 * @return localizacion
	 */
	public boolean isLocalizacion() {
		return this.localizacion;
	}

	/**
	 * Establece el campo localizacion
	 * 
	 * @param localizacion localizacion
	 */
	public void setLocalizacion(boolean localizacion) {
		this.localizacion = localizacion;
	}

	/**
	 * Obtiene el campo multimedia
	 * 
	 * @return multimedia
	 */
	public boolean isMultimedia() {
		return this.multimedia;
	}

	/**
	 * Establece el campo multimedia
	 * 
	 * @param multimedia multimedia
	 */
	public void setMultimedia(boolean multimedia) {
		this.multimedia = multimedia;
	}

	/**
	 * Obtiene el campo precios
	 * 
	 * @return precios
	 */
	public boolean isPrecios() {
		return this.precios;
	}

	/**
	 * Establece el campo precios
	 * 
	 * @param precios precios
	 */
	public void setPrecios(boolean precios) {
		this.precios = precios;
	}

	/**
	 * Obtiene el campo ofertas
	 * 
	 * @return ofertas
	 */
	public boolean isOfertas() {
		return this.ofertas;
	}

	/**
	 * Establece el campo ofertas
	 * 
	 * @param ofertas ofertas
	 */
	public void setOfertas(boolean ofertas) {
		this.ofertas = ofertas;
	}

	/**
	 * Obtiene el campo email
	 * 
	 * @return email
	 */
	public boolean isEmail() {
		return this.email;
	}

	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(boolean email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo telefono1
	 * 
	 * @return telefono1
	 */
	public boolean isTelefono1() {
		return this.telefono1;
	}

	/**
	 * Establece el campo telefono1
	 * 
	 * @param telefono1 telefono1
	 */
	public void setTelefono1(boolean telefono1) {
		this.telefono1 = telefono1;
	}

	/**
	 * Obtiene el campo telefono2
	 * 
	 * @return telefono2
	 */
	public boolean isTelefono2() {
		return this.telefono2;
	}

	/**
	 * Establece el campo telefono2
	 * 
	 * @param telefono2 telefono2
	 */
	public void setTelefono2(boolean telefono2) {
		this.telefono2 = telefono2;
	}

	/**
	 * Obtiene el campo web
	 * 
	 * @return web
	 */
	public boolean isWeb() {
		return this.web;
	}

	/**
	 * Establece el campo web
	 * 
	 * @param web web
	 */
	public void setWeb(boolean web) {
		this.web = web;
	}

}
