/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.aa80a.log;

import java.util.Hashtable;

import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

/**
 * The Interface LoggingAdvice.
 * 
 *  
 */
public interface LoggingAdvice {

	/**
	 * Pre logging.
	 * 
	 * @param call the call
	 * @throws Throwable the throwable
	 */
	public abstract void preLogging(ProceedingJoinPoint call) throws Throwable;

	/**
	 * Post logging.
	 * 
	 * @param call the call
	 * @param ret the ret
	 * @throws Throwable the throwable
	 */
	public abstract void postLogging(ProceedingJoinPoint call, Object ret) throws Throwable;

	/**
	 * Pre component log call.
	 * 
	 * @param call the call
	 * @param table the table
	 * @param logger the logger
	 * @throws Throwable the throwable
	 */
	public void preComponentLogCall(ProceedingJoinPoint call, Hashtable<String, String> table, Logger logger)
			throws Throwable;

	/**
	 * Post component log call.
	 * 
	 * @param call the call
	 * @param ret the ret
	 * @param table the table
	 * @param logger the logger
	 * @throws Throwable the throwable
	 */
	public void postComponentLogCall(ProceedingJoinPoint call, Object ret, Hashtable<String, String> table,
			Logger logger) throws Throwable;
}