/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.aa80a.log;

import java.util.Hashtable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger.Level;

import com.ejie.aa80a.util.StackTraceManager;
import com.ejie.aa80a.util.TableManager;

/**
 * 
 *  
 * 
 */
public class IncidenceLoggingAdviceImpl implements IncidenceLoggingAdvice {

	private static final Logger logger = LoggerFactory.getLogger(IncidenceLoggingAdviceImpl.class);

	private LoggingManager loggingManager;

	@Override()
	public void logIncidence(Object target, Exception exception) {
		Hashtable<String, String> table = TableManager.initTable();
		table.put(LogConstants.CRITICALITY, Level.ERROR.toString());
		table.put(LogConstants.FUNCTIONALSUBSYSTEM, LogConstants.INCIDENCESUBSYSTEM);
		table.put(LogConstants.ADITIONALINFO, StackTraceManager.getStackTrace(exception));
		table.put(LogConstants.MESSAGE, exception.getMessage() == null ? "" : exception.getMessage());
		this.loggingManager.logIncidences(target.getClass().getName(), logger, table);
	}

	/**
	 * Obtiene el campo loggingManager.
	 * 
	 * @return loggingManager
	 */
	@Override()
	public LoggingManager getLoggingManager() {
		return this.loggingManager;
	}

	/**
	 * Establece el campo loggingManager.
	 * 
	 * @param loggingManager loggingManager
	 */
	@Override()
	public void setLoggingManager(LoggingManager loggingManager) {
		this.loggingManager = loggingManager;
	}
}
