package com.ejie.aa80a.jms;

import java.util.Properties;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

/**
 * Clase que se encarga de enviar mensajes a través de colas JMS
 * 
 *  
 * 
 */
public class InvoiceQueueSender {

	private static final String EVENT_TIPOLOGY_GAURKOTU = "actualizacion_gaurkotu";
	private static final String EVENT_WHAT_GAURKOTU = "ACTUALIZACION GAURKOTU";
	private static final String EVENT_WHO_GAURKOTU = "AA80A-GAURKOTU";

	@Autowired()
	private Properties appConfiguration;

	private JmsTemplate jmsTemplate;

	/**
	 * Establece el campo jmsTemplate.
	 * 
	 * @param jmsTemplate jmsTemplate
	 */
	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

	/**
	 * Envía un mensaje a una cola.
	 * 
	 * @param texto Texto del mensaje a enviar a la cola
	 */
	public void sendMesage(final String texto) {
		MessageCreator messageCreator = new MessageCreator() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.springframework.jms.core.MessageCreator#createMessage(javax.jms.Session)
			 */
			@Override()
			public Message createMessage(Session session) throws JMSException {
				TextMessage mensaje = session.createTextMessage();
				mensaje.setStringProperty("EventTipology", EVENT_TIPOLOGY_GAURKOTU);
				mensaje.setStringProperty("EventWhat", EVENT_WHAT_GAURKOTU);
				mensaje.setStringProperty("EventWho", EVENT_WHO_GAURKOTU);
				mensaje.setText(texto);

				return mensaje;
			}
		};

		this.jmsTemplate.send(this.appConfiguration.getProperty("notificacion.colasJMS.cola"), messageCreator);
	}

}
