package com.ejie.aa80a.dao;

import java.util.List;

import com.ejie.aa80a.model.FiltroSugerencia;
import com.ejie.aa80a.model.Recurso;
import com.ejie.aa80a.model.Sugerencia;

/**
 * Interfaz de acceso a la base de datos para tratar datos de sugerencias
 * 
 *  
 */
public interface SugerenciaDao {

	/**
	 * Inserta la nueva sugerencia en la tabla SUGERENCIAS.
	 * 
	 * @param recurso {@link Recurso} objeto con los datos del recurso
	 * @param username Login actual
	 */
	void insertarSugerenciaRecurso(Recurso recurso, String username);

	/**
	 * Devuelve un listado de sugerencias
	 * 
	 * @param filtro parámetros de la búsqueda de sugerencias
	 * @return listado de sugerencias
	 */
	List<Sugerencia> findSugerenciaByCriteria(FiltroSugerencia filtro);

	/**
	 * Devuelve el número de filas de la consulta de sugerencias
	 * 
	 * @param filtro parámetros de la búsqueda de sugerencias
	 * @return número de filas
	 */
	int findSugerenciaByCountCriteria(FiltroSugerencia filtro);

	/**
	 * Actualiza el estado de una sugerencia
	 * 
	 * @param codigo código de la sugerencia
	 * @param estado estado al que se actualizará la sugerencia
	 */
	void actualizarEstadoSugerencia(Long codigo, String estado);

}
