package com.ejie.aa80a.dao;

import java.util.List;

import com.ejie.aa80a.model.FiltroNotificacion;
import com.ejie.aa80a.model.Notificacion;

/**
 * interfaz de acceso a la base de datos para trarar datos de notificacines
 * 
 *  
 * 
 */
public interface NotificacionDao {

	/**
	 * Devuelve el listado de notificaciones
	 * 
	 * @param filtro datos del filtro de notificaciones
	 * @return listado de notificaciones
	 */
	List<Notificacion> findNotificacionByCriteria(FiltroNotificacion filtro);

	/**
	 * Devuelve el número de filas totales de la consulta
	 * 
	 * @param filtro datos del filtro de notificaciones
	 * @return número de filas
	 */
	int findNotificacionByCountCriteria(FiltroNotificacion filtro);

	/**
	 * Actualiza el estado de una notificación
	 * 
	 * @param codigo Código de la notificación
	 * @param estado Estado al que hay que actualizar la notificación
	 */
	void actualizarEstadoNotificacion(Long codigo, String estado);

}
