package com.ejie.aa80a.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa80a.util.Constants;

/**
 * Clase que accede a la base de datos para tratar datos de histórico de modificaciones. Tablas: HISTORICO_GAURKOTU
 * 
 *  
 */
@Repository()
@Transactional()
public class HistoricoDaoImpl implements HistoricoDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa80a.dao.HistoricoDao#insertarHistoricoRecurso(java.lang.Long, java.lang.String, java.lang.String)
	 */
	@Override()
	public void insertarHistoricoRecurso(Long codigoRecurso, String tipoActualizacion, String username) {
		this.jdbcTemplate
				.update("INSERT INTO HISTORICO_GAURKOTU (IDHISTORICO, COREC, TIPO, ESTADO, USUMODIF, FECMODIF) VALUES (AA80A03Q00.NEXTVAL, ?, ?, ?, ?, SYSDATE)",
						codigoRecurso, tipoActualizacion, Constants.ACTUALIZACION_ENVIADA, username);

	}
}
