package com.ejie.aa80a.dao;

import java.util.List;

import com.ejie.aa80a.model.Localidad;
import com.ejie.aa80a.model.Municipio;

/**
 * Interfaz de acceso a la base de datos para tratar datos de histórico de modificaciones
 * 
 *  
 */
public interface FcaDao {

	/**
	 * Busca y devuelve la lista de municipios
	 * 
	 * @param filtroMunicipio filtro aplicado
	 * @return lista de municipios
	 */
	public List<Municipio> findMunicipios(Municipio filtroMunicipio);

	/**
	 * Busca y devuelve la lista de localidades
	 * 
	 * @param filtroLocalidad filtro aplicado
	 * @return lista de localidades
	 */
	public List<Localidad> findLocalidades(Localidad filtroLocalidad);

	/**
	 * Devuelve la lista de municipios de una provincia
	 * 
	 * @param filtroMunicipio filtro aplicado
	 * @return lista de municipios
	 */
	public List<Municipio> findMunicipiosByProvincia(Municipio filtroMunicipio);

	/**
	 * Devuelve la lista de localidades de un municipio y provincia
	 * 
	 * @param filtroLocalidad filtro aplicado
	 * @return lista de localidades
	 */
	public List<Localidad> findLocalidadesByMunicipio(Localidad filtroLocalidad);

}
