/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.tiles.autotag.core.AutotagRuntimeException;
import org.apache.tiles.autotag.generate.TemplateSuiteGenerator;
import org.apache.tiles.autotag.model.TemplateSuite;
import org.apache.tiles.autotag.tool.StringTool;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public abstract class AbstractTemplateSuiteGenerator
implements TemplateSuiteGenerator {
    private VelocityEngine velocityEngine;

    public AbstractTemplateSuiteGenerator(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(File directory, String packageName, TemplateSuite suite, Map<String, String> parameters) {
        File dir = new File(directory, this.getDirectoryName(directory, packageName, suite, parameters));
        dir.mkdirs();
        File file = new File(dir, this.getFilename(dir, packageName, suite, parameters));
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)packageName);
        context.put("suite", (Object)suite);
        context.put("stringTool", (Object)new StringTool());
        context.put("parameters", parameters);
        try {
            file.createNewFile();
            Template template = this.velocityEngine.getTemplate(this.getTemplatePath(dir, packageName, suite, parameters));
            FileWriter writer = new FileWriter(file);
            try {
                template.merge((Context)context, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (ResourceNotFoundException e) {
            throw new AutotagRuntimeException("Cannot find template resource", e);
        }
        catch (ParseErrorException e) {
            throw new AutotagRuntimeException("The template resource is not parseable", e);
        }
        catch (IOException e) {
            throw new AutotagRuntimeException("I/O Exception when generating file", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AutotagRuntimeException("Another generic exception while parsing the template resource", e);
        }
    }

    protected abstract String getTemplatePath(File var1, String var2, TemplateSuite var3, Map<String, String> var4);

    protected abstract String getFilename(File var1, String var2, TemplateSuite var3, Map<String, String> var4);

    protected abstract String getDirectoryName(File var1, String var2, TemplateSuite var3, Map<String, String> var4);
}

