package com.ejie.y40a.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.FormacionBusqueda;
import com.ejie.y40a.model.FormacionDetalle;
import com.ejie.y40a.service.EntidadService;
import com.ejie.y40a.service.FormacionService;
import com.ejie.y40a.service.Y40aExcelGeneratorService;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * UsuariosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/usuarios")
public class UsuariosController {

	private static final Logger logger = LoggerFactory
			.getLogger(UsuariosController.class);

	@Autowired
	private FormacionService formacionService;

	@Autowired
	private EntidadService entidadService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------------------------------------------------------------
	 * ---INICIO------------ Tratamiento de errores comun para los proyectos
	 * UDA. --------------------------------------------------------------------
	 */
	@Autowired
	private Y40aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y40aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------------------------------------------------------------
	 * ---FIN------------ Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("usuario", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aUsuariosBusqueda", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacionesBusqueda(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aUsuariosBusqueda", "model", model);
	}

	/**
	 * Method 'getAllLike'.
	 * 
	 * @param idCat_
	 *            String
	 * @param nombre_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param visibleWeb_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLike(

	@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "email", required = false) String email_,
			@RequestParam(value = "usuario", required = false) String usuario_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String email = ("".equals(email_)) ? null : email_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String usuario = ("".equals(usuario_)) ? null : usuario_;

			Entidad filterEntidad = new Entidad();
			filterEntidad.setEmail(email);
			filterEntidad.setNombreEs(nombre);
			filterEntidad.setUsuario(usuario);

			Pagination pagination = new Pagination();

			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			List<Entidad> entidadesLista = this.entidadService
					.findAllLikeTabla(filterEntidad, pagination, false);

			if (entidadesLista == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.entidadService.findAllLikeTablaCount(
					filterEntidad, false);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(entidadesLista);
			return data;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdFormacion'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/getByIdFormacion/{idFor}", method = RequestMethod.GET)
	public @ResponseBody
	FormacionDetalle getByIdFormacion(@PathVariable String idFor) {
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion = this.formacionService.findFormacion(formacion);
			if (formacion == null) {
				throw new Exception(idFor.toString());
			}

			FormacionDetalle formacionDetalle = new FormacionDetalle();
			formacionDetalle.setIdFor(formacion.getIdFor());
			formacionDetalle.setNombreCortoEs(formacion.getNombreCortoEs());
			formacionDetalle.setNombreCortoEu(formacion.getNombreCortoEu());
			formacionDetalle.setNombreEs(formacion.getNombreEs());
			formacionDetalle.setNombreEu(formacion.getNombreEu());
			formacionDetalle.setDescripcionEs(formacion.getDescripcionEs());
			formacionDetalle.setDescripcionEu(formacion.getDescripcionEu());
			formacionDetalle.setIdCat(formacion.getCategoria().getIdCat());
			formacionDetalle.setJerarquiaCategoria(formacion.getCategoria()
					.getJerarquiaCategoria());
			formacionDetalle.setJerarquiaFormacion(formacion
					.getJerarquiaFormacion());
			formacionDetalle.setVisibleWeb(formacion.getVisibleWeb());
			formacionDetalle.setVisibleContactoCat(formacion
					.getVisibleContactoCat());
			formacionDetalle.setNueva(formacion.getNueva());

			formacion = this.formacionService.findFormacionEtiqueta(formacion,
					null, null);
			List<Etiqueta> lstEtiquetasFormacion = formacion.getEtiquetas();
			List<String> lstIdsEtiquetas = new ArrayList<String>();
			List<String> lstDescsEtiquetas = new ArrayList<String>();
			StringBuffer strIdsEtiquetas = new StringBuffer();
			StringBuffer strDescsEtiquetas = new StringBuffer();

			strDescsEtiquetas.append("[");

			boolean firstElement = true;

			// se recorre para obtener los ids de etiquetas
			for (Etiqueta etiqueta : lstEtiquetasFormacion) {
				lstIdsEtiquetas.add(etiqueta.getIdEtiqueta());
				lstDescsEtiquetas.add(etiqueta.getNombre());
				if (firstElement) {
					strIdsEtiquetas.append(etiqueta.getIdEtiqueta());
					strDescsEtiquetas.append(etiqueta.getNombre());
					firstElement = false;
				} else {
					strIdsEtiquetas.append(",")
							.append(etiqueta.getIdEtiqueta());
					strDescsEtiquetas.append(",").append(etiqueta.getNombre());
				}
			}
			strDescsEtiquetas.append("]");

			formacionDetalle.setIdsEtiquetas(strIdsEtiquetas.toString());
			formacionDetalle.setDescsEtiquetas(strDescsEtiquetas.toString());

			return formacionDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idFor}", method = RequestMethod.GET)
	public @ResponseBody
	Formacion getById(@PathVariable String idFor) {
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion = this.formacionService.find(formacion);
			if (formacion == null) {
				throw new Exception(idFor.toString());
			}
			return formacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idFor
	 *            String
	 * @param categoriaIdCat
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param nombreCortoEs
	 *            String
	 * @param nombreCortoEu
	 *            String
	 * @param descripcionEs
	 *            String
	 * @param descripcionEu
	 *            String
	 * @param visibleWeb
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idFor", required = false) String idFor,
			@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "nombreCortoEs", required = false) String nombreCortoEs,
			@RequestParam(value = "nombreCortoEu", required = false) String nombreCortoEu,
			@RequestParam(value = "descripcionEs", required = false) String descripcionEs,
			@RequestParam(value = "descripcionEu", required = false) String descripcionEu,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb,
			HttpServletRequest request) {
		try {
			Formacion filterFormacion = new Formacion(idFor, nombreEs,
					nombreEu, nombreCortoEs, nombreCortoEu, descripcionEs,
					descripcionEu, visibleWeb, null, new Categoria(
							categoriaIdCat, null, null, null, null, null, null,
							null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Formacion> formacions = this.formacionService.findAll(
						filterFormacion, pagination);

				if (formacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterFormacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(formacions);
				return data;
			} else {
				List<Formacion> formacions = this.formacionService.findAll(
						filterFormacion, pagination);
				if (formacions == null) {
					throw new Exception("No data Found.");
				}
				return formacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterFormacion
	 *            Formacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "formacion", required = false) Formacion filterFormacion,
			HttpServletRequest request) {
		try {
			return formacionService
					.findAllCount(filterFormacion != null ? filterFormacion
							: new Formacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param response
	 *            HttpServletResponse
	 * @return Formacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Formacion edit(@RequestBody Formacion formacion,
			HttpServletResponse response) {
		try {
			Formacion formacionAux = this.formacionService.update(formacion);
			logger.info("Entity correctly inserted!");
			return formacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getFormacionService'.
	 * 
	 * @return FormacionService
	 */
	protected FormacionService getFormacionService() {
		return this.formacionService;
	}

	/**
	 * Method 'setFormacionService'.
	 * 
	 * @param formacionService
	 *            FormacionService
	 * @return
	 */
	public void setFormacionService(FormacionService formacionService) {
		this.formacionService = formacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aUsuariosModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aUsuariosModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aUsuariosModal", "model", model);
	}

	/**
	 * Method 'editUsuario'.
	 * 
	 * @param entidad
	 *            Entidad
	 * 
	 * @return Formacion
	 */
	@RequestMapping(value = "/edicionUsuario", method = RequestMethod.PUT)
	public @ResponseBody
	Integer editUsuario(@RequestBody Entidad entidad) {
		try {
			Entidad entidadBusqueda = new Entidad();
			entidadBusqueda.setEntidadId(entidad.getEntidadId());
			entidadBusqueda = entidadService.find(entidadBusqueda);
			entidadBusqueda.setEmail(entidad.getEmail().trim());
			entidadBusqueda.setUsuario(entidad.getUsuario().trim());
			entidadService.update(entidadBusqueda);
		} catch (Exception e) {

		}
		return 1;
	}

	/**
	 * Method 'enviarEmail'.
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/envioEmail/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	boolean envioEmail(@PathVariable String entidadId) {
		try {

			Entidad entidadAux = new Entidad();
			entidadAux.setEntidadId(entidadId);
			entidadAux = this.entidadService.find(entidadAux);

			boolean enviado = this.entidadService.envioEmail(entidadAux);

			return enviado;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param usuario
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintCambioPassword/{usuario}", method = RequestMethod.GET)
	public ModelAndView getCreateFormCambioPassword(
			@PathVariable String usuario, Model model,
			HttpServletRequest request) {

		request.getSession().removeAttribute(
				"SPRING_SECURITY_SAVED_REQUEST_KEY");

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y39aVistaWar.default.language"));

		model.addAttribute("defaultLayout",
				appConfiguration.get("y39aVistaWar.default.layout"));

		model.addAttribute("usuario", usuario);
		Entidad entidad = new Entidad();
		entidad.setUsuario(usuario);
		entidad = entidadService.findEntidadUser(entidad);
		model.addAttribute("password", entidad.getPassword());
		model.addAttribute("nombre", entidad.getNombre());

		return new ModelAndView("cambioPassword", "model", model);
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEntidad
	 *            Entidad
	 * @return Entidad
	 */
	@RequestMapping(value = "/regEntidad", method = RequestMethod.PUT)
	public @ResponseBody
	Object getAll(@RequestBody Entidad filterEntidad) {
		try {
			Entidad entidad = new Entidad();
			entidad = this.entidadService.findEntidadUser(filterEntidad);

			if (entidad == null) {
				throw new Exception("Entity not found");
			}
			return entidad;
		} catch (Exception e) {
			throw new ResourceNotFoundException("Entity not found");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param response
	 *            HttpServletResponse
	 * @return Entidad
	 */
	@RequestMapping(value = "/updatePassword", method = RequestMethod.PUT)
	public @ResponseBody
	Entidad editPasswords(@RequestBody Entidad entidad,
			HttpServletResponse response) {
		try {

			return this.entidadService.updatePassword(entidad);

		} catch (Exception e) {
			// e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

}
