package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
//import java.util.Locale;
import java.util.Properties;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.GrupoEntidad;
import com.ejie.y40a.model.Y40aArbolFormaciones;
import com.ejie.y40a.service.SolicitudService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.model.SolicitudDetalle;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;
import com.ejie.y40a.utils.tree.Y40aFormacionesTree;
import com.ejie.y40a.service.GrupoEntidadService;
import com.ejie.y40a.service.ArbolFormacionesService;

/**
 * * SolicitudController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/solicitud")
public class SolicitudController {

	private static final Logger logger = LoggerFactory
			.getLogger(SolicitudController.class);

	@Autowired
	private SolicitudService solicitudService;

	@Autowired
	private GrupoEntidadService grupoEntidadService;

	@Autowired
	private ArbolFormacionesService arbolFormacionesService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------------------------------------------------------------
	 * ---INICIO------------ Tratamiento de errores comun para los proyectos
	 * UDA. --------------------------------------------------------------------
	 */
	@Autowired
	private Y40aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y40aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------------------------------------------------------------
	 * ---FIN------------ Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("solicitud", "model", model);
	}

	/**
	 * Method 'getCreateFormSolicitante'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/solicitante", method = RequestMethod.GET)
	public ModelAndView getCreateFormSolicitante(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("solicitante", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idSol
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idSol}", method = RequestMethod.GET)
	public @ResponseBody
	Solicitud getById(@PathVariable String idSol) {
		try {
			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			solicitud = this.solicitudService.find(solicitud);
			if (solicitud == null) {
				throw new Exception(idSol.toString());
			}
			return solicitud;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idSol.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idSol
	 *            String
	 * @param fechaSol
	 *            Date
	 * @param formacionIdFor
	 *            String
	 * @param entidadEntidadId
	 *            String
	 * @param grupo
	 *            String
	 * @param participantes
	 *            Long
	 * @param provincia
	 *            String
	 * @param diaImparticion
	 *            Date
	 * @param horarioImparticion
	 *            String
	 * @param asistentes
	 *            Long
	 * @param cancelado
	 *            String
	 * @param idioma
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idSol", required = false) String idSol,
			@RequestParam(value = "fechaSol", required = false) Date fechaSol,
			@RequestParam(value = "formacionIdFor", required = false) String formacionIdFor,
			@RequestParam(value = "entidadEntidadId", required = false) String entidadEntidadId,
			@RequestParam(value = "grupo", required = false) String grupo,
			@RequestParam(value = "participantes", required = false) Long participantes,
			@RequestParam(value = "provincia", required = false) String provincia,
			@RequestParam(value = "diaImparticion", required = false) Date diaImparticion,
			// FIXME@RequestParam(value = "horarioImparticion", required =
			// false) String horarioImparticion,
			@RequestParam(value = "horaInicio", required = false) String horaInicio,
			@RequestParam(value = "horaFin", required = false) String horaFin,
			@RequestParam(value = "asistentes", required = false) Long asistentes,
			@RequestParam(value = "numMujeres", required = false) Long numMujeres,
			@RequestParam(value = "numHombres", required = false) Long numHombres,
			@RequestParam(value = "cancelado", required = false) String cancelado,
			@RequestParam(value = "idioma", required = false) String idioma,
			HttpServletRequest request) {
		try {
			Solicitud filterSolicitud = new Solicitud(idSol, fechaSol,
					new Formacion(formacionIdFor, null, null, null, null, null,
							null, null, null, null, null), new Entidad(
							entidadEntidadId, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null), grupo,
					participantes, provincia, diaImparticion, horaInicio,
					horaFin, asistentes, numMujeres, numHombres, cancelado,
					idioma, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Solicitud> solicituds = this.solicitudService.findAll(
						filterSolicitud, pagination);

				if (solicituds == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterSolicitud, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(solicituds);
				return data;
			} else {
				List<Solicitud> solicituds = this.solicitudService.findAll(
						filterSolicitud, pagination);
				if (solicituds == null) {
					throw new Exception("No data Found.");
				}
				return solicituds;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountSolicitudesConFormacion'.
	 * 
	 * @param idFor
	 *            String
	 * 
	 * @return Long
	 */
	@RequestMapping(value = "/countSolicitudesFormacion/{idFor}", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountSolicitudesConFormacion(@PathVariable String idFor) {
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);

			Solicitud solicitud = new Solicitud();
			solicitud.setFormacion(formacion);

			return solicitudService.findAllCount(solicitud != null ? solicitud
					: new Solicitud());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterSolicitud
	 *            Solicitud
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "solicitud", required = false) Solicitud filterSolicitud,
			HttpServletRequest request) {
		try {
			return solicitudService
					.findAllCount(filterSolicitud != null ? filterSolicitud
							: new Solicitud());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param response
	 *            HttpServletResponse
	 * @return Solicitud
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Solicitud edit(@RequestBody Solicitud solicitud,
			HttpServletResponse response) {
		try {
			Solicitud solicitudAux = this.solicitudService.update(solicitud);
			logger.info("Entity correctly inserted!");
			return solicitudAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editSolicitud'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param response
	 *            HttpServletResponse
	 * @return Solicitud
	 */
	@RequestMapping(value = "/modificarSolicitud", method = RequestMethod.PUT)
	public @ResponseBody
	Solicitud editSolicitud(@RequestBody SolicitudDetalle solicitudDetalle,
			HttpServletResponse response) {
		try {
			Solicitud solicitud = new Solicitud();

			solicitud.setIdSol(solicitudDetalle.getIdSol());

			solicitud
					.setBloqueada(("on".equals(solicitudDetalle.getBloqueada())) ? Y40aConstantes.SI
							: Y40aConstantes.NO);

			// ******ENTIDAD**********
			Entidad entidad = new Entidad();

			entidad.setEntidadId(solicitudDetalle.getEntidadId());

			solicitud.setEntidad(entidad);

			// ******FORMACION**********
			Formacion formacion = new Formacion();

			formacion.setIdFor(solicitudDetalle.getIdFor());

			solicitud.setFormacion(formacion);

			// *****ETIQUETAS********
			String idsEtiquetas = solicitudDetalle.getIdsEtiquetas();

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			solicitud.setEtiquetas(etiquetas);

			// *****GRUPOS**************
			solicitud.setGrupo(solicitudDetalle.getGrupo().toUpperCase());
			// *****PARTICIPANTES********
			solicitud.setParticipantes(solicitudDetalle.getParticipantes());
			// *****PROVINCIA************
			solicitud.setProvincia(solicitudDetalle.getProvincia());
			// *****DIA IMPARTICION************
			solicitud.setDiaImparticion(solicitudDetalle.getDiaImparticion());
			// FIXME *****HORARIO IMPARTICION************
			// solicitud.setHorarioImparticion(solicitudDetalle
			// .getHorarioImparticion());
			// Hora inicio y hora de fin

			if (Y40aUtils.isFilled(solicitudDetalle.getHoraInicio())) {
				String strInitTime = solicitudDetalle.getHoraInicio();
				if (solicitudDetalle.getHoraInicio().length() >= 5) {
					strInitTime = strInitTime.substring(0, 5);
				}
				solicitud.setHoraInicio(strInitTime);
			}

			if (Y40aUtils.isFilled(solicitudDetalle.getHoraFin())) {
				String strEndTime = solicitudDetalle.getHoraFin();
				if (solicitudDetalle.getHoraFin().length() >= 5) {
					strEndTime = strEndTime.substring(0, 5);
				}
				solicitud.setHoraFin(strEndTime);
			}

			// *****ASISTENTES************
			solicitud.setAsistentes(solicitudDetalle.getAsistentes());
			// *****NUMMUJERES************
			solicitud.setNumMujeres(solicitudDetalle.getNumMujeres());
			// *****NUMHOMBRES************
			solicitud.setNumHombres(solicitudDetalle.getNumHombres());
			// *****CANCELADO************

			if (solicitudDetalle.getCancelado() != null) {
				String sCancelado = solicitudDetalle.getCancelado();

				if (sCancelado.equals(Y40aConstantes.SI)) {
					solicitud.setCancelado(Y40aConstantes.SI);
				}
			} else {
				solicitud.setCancelado(Y40aConstantes.NO);
			}

			// *****IDIOMA************
			solicitud.setIdioma(solicitudDetalle.getIdioma());

			solicitud.setObservaciones(solicitudDetalle.getObservaciones());

			// ***** Contacto *****
			solicitud.setNombapecontacto(solicitudDetalle.getNombapecontacto());
			solicitud.setEmailcontacto(solicitudDetalle.getEmailcontacto());
			solicitud.setTelcontacto(solicitudDetalle.getTelcontacto());
			solicitud.setObservasolicitante(solicitudDetalle
					.getObservasolicitante());

			solicitud.setIdMotivo(solicitudDetalle.getIdMotivo());

			Solicitud solicitudAux = this.solicitudService
					.updateSolicitud(solicitud);
			logger.info("Entity correctly inserted!");
			return solicitudAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Solicitud add(@RequestBody Solicitud solicitud) {
		try {
			Solicitud solicitudAux = this.solicitudService.add(solicitud);
			logger.info("Entity correctly inserted!");
			return solicitudAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addSolicitud'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return Solicitud
	 */
	@RequestMapping(value = "/grabarSolicitud", method = RequestMethod.POST)
	public @ResponseBody
	Solicitud addSolicitud(@RequestBody SolicitudDetalle solicitudDetalle) {
		try {

			// Locale locale = LocaleContextHolder.getLocale();
			Solicitud solicitud = new Solicitud();

			solicitud
					.setBloqueada(("on".equals(solicitudDetalle.getBloqueada())) ? Y40aConstantes.SI
							: Y40aConstantes.NO);
			// ******ENTIDAD**********
			Entidad entidad = new Entidad();

			entidad.setEntidadId(solicitudDetalle.getEntidadId());
			/*
			 * if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			 * entidad.setNombreEs(solicitudDetalle.getNombreEs()); } else {
			 * entidad.setNombreEu(solicitudDetalle.getNombreEu()); }
			 */
			solicitud.setEntidad(entidad);

			// ******FORMACION**********
			Formacion formacion = new Formacion();

			formacion.setIdFor(solicitudDetalle.getIdFor());
			/*
			 * if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
			 * formacion.setNombreEs(solicitudDetalle.getNombreFormacionEs()); }
			 * else {
			 * formacion.setNombreEu(solicitudDetalle.getNombreFormacionEu()); }
			 */
			solicitud.setFormacion(formacion);

			// *****ETIQUETAS********
			String idsEtiquetas = solicitudDetalle.getIdsEtiquetas();

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			solicitud.setEtiquetas(etiquetas);

			// *****GRUPOS**************
			solicitud.setGrupo(solicitudDetalle.getGrupo().toUpperCase());
			// *****PARTICIPANTES********
			solicitud.setParticipantes(solicitudDetalle.getParticipantes());
			// *****PROVINCIA************
			solicitud.setProvincia(solicitudDetalle.getProvincia());
			// *****DIA IMPARTICION************
			solicitud.setDiaImparticion(solicitudDetalle.getDiaImparticion());
			// *****HORARIO IMPARTICION************
			// FIXME solicitud.setHorarioImparticion(solicitudDetalle
			// .getHorarioImparticion());

			if (Y40aUtils.isFilled(solicitudDetalle.getHoraInicio())) {
				if (solicitudDetalle.getHoraInicio().length() >= 5) {
					String strInitTime = solicitudDetalle.getHoraInicio();
					strInitTime = strInitTime.substring(0, 5);
					solicitud.setHoraInicio(strInitTime);
				}
			}

			if (Y40aUtils.isFilled(solicitudDetalle.getHoraFin())) {
				if (solicitudDetalle.getHoraFin().length() >= 5) {
					String strEndTime = solicitudDetalle.getHoraFin();
					strEndTime = strEndTime.substring(0, 5);
					solicitud.setHoraFin(strEndTime);
				}
			}

			// *****ASISTENTES************
			solicitud.setAsistentes(solicitudDetalle.getAsistentes());
			// *****NUMMUJERES************
			solicitud.setNumMujeres(solicitudDetalle.getNumMujeres());
			// *****NUMHOMBRES************
			solicitud.setNumHombres(solicitudDetalle.getNumHombres());

			// *****CANCELADO************

			if (solicitudDetalle.getCancelado() != null) {
				String sCancelado = solicitudDetalle.getCancelado();

				if (sCancelado.equals(Y40aConstantes.SI)) {
					solicitud.setCancelado(Y40aConstantes.SI);
				}
			} else {
				solicitud.setCancelado(Y40aConstantes.NO);
			}

			// *****IDIOMA************
			solicitud.setIdioma(solicitudDetalle.getIdioma());

			solicitud.setObservaciones(solicitudDetalle.getObservaciones());

			// ***** Contacto *****
			solicitud.setNombapecontacto(solicitudDetalle.getNombapecontacto());
			solicitud.setEmailcontacto(solicitudDetalle.getEmailcontacto());
			solicitud.setTelcontacto(solicitudDetalle.getTelcontacto());
			solicitud.setObservasolicitante(solicitudDetalle
					.getObservasolicitante());

			solicitud.setIdMotivo(solicitudDetalle.getIdMotivo());

			Solicitud solicitudAux = this.solicitudService
					.addSolicitud(solicitud);
			logger.info("Entity correctly inserted!");
			return solicitudAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idSol
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idSol}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idSol, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			this.solicitudService.remove(solicitud);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idSol);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param solicitudIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> solicitudIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Solicitud> solicitudList = new ArrayList<Solicitud>();
		try {
			for (ArrayList<String> solicitudId : solicitudIds) {
				Iterator<String> iterator = solicitudId.iterator();
				Solicitud solicitud = new Solicitud();
				solicitud.setIdSol(ObjectConversionManager.convert(
						iterator.next(), String.class));
				solicitudList.add(solicitud);
			}
			this.solicitudService.removeMultiple(solicitudList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getSolicitudService'.
	 * 
	 * @return SolicitudService
	 */
	protected SolicitudService getSolicitudService() {
		return this.solicitudService;
	}

	/**
	 * Method 'setSolicitudService'.
	 * 
	 * @param solicitudService
	 *            SolicitudService
	 * @return
	 */
	public void setSolicitudService(SolicitudService solicitudService) {
		this.solicitudService = solicitudService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' SolicitudEtiqueta
	 * 
	 * @param idSol
	 *            String
	 * @param etiquetaIdEtiqueta
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindSolicitudEtiqueta", method = RequestMethod.POST)
	public void unBindSolicitudEtiqueta(
			@RequestParam(value = "idSol", required = false) String idSol,
			@RequestParam(value = "etiquetaIdEtiqueta", required = false) String etiquetaIdEtiqueta) {
		Solicitud solicitud = new Solicitud();
		Etiqueta etiqueta = new Etiqueta();
		if (idSol != null) {
			solicitud.setIdSol(idSol);
		}
		if (etiquetaIdEtiqueta != null) {
			etiqueta.setIdEtiqueta(etiquetaIdEtiqueta);
		}
		solicitud.getEtiquetas().add(etiqueta);
		this.solicitudService.removeSolicitudEtiqueta(solicitud);
	}

	/**
	 * Method 'bind' SolicitudEtiqueta
	 * 
	 * @param idSol
	 *            String
	 * @param etiquetaIdEtiqueta
	 *            String
	 */
	@RequestMapping(value = "/bindSolicitudEtiqueta", method = RequestMethod.POST)
	public void bindSolicitudEtiqueta(
			@RequestParam(value = "idSol", required = false) String idSol,
			@RequestParam(value = "etiquetaIdEtiqueta", required = false) String etiquetaIdEtiqueta) {
		Solicitud solicitud = new Solicitud();
		Etiqueta etiqueta = new Etiqueta();
		if (idSol != null) {
			solicitud.setIdSol(idSol);
		}
		if (etiquetaIdEtiqueta != null) {
			etiqueta.setIdEtiqueta(etiquetaIdEtiqueta);
		}
		solicitud.getEtiquetas().add(etiqueta);
		this.solicitudService.addSolicitudEtiqueta(solicitud);
	}

	/**
	 * Loading Main tree de la lista de etiquetas
	 * 
	 * @param entidadId
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * 
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "y40aArbolCategoriasFormaciones", method = RequestMethod.GET)
	public void showListaEtiquetas(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "mostrarCategoria", required = false) String mostrarCategoria,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		try {

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");
			PrintWriter out = response.getWriter();

			GrupoEntidad grupoEntidadAux = new GrupoEntidad();
			grupoEntidadAux.setEntidadId(entidadId);

			List<GrupoEntidad> lstGruposEntidad = this.grupoEntidadService
					.findAll(grupoEntidadAux, null);

			// grupos Ids
			List<Grupo> grupos = new ArrayList<Grupo>();

			for (GrupoEntidad grupoEntidad : lstGruposEntidad) {
				Grupo grupo = new Grupo();
				grupo.setGrupoId(grupoEntidad.getGrupoId());
				grupos.add(grupo);
			}

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			boolean blnmostrarCategoria = false;

			if ("true".equals(mostrarCategoria)) {
				blnmostrarCategoria = true;
			}

			Y40aArbolFormaciones arbolFormaciones = this.arbolFormacionesService
					.obtenerArbol(blnmostrarCategoria, perfiles, grupos);

			String json = Y40aFormacionesTree
					.obtieneJsonArbol(arbolFormaciones);

			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"y40aArbolCategoriasFormaciones");
		}

	}

	/**
	 * Method 'bloquearSolicitudes'.
	 * 
	 * @param solicitudIds
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/bloquear", method = RequestMethod.PUT)
	public @ResponseBody
	void bloquear(@RequestBody String solicitudIds, HttpServletResponse response) {

		try {
			List<Solicitud> solicitudes = new ArrayList<Solicitud>();

			if (null != solicitudIds && !"".equals(solicitudIds)) {
				Solicitud solicitud = null;
				for (String idSol : solicitudIds.split(",")) {
					solicitud = new Solicitud();// NOPMD 2015/10/06 (IDA)
					solicitud.setIdSol(idSol);
					solicitudes.add(solicitud);
				}
			}

			this.solicitudService.blockMultiple(solicitudes);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'desbloquearSolicitudes'.
	 * 
	 * @param solicitudIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/desbloquear", method = RequestMethod.PUT)
	public @ResponseBody
	void desbloquear(@RequestBody String solicitudIds,
			HttpServletResponse response) {

		try {
			List<Solicitud> solicitudes = new ArrayList<Solicitud>();
			// Generar el listado listado de solicitudes
			if (null != solicitudIds && !"".equals(solicitudIds)) {
				Solicitud solicitud = null;
				for (String idSol : solicitudIds.split(",")) {
					solicitud = new Solicitud();// NOPMD 2015/10/06 (IDA)
					solicitud.setIdSol(idSol);
					solicitudes.add(solicitud);
				}
			}
			this.solicitudService.unblockMultiple(solicitudes);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}
}
