package com.ejie.y40a.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.ejie.y40a.service.Y40aExcelGeneratorService;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.model.SolicitudDetalle;
import com.ejie.y40a.service.SolicitudService;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * PlanificacionFormacionBusquedaController  
 * 14:46:39.
 * 
 *  
 */
@Controller
@RequestMapping(value = "/y40aFormacionGrupo")
public class PlanificacionFormacionBusquedaController {

	public static final Logger logger = LoggerFactory
			.getLogger(PlanificacionFormacionBusquedaController.class);

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private SolicitudService solicitudService;

	@Autowired
	private Y40aExcelGeneratorService y40aExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacion(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("formacionGrupo", "model", model);
	}

	/**
	 * Method 'getCreateFormY40aFormacioGrupo'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "porFormacionGrupo", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacioGrupo(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("porFormacionGrupo", "model", model);
	}

	/**
	 * Method 'getCreateFormY40aPlanificacionFormaciones'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "planificacionFormaciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aPlanificacionFormaciones(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("planificacionFormaciones", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idSol
	 *            String
	 * @param entidadId
	 *            String
	 * @param idFor
	 *            String
	 * @param fechaSol
	 *            Date
	 * @param grupo
	 *            String
	 * @param idioma
	 *            String
	 * @param participantes
	 *            Long
	 * 
	 * @param diaImparticion
	 *            Date
	 * 
	 * @param horarioImparticion
	 *            String
	 * 
	 * @param asistentes
	 *            Long
	 * 
	 * @param cancelado
	 *            String
	 * 
	 * @param provinciaImparticion
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/all", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idSol", required = false) String idSol,
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "idFor", required = false) String idFor,
			@RequestParam(value = "fechaSol", required = false) Date fechaSol,
			@RequestParam(value = "grupo", required = false) String grupo,
			@RequestParam(value = "idioma", required = false) String idioma,
			@RequestParam(value = "participantes", required = false) Long participantes,
			@RequestParam(value = "diaImparticion", required = false) Date diaImparticion,
			// FIXME @RequestParam(value = "horarioImparticion", required =
			// false) String horarioImparticion,
			@RequestParam(value = "horaInicio", required = false) String horaInicio,
			@RequestParam(value = "horaFin", required = false) String horaFin,
			@RequestParam(value = "asistentes", required = false) Long asistentes,
			@RequestParam(value = "cancelado", required = false) String cancelado,
			@RequestParam(value = "provinciaImparticion", required = false) String provinciaImparticion,
			HttpServletRequest request) {
		try {
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda = new PlanificacionFormacionBusqueda(
					idSol, fechaSol, idFor, null, null, null, null, null, null,
					null, entidadId, null, null, grupo, idioma, participantes,
					diaImparticion, provinciaImparticion, // FIXME
															// horarioImparticion,
					horaInicio, horaFin, asistentes, cancelado);
			Pagination pagination = null;

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlanificacionFormacionBusqueda> planiFormacionBusqueda = this.solicitudService
						.findAllPlanificacionFormacion(
								planificacionFormacionBusqueda, perfiles,
								pagination);

				if (planiFormacionBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.solicitudService
						.findAllPlanificacionFormacionCount(
								planificacionFormacionBusqueda, perfiles);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(planiFormacionBusqueda);
				return data;
			} else {
				List<PlanificacionFormacionBusqueda> planiFormacionBusqueda = this.solicitudService
						.findAllPlanificacionFormacion(
								planificacionFormacionBusqueda, perfiles,
								pagination);

				if (planiFormacionBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return planificacionFormacionBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllLike'.
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param sinPlanificar_
	 *            String
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param fechaSolicitudDesde_
	 *            String
	 * @param fechaSolicitudHasta_
	 *            String
	 * @param entidadIdBusquedaSol_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * @param bloqueada_
	 *            String
	 * @param provinciaImparticion_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLike(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde_,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta_,
			@RequestParam(value = "entidadIdBusquedaSol", required = false) String entidadIdBusquedaSol_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_,
			@RequestParam(value = "bloqueada", required = false) String bloqueada_,
			@RequestParam(value = "canceladas", required = false) String canceladas_,
			@RequestParam(value = "provinciaImparticion", required = false) String provinciaImparticion_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String entidadIdBusquedaSol = ("".equals(entidadIdBusquedaSol_)) ? null
					: entidadIdBusquedaSol_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;
			// control checks
			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;
			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;
			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			String bloqueada = ("on".equals(bloqueada_)) ? Y40aConstantes.SI
					: null;

			String canceladas = ("on".equals(canceladas_)) ? Y40aConstantes.SI
					: null;

			String provinciaImparticion = ("".equals(provinciaImparticion_)) ? null
					: provinciaImparticion_;
			// // si no se ticka plaanificaados las fechas no se consideran
			// if (!"on".equals(planificados_)) {
			// fechaImparticionDesde_ = "";
			// fechaImparticionHasta_ = "";
			// }

			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);
			Date fechaSolicitudDesde = Y40aUtils.parseDate(
					fechaSolicitudDesde_, locale);
			Date fechaSolicitudHasta = Y40aUtils.parseDate(
					fechaSolicitudHasta_, locale);

			PlanificacionFormacionBusqueda filterPlanificacionFormacionBusqueda = new PlanificacionFormacionBusqueda();
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			filterPlanificacionFormacionBusqueda.setIdCat(idCat);
			if (entidadIdBusquedaSol != null) {
				filterPlanificacionFormacionBusqueda
						.setEntidadId(entidadIdBusquedaSol);
			} else {
				filterPlanificacionFormacionBusqueda.setEntidadId(entidadId);
			}
			filterPlanificacionFormacionBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionFormacionBusqueda.setPlanificados(planificados);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			filterPlanificacionFormacionBusqueda
					.setFechaSolicitudDesde(fechaSolicitudDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaSolicitudHasta(fechaSolicitudHasta);

			filterPlanificacionFormacionBusqueda
					.setRadioEtiquetas(radioEtiquetas);

			filterPlanificacionFormacionBusqueda.setBloqueada(bloqueada);
			filterPlanificacionFormacionBusqueda.setCancelado(canceladas);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionFormacionBusqueda.setEtiquetas(etiquetas);
			filterPlanificacionFormacionBusqueda
					.setProvinciaImparticion(provinciaImparticion);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda = this.solicitudService
						.findAllPlanificacionFormacion(
								filterPlanificacionFormacionBusqueda, perfiles,
								pagination);

				if (planificacionFormacionBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.solicitudService
						.findAllPlanificacionFormacionCount(
								filterPlanificacionFormacionBusqueda, perfiles);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(planificacionFormacionBusqueda);
				return data;
			} else {
				List<PlanificacionFormacionBusqueda> planificacionFormacionBusqueda = this.solicitudService
						.findAllPlanificacionFormacion(
								filterPlanificacionFormacionBusqueda, perfiles,
								pagination);
				if (planificacionFormacionBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return planificacionFormacionBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idSol
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idSol}", method = RequestMethod.GET)
	public @ResponseBody
	Solicitud getById(@PathVariable String idSol) {
		try {
			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			solicitud = this.solicitudService.find(solicitud);
			if (solicitud == null) {
				throw new Exception(idSol.toString());
			}
			return solicitud;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idSol.toString());
		}
	}

	/**
	 * Method 'getByIdSolicitud'.
	 * 
	 * @param idSol
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/getByIdSolicitud/{idSol}", method = RequestMethod.GET)
	public @ResponseBody
	SolicitudDetalle getByIdSolicitud(@PathVariable String idSol) {
		try {

			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle = this.solicitudService.findSolicitud(solicitud);

			if (solicitudDetalle == null) {
				throw new Exception(idSol.toString());
			}

			return solicitudDetalle;

		} catch (Exception e) {
			throw new ResourceNotFoundException(idSol.toString());
		}
	}

	/**
	 * Method 'removeSolicitud'.
	 * 
	 * @param idSol
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarSolicitud/{idSol}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idSol, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			this.solicitudService.removeSolicitud(solicitud);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to delete " + idSol);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param idCat_
	 *            String
	 * @param entidadId_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param sinPlanificar_
	 *            String
	 * @param planificados_
	 *            String
	 * @param fechaImparticionDesde_
	 *            String
	 * @param fechaImparticionHasta_
	 *            String
	 * @param fechaSolicitudDesde_
	 *            String
	 * @param fechaSolicitudHasta_
	 *            String
	 * @param radioEtiquetas_
	 *            String
	 * @param sortorder_
	 *            String
	 * @param sortname_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getResultadoConsultaDinamicaBusqueda(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "entidadId", required = false) String entidadId_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "sinPlanificar", required = false) String sinPlanificar_,
			@RequestParam(value = "planificados", required = false) String planificados_,
			@RequestParam(value = "fechaImparticionDesde", required = false) String fechaImparticionDesde_,
			@RequestParam(value = "fechaImparticionHasta", required = false) String fechaImparticionHasta_,
			@RequestParam(value = "fechaSolicitudDesde", required = false) String fechaSolicitudDesde_,
			@RequestParam(value = "fechaSolicitudHasta", required = false) String fechaSolicitudHasta_,
			@RequestParam(value = "radioEtiquetas", required = false) String radioEtiquetas_,
			@RequestParam(value = "bloqueada", required = false) String bloqueada_,
			@RequestParam(value = "canceladas", required = false) String canceladas_,
			@RequestParam(value = "sortorder", required = false) String sortorder_,
			@RequestParam(value = "sortname", required = false) String sortname_,
			@RequestParam(value = "provinciaImparticion", required = false) String provinciaImparticion_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			Pagination pagination = new Pagination();
			pagination.setSort(sortname_);
			pagination.setAscDsc(sortorder_);

			PlanificacionFormacionBusqueda filterPlanificacionFormacionBusqueda = new PlanificacionFormacionBusqueda();

			// control de los campos susceptibles de llegar a "" desde el filtro
			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String entidadId = ("".equals(entidadId_)) ? null : entidadId_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;

			String radioEtiquetas = ("".equals(radioEtiquetas_)) ? null
					: radioEtiquetas_;

			if (radioEtiquetas == null) {
				radioEtiquetas = "T";
			}

			String provinciaImparticion = ("".equals(provinciaImparticion_)) ? null
					: provinciaImparticion_;

			// control checks
			String sinPlanificar = ("on".equals(sinPlanificar_)) ? Y40aConstantes.SI
					: null;
			String planificados = ("on".equals(planificados_)) ? Y40aConstantes.SI
					: null;
			String bloqueada = ("on".equals(bloqueada_)) ? Y40aConstantes.SI
					: null;

			String canceladas = ("on".equals(canceladas_)) ? Y40aConstantes.SI
					: null;

			filterPlanificacionFormacionBusqueda.setBloqueada(bloqueada);
			filterPlanificacionFormacionBusqueda.setCancelado(canceladas);

			Locale locale = LocaleContextHolder.getLocale();
			Date fechaImparticionDesde = Y40aUtils.parseDate(
					fechaImparticionDesde_, locale);
			Date fechaImparticionHasta = Y40aUtils.parseDate(
					fechaImparticionHasta_, locale);

			Date fechaSolicitudDesde = Y40aUtils.parseDate(
					fechaSolicitudDesde_, locale);
			Date fechaSolicitudHasta = Y40aUtils.parseDate(
					fechaSolicitudHasta_, locale);

			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			filterPlanificacionFormacionBusqueda.setIdCat(idCat);
			filterPlanificacionFormacionBusqueda.setEntidadId(entidadId);
			filterPlanificacionFormacionBusqueda
					.setSinPlanificar(sinPlanificar);
			filterPlanificacionFormacionBusqueda.setPlanificados(planificados);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionDesde(fechaImparticionDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaImparticionHasta(fechaImparticionHasta);

			filterPlanificacionFormacionBusqueda
					.setFechaSolicitudDesde(fechaSolicitudDesde);
			filterPlanificacionFormacionBusqueda
					.setFechaSolicitudHasta(fechaSolicitudHasta);

			filterPlanificacionFormacionBusqueda
					.setProvinciaImparticion(provinciaImparticion);

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterPlanificacionFormacionBusqueda.setEtiquetas(etiquetas);
			filterPlanificacionFormacionBusqueda
					.setRadioEtiquetas(radioEtiquetas);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y40aConstantes.NB_EXCEL_PLANIFICACION_FORMACIONGRUPO
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre + "\"");

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			String xslString = this.y40aExcelGeneratorService
					.getPlanificacionFormacionExcel(
							filterPlanificacionFormacionBusqueda, perfiles,
							pagination);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param idSol
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/copiarsolicitud/{idSol}", method = RequestMethod.POST)
	public @ResponseBody
	Solicitud copiarSolicitud(@PathVariable String idSol,
			HttpServletRequest request) {
		try {

			Solicitud solicitud = new Solicitud();
			solicitud.setIdSol(idSol);
			solicitud = this.solicitudService.copiarSolicitud(solicitud);
			if (solicitud == null) {
				throw new Exception(idSol.toString());
			}
			return solicitud;

		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y40aUDAException("error.generico", true, e);
		}
	}

}