package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.service.PerfilService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.Perfil;

/**
 *  * PerfilController  
 *  
 */
 
@Controller
@RequestMapping (value = "/perfil")

public class PerfilController  {

	private static final Logger logger = LoggerFactory.getLogger(PerfilController.class);

	@Autowired
	private PerfilService perfilService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("perfil", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  idPerfil String
	 * @return String
	 */
	@RequestMapping(value = "/{idPerfil}", method = RequestMethod.GET)
	public @ResponseBody Perfil getById(@PathVariable String idPerfil) {
		try{
            Perfil perfil = new Perfil();
			perfil.setIdPerfil(idPerfil);
            perfil = this.perfilService.find(perfil);
            if (perfil == null) {
                throw new Exception(idPerfil.toString());
            }
            return perfil;
		}catch (Exception e){
		    throw new ResourceNotFoundException(idPerfil.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  idPerfil String
	 *@param	  nombreEs String
	 *@param	  nombreEu String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "idPerfil", required = false) String idPerfil,
	@RequestParam(value = "nombreEs", required = false) String nombreEs,
	@RequestParam(value = "nombreEu", required = false) String nombreEu,
			HttpServletRequest request) {
			try{
				Perfil filterPerfil = new Perfil(idPerfil, nombreEs, nombreEu);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Perfil> perfils =  this.perfilService.findAll(filterPerfil, pagination);

     			    if (perfils == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterPerfil, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(perfils);
				    return data;
				}else{
				    List<Perfil> perfils =  this.perfilService.findAll(filterPerfil, pagination);
					if (perfils == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return perfils;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterPerfil Perfil 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "perfil", required = false) Perfil  filterPerfil, HttpServletRequest request) {
	    try {
			return perfilService
					.findAllCount(filterPerfil != null ? filterPerfil
							: new Perfil ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param perfil Perfil 
	 * @param response HttpServletResponse
	 * @return Perfil
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Perfil edit(@RequestBody Perfil perfil, HttpServletResponse response) {		
		try {
            Perfil perfilAux  = this.perfilService.update(perfil);
			logger.info("Entity correctly inserted!");
            return perfilAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param perfil Perfil 
	 * @return Perfil
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Perfil add(@RequestBody Perfil perfil) {		
        try {
            Perfil perfilAux = this.perfilService.add(perfil);
            logger.info("Entity correctly inserted!");
        	return perfilAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  idPerfil  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{idPerfil}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String idPerfil,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Perfil perfil = new Perfil();
            perfil.setIdPerfil(idPerfil);
            this.perfilService.remove(perfil);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  idPerfil);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  perfilIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> perfilIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Perfil> perfilList = new ArrayList<Perfil>();
        try{		    
            for (ArrayList<String> perfilId:perfilIds) {
			    Iterator<String> iterator = perfilId.iterator();
				    Perfil perfil = new Perfil();
			        perfil.setIdPerfil(ObjectConversionManager.convert(iterator.next(), String.class));
				    perfilList.add(perfil);
		    }
            this.perfilService.removeMultiple(perfilList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPerfilService'.
	 *
	 * @return PerfilService
	 */
	protected PerfilService getPerfilService() {
		return this.perfilService;
	}

	/**
	 * Method 'setPerfilService'.
	 *
	 * @param perfilService  PerfilService
	 * @return
	 */
	public void setPerfilService(PerfilService perfilService) {
		this.perfilService = perfilService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
	/**
	 * Method 'unBind' CategoriaPerfil
	 *
	 * @param idPerfil String
	 * @param categoriaIdCat String 
	 * @return	 
	 */
	@RequestMapping(value = "/unbindCategoriaPerfil", method = RequestMethod.POST)
	public void unBindCategoriaPerfil(
	  @RequestParam(value = "idPerfil", required = false) String idPerfil,
				@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat
	  ) {
		Perfil perfil= new Perfil();
		Categoria     categoria = new Categoria();
		if (idPerfil!= null ){
				perfil.setIdPerfil(idPerfil);
		}
		if (categoriaIdCat!= null ){
		    categoria.setIdCat(categoriaIdCat);
		}
		perfil.getCategorias().add(categoria);
	    this.perfilService.removeCategoriaPerfil(perfil);    
	}
	
	/**
	 * Method 'bind' CategoriaPerfil
	 *
	 * @param idPerfil String
	 * @param categoriaIdCat String 
	 */
	@RequestMapping(value = "/bindCategoriaPerfil", method = RequestMethod.POST)
	public void bindCategoriaPerfil(
	  @RequestParam(value = "idPerfil", required = false) String idPerfil,
				@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat
	  ) {
		Perfil perfil= new Perfil();
		Categoria     categoria = new Categoria();
		if (idPerfil!= null ){
				perfil.setIdPerfil(idPerfil);
		}
		if (categoriaIdCat!= null ){
		    categoria.setIdCat(categoriaIdCat);
		}
		perfil.getCategorias().add(categoria);
	    this.perfilService.addCategoriaPerfil(perfil);    
	}
}	
	
