package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.ObservacionesEntidadService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.ObservacionesEntidad;

/**
 * * ObservacionesEntidadController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/observacionesentidad")
public class ObservacionesEntidadController {

	private static final Logger logger = LoggerFactory
			.getLogger(ObservacionesEntidadController.class);

	@Autowired
	private ObservacionesEntidadService observacionesEntidadService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("observacionesentidad", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody
	ObservacionesEntidad getById(@PathVariable String entidadId) {
		try {
			ObservacionesEntidad observacionesEntidad = new ObservacionesEntidad();
			observacionesEntidad.setEntidadId(entidadId);
			observacionesEntidad = this.observacionesEntidadService
					.find(observacionesEntidad);
			if (observacionesEntidad == null) {
				throw new Exception(entidadId.toString());
			}
			return observacionesEntidad;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param entidadId
	 *            String
	 * @param observaciones
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "observaciones", required = false) String observaciones,
			HttpServletRequest request) {
		try {
			ObservacionesEntidad filterObservacionesEntidad = new ObservacionesEntidad(
					entidadId, observaciones);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ObservacionesEntidad> observacionesEntidads = this.observacionesEntidadService
						.findAll(filterObservacionesEntidad, pagination);

				if (observacionesEntidads == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterObservacionesEntidad, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(observacionesEntidads);
				return data;
			} else {
				List<ObservacionesEntidad> observacionesEntidads = this.observacionesEntidadService
						.findAll(filterObservacionesEntidad, pagination);
				if (observacionesEntidads == null) {
					throw new Exception("No data Found.");
				}
				return observacionesEntidads;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterObservacionesEntidad
	 *            ObservacionesEntidad
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "observacionesEntidad", required = false) ObservacionesEntidad filterObservacionesEntidad,
			HttpServletRequest request) {
		try {
			return observacionesEntidadService
					.findAllCount(filterObservacionesEntidad != null ? filterObservacionesEntidad
							: new ObservacionesEntidad());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param observacionesEntidad
	 *            ObservacionesEntidad
	 * @param response
	 *            HttpServletResponse
	 * @return ObservacionesEntidad
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ObservacionesEntidad edit(
			@RequestBody ObservacionesEntidad observacionesEntidad,
			HttpServletResponse response) {
		try {
			ObservacionesEntidad observacionesEntidadAux = this.observacionesEntidadService
					.update(observacionesEntidad);
			logger.info("Entity correctly inserted!");
			return observacionesEntidadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param observacionesEntidad
	 *            ObservacionesEntidad
	 * @return ObservacionesEntidad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ObservacionesEntidad add(
			@RequestBody ObservacionesEntidad observacionesEntidad) {
		try {
			ObservacionesEntidad observacionesEntidadAux = this.observacionesEntidadService
					.add(observacionesEntidad);
			logger.info("Entity correctly inserted!");
			return observacionesEntidadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param entidadId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String entidadId,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ObservacionesEntidad observacionesEntidad = new ObservacionesEntidad();
			observacionesEntidad.setEntidadId(entidadId);
			this.observacionesEntidadService.remove(observacionesEntidad);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + entidadId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param observacionesEntidadIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> observacionesEntidadIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ObservacionesEntidad> observacionesEntidadList = new ArrayList<ObservacionesEntidad>();
		try {
			for (ArrayList<String> observacionesEntidadId : observacionesEntidadIds) {
				Iterator<String> iterator = observacionesEntidadId.iterator();
				ObservacionesEntidad observacionesEntidad = new ObservacionesEntidad();
				observacionesEntidad.setEntidadId(ObjectConversionManager
						.convert(iterator.next(), String.class));
				observacionesEntidadList.add(observacionesEntidad);
			}
			this.observacionesEntidadService
					.removeMultiple(observacionesEntidadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getObservacionesEntidadService'.
	 * 
	 * @return ObservacionesEntidadService
	 */
	protected ObservacionesEntidadService getObservacionesEntidadService() {
		return this.observacionesEntidadService;
	}

	/**
	 * Method 'setObservacionesEntidadService'.
	 * 
	 * @param observacionesEntidadService
	 *            ObservacionesEntidadService
	 * @return
	 */
	public void setObservacionesEntidadService(
			ObservacionesEntidadService observacionesEntidadService) {
		this.observacionesEntidadService = observacionesEntidadService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
