package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.ObservacionesService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.Observaciones;

/**
 *  * ObservacionesController  
 *  
 */
 
@Controller
@RequestMapping (value = "/observaciones")

public class ObservacionesController  {

	private static final Logger logger = LoggerFactory.getLogger(ObservacionesController.class);

	@Autowired
	private ObservacionesService observacionesService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("observaciones", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  entidadId String
	 * @return String
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody Observaciones getById(@PathVariable String entidadId) {
		try{
            Observaciones observaciones = new Observaciones();
			observaciones.setEntidadId(entidadId);
            observaciones = this.observacionesService.find(observaciones);
            if (observaciones == null) {
                throw new Exception(entidadId.toString());
            }
            return observaciones;
		}catch (Exception e){
		    throw new ResourceNotFoundException(entidadId.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  entidadId String
	 *@param	  observaciones String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "entidadId", required = false) String entidadId,
	@RequestParam(value = "observaciones", required = false) String observaciones,
			HttpServletRequest request) {
			try{
				Observaciones filterObservaciones = new Observaciones(entidadId, observaciones);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Observaciones> observacioness =  this.observacionesService.findAll(filterObservaciones, pagination);

     			    if (observacioness == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterObservaciones, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(observacioness);
				    return data;
				}else{
				    List<Observaciones> observacioness =  this.observacionesService.findAll(filterObservaciones, pagination);
					if (observacioness == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return observacioness;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterObservaciones Observaciones 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "observaciones", required = false) Observaciones  filterObservaciones, HttpServletRequest request) {
	    try {
			return observacionesService
					.findAllCount(filterObservaciones != null ? filterObservaciones
							: new Observaciones ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param observaciones Observaciones 
	 * @param response HttpServletResponse
	 * @return Observaciones
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Observaciones edit(@RequestBody Observaciones observaciones, HttpServletResponse response) {		
		try {
            Observaciones observacionesAux  = this.observacionesService.update(observaciones);
			logger.info("Entity correctly inserted!");
            return observacionesAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param observaciones Observaciones 
	 * @return Observaciones
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Observaciones add(@RequestBody Observaciones observaciones) {		
        try {
            Observaciones observacionesAux = this.observacionesService.add(observaciones);
            logger.info("Entity correctly inserted!");
        	return observacionesAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  entidadId  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String entidadId,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Observaciones observaciones = new Observaciones();
            observaciones.setEntidadId(entidadId);
            this.observacionesService.remove(observaciones);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  entidadId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  observacionesIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> observacionesIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Observaciones> observacionesList = new ArrayList<Observaciones>();
        try{		    
            for (ArrayList<String> observacionesId:observacionesIds) {
			    Iterator<String> iterator = observacionesId.iterator();
				    Observaciones observaciones = new Observaciones();
			        observaciones.setEntidadId(ObjectConversionManager.convert(iterator.next(), String.class));
				    observacionesList.add(observaciones);
		    }
            this.observacionesService.removeMultiple(observacionesList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getObservacionesService'.
	 *
	 * @return ObservacionesService
	 */
	protected ObservacionesService getObservacionesService() {
		return this.observacionesService;
	}

	/**
	 * Method 'setObservacionesService'.
	 *
	 * @param observacionesService  ObservacionesService
	 * @return
	 */
	public void setObservacionesService(ObservacionesService observacionesService) {
		this.observacionesService = observacionesService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
