/**
 * 
 */
package com.ejie.y40a.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.y40a.model.T17Calle;
import com.ejie.y40a.model.T17Localidad;
import com.ejie.y40a.model.T17Municipio;
import com.ejie.y40a.model.T17Pais;
import com.ejie.y40a.model.T17Portal;
import com.ejie.y40a.model.T17Provincia;
import com.ejie.y40a.service.T17CalleService;
import com.ejie.y40a.service.T17LocalidadService;
import com.ejie.y40a.service.T17MunicipioService;
import com.ejie.y40a.service.T17PaisService;
import com.ejie.y40a.service.T17PortalService;
import com.ejie.y40a.service.T17ProvinciaService;

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/nora")
public class NoraController {

	private static final Logger logger = LoggerFactory
			.getLogger(NoraController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private T17PaisService paisService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17LocalidadService localidadService;

	@Autowired()
	private T17CalleService calleService;

	@Autowired()
	private T17PortalService portalService;

	/********************************************************************************
	 * 
	 * COMBO
	 * 
	 *******************************************************************************/

	/********************************************************************************
	 * Provincias
	 *******************************************************************************/
	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provincias", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Provincia> getProvincias() {
		logger.debug("Cargar provincias");
		return this.provinciaService.findAll(null, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getMunicipios'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/municipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getMunicipios(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId) {

		String provinciaId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}

		T17Municipio t17Municipio = new T17Municipio();
		t17Municipio.setProvinciaId(provinciaId);

		return this.municipioService.findAll(t17Municipio, null);
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getLocalidades'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/localidades", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getLocalidades(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId,
		// @RequestParam(value = "municipioId", required = false) String
		// municipalityId) {

		String provinciaId = "";
		String municipioId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("municipioId"))
				&& null != (String) request.getParameter("municipioId")) {
			municipioId = request.getParameter("municipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraMunicipioId"))
				&& null != (String) request.getParameter("dtnoraMunicipioId")) {
			municipioId = request.getParameter("dtnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraMunicipioId"))
				&& null != (String) request.getParameter("esnoraMunicipioId")) {
			municipioId = request.getParameter("esnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraMunicipioId"))
				&& null != (String) request.getParameter("acnoraMunicipioId")) {
			municipioId = request.getParameter("acnoraMunicipioId");
		}

		T17Localidad t17Localidad = new T17Localidad();
		t17Localidad.setProvinciaId(provinciaId);
		t17Localidad.setMunicipioId(municipioId);

		return this.localidadService.findAll(t17Localidad, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateMunicipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getUpdateMunicipios(
			@RequestParam(value = "provinciaId", required = false) String provinciaId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null")) {

			T17Municipio t17Municipio = new T17Municipio();
			t17Municipio.setProvinciaId(provinciaId);

			return this.municipioService.findAll(t17Municipio, null);
		} else {
			return (List<T17Municipio>) new ArrayList<T17Municipio>();
		}
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipioId
	 *            identificador de la municipio
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateLocalidad", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getUpdateLocalidades(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null") && municipioId != null
				&& !municipioId.equals("") && !municipioId.equals("null")) {

			T17Localidad t17Localidad = new T17Localidad();
			t17Localidad.setProvinciaId(provinciaId);
			t17Localidad.setMunicipioId(municipioId);

			return this.localidadService.findAll(t17Localidad, null);
		} else {
			return (List<T17Localidad>) new ArrayList<T17Localidad>();
		}
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getCodigoPostal'.
	 * 
	 * @param portal
	 *            identificador del portal
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/codigo_postal/{portal}", method = RequestMethod.GET)
	public @ResponseBody()
	T17Portal getCodigoPostal(@PathVariable() String portal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setId(new Long(portal));
		return this.portalService.findCodigoPostal(t17Portal);

	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getCalles'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador de la provincia
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/calles", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalles(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setProvinciaId(provinciaId);
		t17Calle.setMunicipioId(municipalityId);

		return this.calleService.findAll(t17Calle, null);

	}

	/********************************************************************************
	 * Portal
	 *******************************************************************************/
	/**
	 * Method 'getPortales'.
	 * 
	 * @param localidadId
	 *            identificador de la localidad
	 * @param calleId
	 *            identificador de la calle
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/portales", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getPortales(
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "calleId", required = false) Long calleId) {

		if (localidadId != null && !localidadId.equals("")
				&& !localidadId.equals("null") && calleId != null
				&& calleId != 0) {
			T17Portal t17Portal = new T17Portal();
			t17Portal.setLocalidadId(localidadId);
			t17Portal.setCalleId(calleId);

			return this.portalService.findAll(t17Portal, null);
		} else {
			return (List<T17Portal>) new ArrayList<T17Portal>();
		}
	}

	/********************************************************************************
	 * Paises
	 *******************************************************************************/
	/**
	 * Method 'getPaises'.
	 * 
	 * @return 'lista de paises' para el COMBO
	 */
	@RequestMapping(value = "paises", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Pais> getPaises() {
		logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		// pais.setId("351");
		return this.paisService.findAll(pais, null);

	}

	/********************************************************************************
	 * CP
	 *******************************************************************************/
	/**
	 * Method 'getCP'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @return Lista
	 */
	@RequestMapping(value = "/cp", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getCP(@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		// HashMap<String, String> aMap = null;
		// List<HashMap<String, String>> lst = new ArrayList<HashMap<String,
		// String>>();

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48940");
		// aMap.put("value", "48940");
		// lst.add(aMap);

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48003");
		// aMap.put("value", "48003");
		// lst.add(aMap);

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(q);
		return this.portalService.findAllLike_CodigoPostal(t17Portal, null, c);

	}

	/********************************************************************************
	 * Calle
	 *******************************************************************************/
	/**
	 * Method 'getCalle'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @param provincia
	 *            String
	 * @param municipio
	 *            String
	 * 
	 * @return list
	 */
	@RequestMapping(value = "/calle", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalle(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "provincia", required = true) String provincia,
			@RequestParam(value = "municipio", required = true) String municipio) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setDsO(q);
		t17Calle.setMunicipioId(municipio);
		t17Calle.setProvinciaId(provincia);

		return this.calleService.findAllLike_Calle(t17Calle, null, c);

	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
