package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.MotivosCancelacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.MotivosCancelacion;

/**
 *  * MotivosCancelacionController  
 *  
 */
 
@Controller
@RequestMapping (value = "/motivoscancelacion")

public class MotivosCancelacionController  {

	private static final Logger logger = LoggerFactory.getLogger(MotivosCancelacionController.class);

	@Autowired
	private MotivosCancelacionService motivosCancelacionService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("motivoscancelacion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  idMotivo Long
	 * @return String
	 */
	@RequestMapping(value = "/{idMotivo}", method = RequestMethod.GET)
	public @ResponseBody MotivosCancelacion getById(@PathVariable Long idMotivo) {
		try{
            MotivosCancelacion motivosCancelacion = new MotivosCancelacion();
			motivosCancelacion.setIdMotivo(idMotivo);
            motivosCancelacion = this.motivosCancelacionService.find(motivosCancelacion);
            if (motivosCancelacion == null) {
                throw new Exception(idMotivo.toString());
            }
            return motivosCancelacion;
		}catch (Exception e){
		    throw new ResourceNotFoundException(idMotivo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  idMotivo Long
	 *@param	  descMotivoEs String
	 *@param	  descMotivoEu String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "idMotivo", required = false) Long idMotivo,
	@RequestParam(value = "descMotivoEs", required = false) String descMotivoEs,
	@RequestParam(value = "descMotivoEu", required = false) String descMotivoEu,
			HttpServletRequest request) {
			try{
				MotivosCancelacion filterMotivosCancelacion = new MotivosCancelacion(idMotivo, descMotivoEs, descMotivoEu);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<MotivosCancelacion> motivosCancelacions =  this.motivosCancelacionService.findAll(filterMotivosCancelacion, pagination);

     			    if (motivosCancelacions == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterMotivosCancelacion, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(motivosCancelacions);
				    return data;
				}else{
				    List<MotivosCancelacion> motivosCancelacions =  this.motivosCancelacionService.findAll(filterMotivosCancelacion, pagination);
					if (motivosCancelacions == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return motivosCancelacions;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterMotivosCancelacion MotivosCancelacion 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "motivosCancelacion", required = false) MotivosCancelacion  filterMotivosCancelacion, HttpServletRequest request) {
	    try {
			return motivosCancelacionService
					.findAllCount(filterMotivosCancelacion != null ? filterMotivosCancelacion
							: new MotivosCancelacion ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param motivosCancelacion MotivosCancelacion 
	 * @param response HttpServletResponse
	 * @return MotivosCancelacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody MotivosCancelacion edit(@RequestBody MotivosCancelacion motivosCancelacion, HttpServletResponse response) {		
		try {
            MotivosCancelacion motivosCancelacionAux  = this.motivosCancelacionService.update(motivosCancelacion);
			logger.info("Entity correctly inserted!");
            return motivosCancelacionAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param motivosCancelacion MotivosCancelacion 
	 * @return MotivosCancelacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody MotivosCancelacion add(@RequestBody MotivosCancelacion motivosCancelacion) {		
        try {
            MotivosCancelacion motivosCancelacionAux = this.motivosCancelacionService.add(motivosCancelacion);
            logger.info("Entity correctly inserted!");
        	return motivosCancelacionAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  idMotivo  Long
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{idMotivo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable Long idMotivo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            MotivosCancelacion motivosCancelacion = new MotivosCancelacion();
            motivosCancelacion.setIdMotivo(idMotivo);
            this.motivosCancelacionService.remove(motivosCancelacion);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  idMotivo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  motivosCancelacionIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> motivosCancelacionIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<MotivosCancelacion> motivosCancelacionList = new ArrayList<MotivosCancelacion>();
        try{		    
            for (ArrayList<String> motivosCancelacionId:motivosCancelacionIds) {
			    Iterator<String> iterator = motivosCancelacionId.iterator();
				    MotivosCancelacion motivosCancelacion = new MotivosCancelacion();
			        motivosCancelacion.setIdMotivo(ObjectConversionManager.convert(iterator.next(), Long.class));
				    motivosCancelacionList.add(motivosCancelacion);
		    }
            this.motivosCancelacionService.removeMultiple(motivosCancelacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getMotivosCancelacionService'.
	 *
	 * @return MotivosCancelacionService
	 */
	protected MotivosCancelacionService getMotivosCancelacionService() {
		return this.motivosCancelacionService;
	}

	/**
	 * Method 'setMotivosCancelacionService'.
	 *
	 * @param motivosCancelacionService  MotivosCancelacionService
	 * @return
	 */
	public void setMotivosCancelacionService(MotivosCancelacionService motivosCancelacionService) {
		this.motivosCancelacionService = motivosCancelacionService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
