package com.ejie.y40a.control;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

/**
 * * CategoriaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/inicio")
public class InicioController {

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("inicio", "model", model);
	}

	/**
	 * Method 'getCreateForm_avisolegal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "aviso_legal", method = RequestMethod.GET)
	public ModelAndView getCreateFormAvisolegal(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("aviso_legal", "model", model);
	}

	/**
	 * Method 'getCreateForm_privacidad'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "privacidad", method = RequestMethod.GET)
	public ModelAndView getCreateFormPrivacidad(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("privacidad_modal", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "userMaint", method = RequestMethod.GET)
	public ModelAndView getCreateFormUser(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("userMaint", "model", model);
	}
}
