package com.ejie.y40a.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.model.Historico;
import com.ejie.y40a.service.HistoricoService;

/**
 * * HistoricoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/historico")
public class HistoricoController {

	private static final Logger logger = LoggerFactory
			.getLogger(HistoricoController.class);

	@Autowired
	private HistoricoService historicoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("historico", "model", model);
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "capaHistorico", method = RequestMethod.GET)
	public ModelAndView getCreateForm2(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));

		return new ModelAndView("capaHistorico", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idHist
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idHist}", method = RequestMethod.GET)
	public @ResponseBody
	Historico getById(@PathVariable String idHist) {
		try {
			Historico historico = new Historico();
			historico.setIdHist(idHist);
			historico = this.historicoService.find(historico);
			if (historico == null) {
				throw new Exception(idHist.toString());
			}
			return historico;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idHist.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idHist
	 *            String
	 * @param nombre
	 *            String
	 * @param tipo
	 *            String
	 * @param tamanio
	 *            Long
	 * @param fecha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idHist", required = false) String idHist,
			@RequestParam(value = "nombre", required = false) String nombre,
			@RequestParam(value = "tipo", required = false) String tipo,
			@RequestParam(value = "tamanio", required = false) Long tamanio,
			@RequestParam(value = "fecha", required = false) Date fecha,
			HttpServletRequest request) {
		try {
			Historico filterHistorico = new Historico(idHist, null, nombre,
					tipo, tamanio, fecha);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Historico> historicos = this.historicoService.findAll(
						filterHistorico, pagination);

				if (historicos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterHistorico, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(historicos);
				return data;
			} else {
				List<Historico> historicos = this.historicoService.findAll(
						filterHistorico, pagination);
				if (historicos == null) {
					throw new Exception("No data Found.");
				}
				return historicos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterHistorico
	 *            Historico
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "historico", required = false) Historico filterHistorico,
			HttpServletRequest request) {
		try {
			return historicoService
					.findAllCount(filterHistorico != null ? filterHistorico
							: new Historico());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param historico
	 *            Historico
	 * @param response
	 *            HttpServletResponse
	 * @return Historico
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Historico edit(@RequestBody Historico historico,
			HttpServletResponse response) {
		try {
			Historico historicoAux = this.historicoService.update(historico);
			logger.info("Entity correctly inserted!");
			return historicoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Historico add(@RequestBody Historico historico) {
		try {
			Historico historicoAux = this.historicoService.add(historico);
			logger.info("Entity correctly inserted!");
			return historicoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idHist
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idHist}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idHist, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Historico historico = new Historico();
			historico.setIdHist(idHist);
			this.historicoService.remove(historico);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idHist);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param historicoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> historicoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Historico> historicoList = new ArrayList<Historico>();
		try {
			for (ArrayList<String> historicoId : historicoIds) {
				Iterator<String> iterator = historicoId.iterator();
				Historico historico = new Historico();
				historico.setIdHist(ObjectConversionManager.convert(
						iterator.next(), String.class));
				historicoList.add(historico);
			}
			this.historicoService.removeMultiple(historicoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addDocumentoConsultaDetalle'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return List<Map<String, Object>>
	 */
	@RequestMapping(value = "subidaHistorico", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoConsultaDetalle(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Historico historico = new Historico();
			Blob blob = new SerialBlob(file.getBytes());

			historico.setArchivo(blob);
			historico.setNombre(file.getOriginalFilename());
			historico.setTamanio(file.getSize());
			historico.setTipo(file.getContentType());
			historico.setFecha(new Date());

			Historico historicoAux = this.historicoService.add(historico);

			logger.info("Historico correctly inserted!" + historicoAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoConsultaDetalle");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y40aVistaWar/historico/subidaHistorico/"
				+ file.getOriginalFilename() + "?R01HNoPortal=true");
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"/y40aVistaWar/historico/subidaHistorico/"
						+ file.getOriginalFilename() + "?R01HNoPortal=true");
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumentoConsultaDetalle'.
	 * 
	 * @param idhist
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/descargafichero/{idhist}", method = RequestMethod.GET)
	public @ResponseBody
	// ConsultaFile getByIdDocumentoConsultaDetalle(@PathVariable String idhist,
	// HttpServletResponse response) {
	void getByIdDocumentoConsultaDetalle(@PathVariable String idhist,
			HttpServletResponse response) {

		try {

			Historico historico = new Historico();
			historico.setIdHist(idhist);

			historico = this.historicoService.find(historico);

			if (historico == null) {
				throw new Exception(idhist.toString());
			}

			Blob contenido = historico.getArchivo();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ historico.getNombre() + "");
			response.setContentType(historico.getTipo());

			response.setContentLength((int) (historico.getTamanio()).intValue());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idhist.toString());
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getHistoricoService'.
	 * 
	 * @return HistoricoService
	 */
	protected HistoricoService getHistoricoService() {
		return this.historicoService;
	}

	/**
	 * Method 'setHistoricoService'.
	 * 
	 * @param historicoService
	 *            HistoricoService
	 * @return
	 */
	public void setHistoricoService(HistoricoService historicoService) {
		this.historicoService = historicoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
