package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.service.GrupoEntidadService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.GrupoEntidad;

/**
 *  * GrupoEntidadController  
 *  
 */
 
@Controller
@RequestMapping (value = "/grupoentidad")

public class GrupoEntidadController  {

	private static final Logger logger = LoggerFactory.getLogger(GrupoEntidadController.class);

	@Autowired
	private GrupoEntidadService grupoEntidadService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("grupoentidad", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  grupoId String
	 * @param  entidadId String
	 * @return String
	 */
	@RequestMapping(value = "/{grupoId}/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody GrupoEntidad getById(@PathVariable String grupoId, @PathVariable String entidadId) {
		try{
            GrupoEntidad grupoEntidad = new GrupoEntidad();
			grupoEntidad.setGrupoId(grupoId);
			grupoEntidad.setEntidadId(entidadId);
            grupoEntidad = this.grupoEntidadService.find(grupoEntidad);
            if (grupoEntidad == null) {
                throw new Exception(grupoId.toString() + entidadId.toString());
            }
            return grupoEntidad;
		}catch (Exception e){
		    throw new ResourceNotFoundException(grupoId.toString() + entidadId.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  grupoId String
	 *@param	  entidadId String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "grupoId", required = false) String grupoId,
	@RequestParam(value = "entidadId", required = false) String entidadId,
			HttpServletRequest request) {
			try{
				GrupoEntidad filterGrupoEntidad = new GrupoEntidad(grupoId, entidadId);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<GrupoEntidad> grupoEntidads =  this.grupoEntidadService.findAll(filterGrupoEntidad, pagination);

     			    if (grupoEntidads == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterGrupoEntidad, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(grupoEntidads);
				    return data;
				}else{
				    List<GrupoEntidad> grupoEntidads =  this.grupoEntidadService.findAll(filterGrupoEntidad, pagination);
					if (grupoEntidads == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return grupoEntidads;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterGrupoEntidad GrupoEntidad 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "grupoEntidad", required = false) GrupoEntidad  filterGrupoEntidad, HttpServletRequest request) {
	    try {
			return grupoEntidadService
					.findAllCount(filterGrupoEntidad != null ? filterGrupoEntidad
							: new GrupoEntidad ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param grupoEntidad GrupoEntidad 
	 * @param response HttpServletResponse
	 * @return GrupoEntidad
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody GrupoEntidad edit(@RequestBody GrupoEntidad grupoEntidad, HttpServletResponse response) {		
		try {
            GrupoEntidad grupoEntidadAux  = this.grupoEntidadService.update(grupoEntidad);
			logger.info("Entity correctly inserted!");
            return grupoEntidadAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param grupoEntidad GrupoEntidad 
	 * @return GrupoEntidad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody GrupoEntidad add(@RequestBody GrupoEntidad grupoEntidad) {		
        try {
            GrupoEntidad grupoEntidadAux = this.grupoEntidadService.add(grupoEntidad);
            logger.info("Entity correctly inserted!");
        	return grupoEntidadAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  grupoId  String
	 * @param  entidadId  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{grupoId}/{entidadId}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String grupoId,
				@PathVariable String entidadId,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            GrupoEntidad grupoEntidad = new GrupoEntidad();
            grupoEntidad.setGrupoId(grupoId);
            grupoEntidad.setEntidadId(entidadId);
            this.grupoEntidadService.remove(grupoEntidad);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  grupoId +  entidadId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  grupoEntidadIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> grupoEntidadIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<GrupoEntidad> grupoEntidadList = new ArrayList<GrupoEntidad>();
        try{		    
            for (ArrayList<String> grupoEntidadId:grupoEntidadIds) {
			    Iterator<String> iterator = grupoEntidadId.iterator();
				    GrupoEntidad grupoEntidad = new GrupoEntidad();
			        grupoEntidad.setGrupoId(ObjectConversionManager.convert(iterator.next(), String.class));
			        grupoEntidad.setEntidadId(ObjectConversionManager.convert(iterator.next(), String.class));
				    grupoEntidadList.add(grupoEntidad);
		    }
            this.grupoEntidadService.removeMultiple(grupoEntidadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getGrupoEntidadService'.
	 *
	 * @return GrupoEntidadService
	 */
	protected GrupoEntidadService getGrupoEntidadService() {
		return this.grupoEntidadService;
	}

	/**
	 * Method 'setGrupoEntidadService'.
	 *
	 * @param grupoEntidadService  GrupoEntidadService
	 * @return
	 */
	public void setGrupoEntidadService(GrupoEntidadService grupoEntidadService) {
		this.grupoEntidadService = grupoEntidadService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
