package com.ejie.y40a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.service.GrupoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y40a.model.Grupo;

/**
 *  * GrupoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/grupo")

public class GrupoController  {

	private static final Logger logger = LoggerFactory.getLogger(GrupoController.class);

	@Autowired
	private GrupoService grupoService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("grupo", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  grupoId String
	 * @return String
	 */
	@RequestMapping(value = "/{grupoId}", method = RequestMethod.GET)
	public @ResponseBody Grupo getById(@PathVariable String grupoId) {
		try{
            Grupo grupo = new Grupo();
			grupo.setGrupoId(grupoId);
            grupo = this.grupoService.find(grupo);
            if (grupo == null) {
                throw new Exception(grupoId.toString());
            }
            return grupo;
		}catch (Exception e){
		    throw new ResourceNotFoundException(grupoId.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  grupoId String
	 *@param	  nivel BigDecimal
	 *@param	  nombreEs String
	 *@param	  nombreEu String
	 *@param	  grupoPadreId String
	 *@param	  activa String
	 *@param	  usuultmod String
	 *@param	  fecultmod Date
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "grupoId", required = false) String grupoId,
	@RequestParam(value = "nivel", required = false) BigDecimal nivel,
	@RequestParam(value = "nombreEs", required = false) String nombreEs,
	@RequestParam(value = "nombreEu", required = false) String nombreEu,
	@RequestParam(value = "grupoPadreId", required = false) String grupoPadreId,
	@RequestParam(value = "activa", required = false) String activa,
	@RequestParam(value = "usuultmod", required = false) String usuultmod,
	@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			HttpServletRequest request) {
			try{
				Grupo filterGrupo = new Grupo(grupoId, nivel, nombreEs, nombreEu, grupoPadreId, activa, usuultmod, fecultmod);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Grupo> grupos =  this.grupoService.findAll(filterGrupo, pagination);

     			    if (grupos == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterGrupo, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(grupos);
				    return data;
				}else{
				    List<Grupo> grupos =  this.grupoService.findAll(filterGrupo, pagination);
					if (grupos == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return grupos;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterGrupo Grupo 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "grupo", required = false) Grupo  filterGrupo, HttpServletRequest request) {
	    try {
			return grupoService
					.findAllCount(filterGrupo != null ? filterGrupo
							: new Grupo ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param grupo Grupo 
	 * @param response HttpServletResponse
	 * @return Grupo
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Grupo edit(@RequestBody Grupo grupo, HttpServletResponse response) {		
		try {
            Grupo grupoAux  = this.grupoService.update(grupo);
			logger.info("Entity correctly inserted!");
            return grupoAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param grupo Grupo 
	 * @return Grupo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Grupo add(@RequestBody Grupo grupo) {		
        try {
            Grupo grupoAux = this.grupoService.add(grupo);
            logger.info("Entity correctly inserted!");
        	return grupoAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  grupoId  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{grupoId}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String grupoId,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Grupo grupo = new Grupo();
            grupo.setGrupoId(grupoId);
            this.grupoService.remove(grupo);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  grupoId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  grupoIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> grupoIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Grupo> grupoList = new ArrayList<Grupo>();
        try{		    
            for (ArrayList<String> grupoId:grupoIds) {
			    Iterator<String> iterator = grupoId.iterator();
				    Grupo grupo = new Grupo();
			        grupo.setGrupoId(ObjectConversionManager.convert(iterator.next(), String.class));
				    grupoList.add(grupo);
		    }
            this.grupoService.removeMultiple(grupoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getGrupoService'.
	 *
	 * @return GrupoService
	 */
	protected GrupoService getGrupoService() {
		return this.grupoService;
	}

	/**
	 * Method 'setGrupoService'.
	 *
	 * @param grupoService  GrupoService
	 * @return
	 */
	public void setGrupoService(GrupoService grupoService) {
		this.grupoService = grupoService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
	/**
	 * Method 'unBind' CategoriaGrupos
	 *
	 * @param grupoId String
	 * @param categoriaIdCat String 
	 * @return	 
	 */
	@RequestMapping(value = "/unbindCategoriaGrupos", method = RequestMethod.POST)
	public void unBindCategoriaGrupos(
	  @RequestParam(value = "grupoId", required = false) String grupoId,
				@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat
	  ) {
		Grupo grupo= new Grupo();
		Categoria     categoria = new Categoria();
		if (grupoId!= null ){
				grupo.setGrupoId(grupoId);
		}
		if (categoriaIdCat!= null ){
		    categoria.setIdCat(categoriaIdCat);
		}
		grupo.getCategorias().add(categoria);
	    this.grupoService.removeCategoriaGrupos(grupo);    
	}
	
	/**
	 * Method 'bind' CategoriaGrupos
	 *
	 * @param grupoId String
	 * @param categoriaIdCat String 
	 */
	@RequestMapping(value = "/bindCategoriaGrupos", method = RequestMethod.POST)
	public void bindCategoriaGrupos(
	  @RequestParam(value = "grupoId", required = false) String grupoId,
				@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat
	  ) {
		Grupo grupo= new Grupo();
		Categoria     categoria = new Categoria();
		if (grupoId!= null ){
				grupo.setGrupoId(grupoId);
		}
		if (categoriaIdCat!= null ){
		    categoria.setIdCat(categoriaIdCat);
		}
		grupo.getCategorias().add(categoria);
	    this.grupoService.addCategoriaGrupos(grupo);    
	}
}	
	
