package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.FormacionBusqueda;
import com.ejie.y40a.model.FormacionDetalle;
import com.ejie.y40a.service.FormacionService;
import com.ejie.y40a.service.Y40aExcelGeneratorService;
import com.ejie.y40a.utils.Y40aUtils;
import com.ejie.y40a.utils.exception.Y40aUDAErrorManager;
import com.ejie.y40a.utils.exception.Y40aUDAException;

/**
 * * FormacionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/formacion")
public class FormacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(FormacionController.class);

	@Autowired
	private FormacionService formacionService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y40aExcelGeneratorService y40aExcelGeneratorService;

	/*
	 * --------------------------------------------------------------------
	 * ---INICIO------------ Tratamiento de errores comun para los proyectos
	 * UDA. --------------------------------------------------------------------
	 */
	@Autowired
	private Y40aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y40aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y40aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y40aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------------------------------------------------------------
	 * ---FIN------------ Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("formacion", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aFormacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacion(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aFormacion", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aFormacionAlta", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacionAlta(
			@RequestParam(value = "formaAltaC", required = false) String formaAltaC,
			@RequestParam(value = "formaAltaE", required = false) String formaAltaE,
			Model model) {

		model.addAttribute("feddformaAltaC", formaAltaC);
		model.addAttribute("feddformaAltaE", formaAltaE);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aFormacion", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aFormacionModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacionModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aFormacionModal", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aFormacionesBusqueda", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aFormacionesBusqueda(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aFormacionesBusqueda", "model", model);
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param idCat_
	 *            String
	 * @param nombre_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param visibleWeb_
	 *            String
	 * @param sortorder_
	 *            String
	 * @param sortname_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getResultadoConsultaDinamicaBusqueda(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb_,
			@RequestParam(value = "sortorder", required = false) String sortorder_,
			@RequestParam(value = "sortname", required = false) String sortname_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;
			// control checks
			String visibleWeb = ("on".equals(visibleWeb_)) ? null
					: Y40aConstantes.SI;

			Pagination pagination = new Pagination();
			pagination.setSort(sortname_);
			pagination.setAscDsc(sortorder_);

			FormacionBusqueda filterFormacionBusqueda = new FormacionBusqueda();

			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			filterFormacionBusqueda.setIdCat(idCat);
			filterFormacionBusqueda.setNombre(nombre);
			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterFormacionBusqueda.setEtiquetas(etiquetas);
			filterFormacionBusqueda.setMostrarOcultasWeb(visibleWeb);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			List<FormacionBusqueda> formacionBusquedaList = this.formacionService
					.findAllLikeFormacion(filterFormacionBusqueda, perfiles,
							pagination, false);

			Date fechaHoy = new Date();
			String fechaActual = Y40aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombreform = "formacion" + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreform + "\"");

			String xslString = this.y40aExcelGeneratorService
					.getFormacionBusquedaListaExcel(formacionBusquedaList);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'addFormacion'.
	 * 
	 * @param formacionDetalle
	 *            FormacionDetalle
	 * 
	 * @return Formacion
	 */
	@RequestMapping(value = "/altaFormacion", method = RequestMethod.POST)
	public @ResponseBody
	Formacion addFormacion(@RequestBody FormacionDetalle formacionDetalle) {
		try {

			Formacion formacion = new Formacion();
			Categoria categoria = new Categoria();
			categoria.setIdCat(formacionDetalle.getIdCat());
			formacion.setCategoria(categoria);
			formacion.setNombreEs(formacionDetalle.getNombreEs());
			formacion.setNombreEu(formacionDetalle.getNombreEu());
			formacion.setNombreCortoEs(formacionDetalle.getNombreCortoEs());
			formacion.setNombreCortoEu(formacionDetalle.getNombreCortoEu());
			formacion.setDescripcionEs(formacionDetalle.getDescripcionEs());
			formacion.setDescripcionEu(formacionDetalle.getDescripcionEu());
			formacion.setVisibleWeb(formacionDetalle.getVisibleWeb());
			formacion
					.setNueva(("on".equals(formacionDetalle.getNueva())) ? Y40aConstantes.SI
							: Y40aConstantes.NO);

			String idsEtiquetas = formacionDetalle.getIdsEtiquetas();

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}

			formacion.setEtiquetas(etiquetas);

			Formacion formacionAux = this.formacionService
					.addFormacion(formacion);
			logger.info("Entity correctly inserted!");
			return formacionAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed - /formacion/altaFormacion");
		}
	}

	/**
	 * Method 'editFormacion'.
	 * 
	 * @param formacionDetalle
	 *            FormacionDetalle
	 * 
	 * @return Formacion
	 */
	@RequestMapping(value = "/edicionFormacion", method = RequestMethod.PUT)
	public @ResponseBody
	Formacion editFormacion(@RequestBody FormacionDetalle formacionDetalle) {
		try {

			Formacion formacion = new Formacion();
			Categoria categoria = new Categoria();
			categoria.setIdCat(formacionDetalle.getIdCat());
			formacion.setIdFor(formacionDetalle.getIdFor());
			formacion.setCategoria(categoria);
			formacion.setNombreEs(formacionDetalle.getNombreEs());
			formacion.setNombreEu(formacionDetalle.getNombreEu());
			formacion.setNombreCortoEs(formacionDetalle.getNombreCortoEs());
			formacion.setNombreCortoEu(formacionDetalle.getNombreCortoEu());
			formacion.setDescripcionEs(formacionDetalle.getDescripcionEs());
			formacion.setDescripcionEu(formacionDetalle.getDescripcionEu());
			formacion.setVisibleWeb(formacionDetalle.getVisibleWeb());
			formacion
					.setNueva(("on".equals(formacionDetalle.getNueva())) ? Y40aConstantes.SI
							: Y40aConstantes.NO);

			String idsEtiquetas = formacionDetalle.getIdsEtiquetas();

			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			formacion.setEtiquetas(etiquetas);

			Formacion formacionAux = this.formacionService
					.updateFormacion(formacion);
			logger.info("Entity correctly inserted!");
			return formacionAux;
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed - /formacion/edicionFormacion");
		}
	}

	/**
	 * Method 'removeFormacionTramite'.
	 * 
	 * @param idFor
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarFormacion/{idFor}", method = RequestMethod.DELETE)
	public void eliminarFormacion(@PathVariable String idFor,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			this.formacionService.removeFormacion(formacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y40aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + idFor);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'ocultarWebFormacion'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/ocultarWebFormacion/{idFor}", method = RequestMethod.PUT)
	public @ResponseBody
	Formacion ocultarWebFormacion(@PathVariable String idFor) {
		try {

			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion.setVisibleWeb(Y40aConstantes.NO);
			formacion = this.formacionService.updateVisibleWeb(formacion);
			return formacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'mostrarWebFormacion'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/mostrarWebFormacion/{idFor}", method = RequestMethod.PUT)
	public @ResponseBody
	Formacion mostrarWebFormacion(@PathVariable String idFor) {
		try {

			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion.setVisibleWeb(Y40aConstantes.SI);
			formacion = this.formacionService.updateVisibleWeb(formacion);
			return formacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'getAllLike'.
	 * 
	 * @param idCat_
	 *            String
	 * @param nombre_
	 *            String
	 * @param idsEtiquetas_
	 *            String
	 * @param visibleWeb_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLike(
			@RequestParam(value = "idCat", required = false) String idCat_,
			@RequestParam(value = "nombre", required = false) String nombre_,
			@RequestParam(value = "idsEtiquetas", required = false) String idsEtiquetas_,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String idCat = ("".equals(idCat_)) ? null : idCat_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String idsEtiquetas = ("".equals(idsEtiquetas_)) ? null
					: idsEtiquetas_;
			// control checks
			String visibleWeb = ("on".equals(visibleWeb_)) ? null
					: Y40aConstantes.SI;

			FormacionBusqueda filterFormacionBusqueda = new FormacionBusqueda();
			Categoria categoria = new Categoria();
			categoria.setIdCat(idCat);
			filterFormacionBusqueda.setIdCat(idCat);
			filterFormacionBusqueda.setNombre(nombre);
			List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsEtiquetas && !"".equals(idsEtiquetas)) {
				Etiqueta etiqueta = null;
				for (String id : idsEtiquetas.split(",")) {
					etiqueta = new Etiqueta();// NOPMD 2012/02/29 (IDA)
					etiqueta.setIdEtiqueta(id);
					etiquetas.add(etiqueta);
				}
			}
			filterFormacionBusqueda.setEtiquetas(etiquetas);
			filterFormacionBusqueda.setMostrarOcultasWeb(visibleWeb);

			Vector<String> perfiles = (Vector<String>) request.getSession()
					.getAttribute("UserProfiles");

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<FormacionBusqueda> formacionesBusqueda = this.formacionService
						.findAllLikeFormacion(filterFormacionBusqueda,
								perfiles, pagination, false);

				if (formacionesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.formacionService.findAllLikeFormacionCount(
						filterFormacionBusqueda, perfiles, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(formacionesBusqueda);
				return data;
			} else {
				List<FormacionBusqueda> formacionesBusqueda = this.formacionService
						.findAllLikeFormacion(filterFormacionBusqueda,
								perfiles, pagination, false);
				if (formacionesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return formacionesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdFormacion'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/getByIdFormacion/{idFor}", method = RequestMethod.GET)
	public @ResponseBody
	FormacionDetalle getByIdFormacion(@PathVariable String idFor) {
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion = this.formacionService.findFormacion(formacion);
			if (formacion == null) {
				throw new Exception(idFor.toString());
			}

			FormacionDetalle formacionDetalle = new FormacionDetalle();
			formacionDetalle.setIdFor(formacion.getIdFor());
			formacionDetalle.setNombreCortoEs(formacion.getNombreCortoEs());
			formacionDetalle.setNombreCortoEu(formacion.getNombreCortoEu());
			formacionDetalle.setNombreEs(formacion.getNombreEs());
			formacionDetalle.setNombreEu(formacion.getNombreEu());
			formacionDetalle.setDescripcionEs(formacion.getDescripcionEs());
			formacionDetalle.setDescripcionEu(formacion.getDescripcionEu());
			formacionDetalle.setIdCat(formacion.getCategoria().getIdCat());
			formacionDetalle.setJerarquiaCategoria(formacion.getCategoria()
					.getJerarquiaCategoria());
			formacionDetalle.setJerarquiaFormacion(formacion
					.getJerarquiaFormacion());
			formacionDetalle.setVisibleWeb(formacion.getVisibleWeb());
			formacionDetalle.setVisibleContactoCat(formacion
					.getVisibleContactoCat());
			formacionDetalle.setNueva(formacion.getNueva());

			formacion = this.formacionService.findFormacionEtiqueta(formacion,
					null, null);
			List<Etiqueta> lstEtiquetasFormacion = formacion.getEtiquetas();
			List<String> lstIdsEtiquetas = new ArrayList<String>();
			List<String> lstDescsEtiquetas = new ArrayList<String>();
			StringBuffer strIdsEtiquetas = new StringBuffer();
			StringBuffer strDescsEtiquetas = new StringBuffer();

			strDescsEtiquetas.append("[");

			boolean firstElement = true;

			// se recorre para obtener los ids de etiquetas
			for (Etiqueta etiqueta : lstEtiquetasFormacion) {
				lstIdsEtiquetas.add(etiqueta.getIdEtiqueta());
				lstDescsEtiquetas.add(etiqueta.getNombre());
				if (firstElement) {
					strIdsEtiquetas.append(etiqueta.getIdEtiqueta());
					strDescsEtiquetas.append(etiqueta.getNombre());
					firstElement = false;
				} else {
					strIdsEtiquetas.append(",")
							.append(etiqueta.getIdEtiqueta());
					strDescsEtiquetas.append(",").append(etiqueta.getNombre());
				}
			}
			strDescsEtiquetas.append("]");

			formacionDetalle.setIdsEtiquetas(strIdsEtiquetas.toString());
			formacionDetalle.setDescsEtiquetas(strDescsEtiquetas.toString());

			return formacionDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idFor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idFor}", method = RequestMethod.GET)
	public @ResponseBody
	Formacion getById(@PathVariable String idFor) {
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			formacion = this.formacionService.find(formacion);
			if (formacion == null) {
				throw new Exception(idFor.toString());
			}
			return formacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idFor.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idFor
	 *            String
	 * @param categoriaIdCat
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param nombreCortoEs
	 *            String
	 * @param nombreCortoEu
	 *            String
	 * @param descripcionEs
	 *            String
	 * @param descripcionEu
	 *            String
	 * @param visibleWeb
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idFor", required = false) String idFor,
			@RequestParam(value = "categoriaIdCat", required = false) String categoriaIdCat,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "nombreCortoEs", required = false) String nombreCortoEs,
			@RequestParam(value = "nombreCortoEu", required = false) String nombreCortoEu,
			@RequestParam(value = "descripcionEs", required = false) String descripcionEs,
			@RequestParam(value = "descripcionEu", required = false) String descripcionEu,
			@RequestParam(value = "visibleWeb", required = false) String visibleWeb,
			HttpServletRequest request) {
		try {
			Formacion filterFormacion = new Formacion(idFor, nombreEs,
					nombreEu, nombreCortoEs, nombreCortoEu, descripcionEs,
					descripcionEu, visibleWeb, null, new Categoria(
							categoriaIdCat, null, null, null, null, null, null,
							null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Formacion> formacions = this.formacionService.findAll(
						filterFormacion, pagination);

				if (formacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterFormacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(formacions);
				return data;
			} else {
				List<Formacion> formacions = this.formacionService.findAll(
						filterFormacion, pagination);
				if (formacions == null) {
					throw new Exception("No data Found.");
				}
				return formacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterFormacion
	 *            Formacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "formacion", required = false) Formacion filterFormacion,
			HttpServletRequest request) {
		try {
			return formacionService
					.findAllCount(filterFormacion != null ? filterFormacion
							: new Formacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param response
	 *            HttpServletResponse
	 * @return Formacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Formacion edit(@RequestBody Formacion formacion,
			HttpServletResponse response) {
		try {
			Formacion formacionAux = this.formacionService.update(formacion);
			logger.info("Entity correctly inserted!");
			return formacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Formacion add(@RequestBody Formacion formacion) {
		try {
			Formacion formacionAux = this.formacionService.add(formacion);
			logger.info("Entity correctly inserted!");
			return formacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idFor
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{idFor}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idFor, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Formacion formacion = new Formacion();
			formacion.setIdFor(idFor);
			this.formacionService.remove(formacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + idFor);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param formacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> formacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Formacion> formacionList = new ArrayList<Formacion>();
		try {
			for (ArrayList<String> formacionId : formacionIds) {
				Iterator<String> iterator = formacionId.iterator();
				Formacion formacion = new Formacion();
				formacion.setIdFor(ObjectConversionManager.convert(
						iterator.next(), String.class));
				formacionList.add(formacion);
			}
			this.formacionService.removeMultiple(formacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getFormacionService'.
	 * 
	 * @return FormacionService
	 */
	protected FormacionService getFormacionService() {
		return this.formacionService;
	}

	/**
	 * Method 'setFormacionService'.
	 * 
	 * @param formacionService
	 *            FormacionService
	 * @return
	 */
	public void setFormacionService(FormacionService formacionService) {
		this.formacionService = formacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' FormacionEtiqueta
	 * 
	 * @param idFor
	 *            String
	 * @param etiquetaIdEtiqueta
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindFormacionEtiqueta", method = RequestMethod.POST)
	public void unBindFormacionEtiqueta(
			@RequestParam(value = "idFor", required = false) String idFor,
			@RequestParam(value = "etiquetaIdEtiqueta", required = false) String etiquetaIdEtiqueta) {
		Formacion formacion = new Formacion();
		Etiqueta etiqueta = new Etiqueta();
		if (idFor != null) {
			formacion.setIdFor(idFor);
		}
		if (etiquetaIdEtiqueta != null) {
			etiqueta.setIdEtiqueta(etiquetaIdEtiqueta);
		}
		formacion.getEtiquetas().add(etiqueta);
		this.formacionService.removeFormacionEtiqueta(formacion);
	}

	/**
	 * Method 'bind' FormacionEtiqueta
	 * 
	 * @param idFor
	 *            String
	 * @param etiquetaIdEtiqueta
	 *            String
	 */
	@RequestMapping(value = "/bindFormacionEtiqueta", method = RequestMethod.POST)
	public void bindFormacionEtiqueta(
			@RequestParam(value = "idFor", required = false) String idFor,
			@RequestParam(value = "etiquetaIdEtiqueta", required = false) String etiquetaIdEtiqueta) {
		Formacion formacion = new Formacion();
		Etiqueta etiqueta = new Etiqueta();
		if (idFor != null) {
			formacion.setIdFor(idFor);
		}
		if (etiquetaIdEtiqueta != null) {
			etiqueta.setIdEtiqueta(etiquetaIdEtiqueta);
		}
		formacion.getEtiquetas().add(etiqueta);
		this.formacionService.addFormacionEtiqueta(formacion);
	}
}
