package com.ejie.y40a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.service.EtiquetaService;
import com.ejie.y40a.service.FormacionService;
import com.ejie.y40a.service.SolicitudService;
import com.ejie.y40a.utils.tree.Y40aEtiquetasTree;

/**
 * * EtiquetaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/etiqueta")
public class EtiquetaController {

	private static final Logger logger = LoggerFactory
			.getLogger(EtiquetaController.class);

	@Autowired
	private EtiquetaService etiquetaService;
	@Autowired
	private FormacionService formacionService;
	@Autowired
	private SolicitudService solicitudService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.layout"));
		return new ModelAndView("etiqueta", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y40aSeleccionEtiquetas", method = RequestMethod.GET)
	public ModelAndView getCreateFormY40aSeleccionEtiquetas(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y40aVistaWar.default.language"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y40aSeleccionEtiquetas", "model", model);
	}

	/**
	 * Loading Main tree de la lista de etiquetas
	 * 
	 * @param origenEtiquetas
	 *            String
	 * @param modoEtiquetas
	 *            String
	 * @param idOrigen
	 *            String
	 * @param idsEtiquetasSeleccionadas
	 *            String
	 * 
	 * @param nombreEtiquetaFiltro_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "arbolEtiquetas", method = RequestMethod.GET)
	public void showListaEtiquetas(
			@RequestParam(value = "origenEtiquetas", required = false) String origenEtiquetas,
			@RequestParam(value = "modoEtiquetas", required = false) String modoEtiquetas,
			@RequestParam(value = "idOrigen", required = false) String idOrigen,
			@RequestParam(value = "idsEtiquetasSeleccionadas", required = false) String idsEtiquetasSeleccionadas,
			@RequestParam(value = "nombreEtiquetaFiltro", required = false) String nombreEtiquetaFiltro_,
			HttpServletResponse response) throws IOException {
		try {

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");
			PrintWriter out = response.getWriter();

			// control de los campos susceptibles de llegar a "" desde el filtro
			String nombreEtiquetaFiltro = ("".equals(nombreEtiquetaFiltro_)) ? null
					: nombreEtiquetaFiltro_;

			Etiqueta etiquetaAux = new Etiqueta();
			if (nombreEtiquetaFiltro != null) {
				etiquetaAux.setNombre(nombreEtiquetaFiltro);
			} else {
				etiquetaAux = null;
			}

			// Obtiene lista completa de etiquetas
			List<Etiqueta> lstEtiquetasCompletas = this.etiquetaService
					.findAll(etiquetaAux, null);
			// Se inicializa la lista de etiquetas seleccionadas
			List<String> selectedIdList = new ArrayList<String>();

			// rellenar la lista de etiquetas con las que ya vienen
			// seleccionadas
			String[] arrIdsEtiquetasSeleccionadas;
			String strDelimitador = ",";
			arrIdsEtiquetasSeleccionadas = idsEtiquetasSeleccionadas
					.split(strDelimitador);
			for (int i = 0; i < arrIdsEtiquetasSeleccionadas.length; i++)
				selectedIdList.add(arrIdsEtiquetasSeleccionadas[i]);

			// Se inicializa la lista de etiquetas del origen
			List<Etiqueta> lstEtiquetasOrigen = null;

			// MODO : busqueda / edicion
			if (modoEtiquetas.equalsIgnoreCase("modificacion")) {
				// Se obtiene la lista de etiquetas del origen
				if (origenEtiquetas.equalsIgnoreCase("formacion")) {
					// con el id formacion se monta el objeto y se hace la
					// consulta
					// del
					// mismo
					Formacion formacion = new Formacion();
					formacion.setIdFor(idOrigen);
					formacion = this.formacionService.findFormacionEtiqueta(
							formacion, null, null);
					// con el objeto entero se coge su lista de etiquetas
					lstEtiquetasOrigen = formacion.getEtiquetas();
					// se recorre para obtener los ids de etiquetas
					for (Etiqueta etiqueta : lstEtiquetasOrigen) {
						selectedIdList.add(etiqueta.getIdEtiqueta());
					}
				} else if (origenEtiquetas.equalsIgnoreCase("solicitudes")) {
					Solicitud solicitud = new Solicitud();
					solicitud.setIdSol(idOrigen);
					solicitud = this.solicitudService.findSolicitudEtiqueta(
							solicitud, null, null);
					lstEtiquetasOrigen = solicitud.getEtiquetas();
					// se recorre para obtener los ids de etiquetas
					for (Etiqueta etiqueta : lstEtiquetasOrigen) {
						selectedIdList.add(etiqueta.getIdEtiqueta());
					}
				}
			}
			String json = Y40aEtiquetasTree.obtieneJsonArbol(
					lstEtiquetasCompletas, selectedIdList);
			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException(idOrigen);
		}

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idEtiqueta}", method = RequestMethod.GET)
	public @ResponseBody
	Etiqueta getById(@PathVariable String idEtiqueta) {
		try {
			Etiqueta etiqueta = new Etiqueta();
			etiqueta.setIdEtiqueta(idEtiqueta);
			etiqueta = this.etiquetaService.find(etiqueta);
			if (etiqueta == null) {
				throw new Exception(idEtiqueta.toString());
			}
			return etiqueta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idEtiqueta.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param nombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idEtiqueta", required = false) String idEtiqueta,
			@RequestParam(value = "nombre", required = false) String nombre,
			HttpServletRequest request) {
		try {
			Etiqueta filterEtiqueta = new Etiqueta(idEtiqueta, nombre);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Etiqueta> etiquetas = this.etiquetaService.findAll(
						filterEtiqueta, pagination);

				if (etiquetas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEtiqueta, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(etiquetas);
				return data;
			} else {
				List<Etiqueta> etiquetas = this.etiquetaService.findAll(
						filterEtiqueta, pagination);
				if (etiquetas == null) {
					throw new Exception("No data Found.");
				}
				return etiquetas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEtiqueta
	 *            Etiqueta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "etiqueta", required = false) Etiqueta filterEtiqueta,
			HttpServletRequest request) {
		try {
			return etiquetaService
					.findAllCount(filterEtiqueta != null ? filterEtiqueta
							: new Etiqueta());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param response
	 *            HttpServletResponse
	 * @return Etiqueta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Etiqueta edit(@RequestBody Etiqueta etiqueta, HttpServletResponse response) {
		try {
			Etiqueta etiquetaAux = this.etiquetaService.update(etiqueta);
			logger.info("Entity correctly inserted!");
			return etiquetaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Etiqueta add(@RequestBody Etiqueta etiqueta) {
		try {
			Etiqueta etiquetaAux = this.etiquetaService.add(etiqueta);
			logger.info("Entity correctly inserted!");
			return etiquetaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/{idEtiqueta}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idEtiqueta,
			HttpServletResponse response, HttpServletRequest request) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Etiqueta etiqueta = new Etiqueta();
			etiqueta.setIdEtiqueta(idEtiqueta);
			this.etiquetaService.remove(etiqueta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {

			// Obtener el mensaje dependiendo del idioma
			Locale locale = LocaleContextHolder.getLocale();
			String msgError = appMessageSource.getMessage(
					"error.etiqueta.usada", null, locale);

			logger.error("Unable to delete " + idEtiqueta);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(msgError);
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param etiquetaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> etiquetaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Etiqueta> etiquetaList = new ArrayList<Etiqueta>();
		try {
			for (ArrayList<String> etiquetaId : etiquetaIds) {
				Iterator<String> iterator = etiquetaId.iterator();
				Etiqueta etiqueta = new Etiqueta();
				etiqueta.setIdEtiqueta(ObjectConversionManager.convert(
						iterator.next(), String.class));
				etiquetaList.add(etiqueta);
			}
			this.etiquetaService.removeMultiple(etiquetaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEtiquetaService'.
	 * 
	 * @return EtiquetaService
	 */
	protected EtiquetaService getEtiquetaService() {
		return this.etiquetaService;
	}

	/**
	 * Method 'setEtiquetaService'.
	 * 
	 * @param etiquetaService
	 *            EtiquetaService
	 * @return
	 */
	public void setEtiquetaService(EtiquetaService etiquetaService) {
		this.etiquetaService = etiquetaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' FormacionEtiqueta
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param formacionIdFor
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindFormacionEtiqueta", method = RequestMethod.POST)
	public void unBindFormacionEtiqueta(
			@RequestParam(value = "idEtiqueta", required = false) String idEtiqueta,
			@RequestParam(value = "formacionIdFor", required = false) String formacionIdFor) {
		Etiqueta etiqueta = new Etiqueta();
		Formacion formacion = new Formacion();
		if (idEtiqueta != null) {
			etiqueta.setIdEtiqueta(idEtiqueta);
		}
		if (formacionIdFor != null) {
			formacion.setIdFor(formacionIdFor);
		}
		etiqueta.getFormacions().add(formacion);
		this.etiquetaService.removeFormacionEtiqueta(etiqueta);
	}

	/**
	 * Method 'bind' FormacionEtiqueta
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param formacionIdFor
	 *            String
	 */
	@RequestMapping(value = "/bindFormacionEtiqueta", method = RequestMethod.POST)
	public void bindFormacionEtiqueta(
			@RequestParam(value = "idEtiqueta", required = false) String idEtiqueta,
			@RequestParam(value = "formacionIdFor", required = false) String formacionIdFor) {
		Etiqueta etiqueta = new Etiqueta();
		Formacion formacion = new Formacion();
		if (idEtiqueta != null) {
			etiqueta.setIdEtiqueta(idEtiqueta);
		}
		if (formacionIdFor != null) {
			formacion.setIdFor(formacionIdFor);
		}
		etiqueta.getFormacions().add(formacion);
		this.etiquetaService.addFormacionEtiqueta(etiqueta);
	}

	/**
	 * Method 'unBind' SolicitudEtiqueta
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param solicitudIdSol
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindSolicitudEtiqueta", method = RequestMethod.POST)
	public void unBindSolicitudEtiqueta(
			@RequestParam(value = "idEtiqueta", required = false) String idEtiqueta,
			@RequestParam(value = "solicitudIdSol", required = false) String solicitudIdSol) {
		Etiqueta etiqueta = new Etiqueta();
		Solicitud solicitud = new Solicitud();
		if (idEtiqueta != null) {
			etiqueta.setIdEtiqueta(idEtiqueta);
		}
		if (solicitudIdSol != null) {
			solicitud.setIdSol(solicitudIdSol);
		}
		etiqueta.getSolicituds().add(solicitud);
		this.etiquetaService.removeSolicitudEtiqueta(etiqueta);
	}

	/**
	 * Method 'bind' SolicitudEtiqueta
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param solicitudIdSol
	 *            String
	 */
	@RequestMapping(value = "/bindSolicitudEtiqueta", method = RequestMethod.POST)
	public void bindSolicitudEtiqueta(
			@RequestParam(value = "idEtiqueta", required = false) String idEtiqueta,
			@RequestParam(value = "solicitudIdSol", required = false) String solicitudIdSol) {
		Etiqueta etiqueta = new Etiqueta();
		Solicitud solicitud = new Solicitud();
		if (idEtiqueta != null) {
			etiqueta.setIdEtiqueta(idEtiqueta);
		}
		if (solicitudIdSol != null) {
			solicitud.setIdSol(solicitudIdSol);
		}
		etiqueta.getSolicituds().add(solicitud);
		this.etiquetaService.addSolicitudEtiqueta(etiqueta);
	}
}
